/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webelement;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.IRemoteUserDirectory;
import net.gopro.selfservice.ISelfServiceModule;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.DirectoryUser;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Module;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.UserRole;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.ModuleException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.pages.portal.DefaultPage;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.MessageService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.webelement.PublicPageController;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class PortalPageController
extends PublicPageController {
    private static Logger logger = Logger.getLogger(PortalPageController.class);
    private static HashMap<String, String> pageClasses = new HashMap();
    private static boolean isMunicipality = false;
    private static List<String> municipalityCodes = new ArrayList<String>();
    private BasePage handler = null;

    @Override
    public synchronized void init(WebContext context) throws BirdException {
        super.init(context);
        try {
            this.loadPageHandlers();
            User user = this.validateAuthenticatedUser(context);
            if (user != null) {
                this.setUserInfo(user, context.getRequest());
                this.setParamsContext(context, user);
            }
            this.setPageHandlerInstance(context);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public void doDelete(WebContext context, Form data) throws BirdException {
        if (this.handler != null) {
            this.handler.doDelete(context, data);
        } else {
            super.doDelete(context, data);
        }
    }

    public void doAction(WebContext context, Form data) throws BirdException {
        if (this.handler != null) {
            this.handler.doAction(context, data);
        }
    }

    @Override
    public void doGet(WebContext context) throws BirdException {
        this.setNoCacheHeaders(context);
        this.localizePage(context);
        if (this.handler != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doGet: " + context.getRequest().getRequestURI() + " > Handler: " + this.handler.getClass().getName()));
            }
            this.handler.doGet(context);
        }
        super.doGet(context);
    }

    public void doPost(WebContext context) throws BirdException {
        this.setNoCacheHeaders(context);
        if (this.handler != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doPost: " + context.getRequest().getRequestURI() + " > Handler: " + this.handler.getClass().getName()));
            }
            this.handler.doPost(context);
        }
        super.doPost(context);
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        if (this.handler != null) {
            this.handler.doSave(context, data);
        } else {
            super.doSave(context, data);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        if (this.handler != null) {
            return this.handler.querySave(context, data);
        }
        return super.querySave(context, data);
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        if (this.handler != null) {
            return this.handler.queryOpen(context, data);
        }
        return super.queryOpen(context, data);
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        if (this.handler != null) {
            this.handler.doXML(context, data);
        }
        super.doXML(context, data);
    }

    private void loadPageHandlers() throws SelfServiceException {
        Set<ConfigEntry> handlers = ConfigService.getConfig("pages");
        for (ConfigEntry entry : handlers) {
            pageClasses.put(entry.getKey(), entry.getValue());
        }
    }

    private void setPageHandlerInstance(WebContext context) throws BirdException {
        boolean isLocalized = context.getAttribute("localized") != null && (Boolean)context.getAttribute("localized") != false;
        String pageName = isLocalized ? (String)context.getAttribute("basepage") : context.getPageName();
        if ((pageName = pageName.replace("portal/", "")).contains("/")) {
            String[] tokens = pageName.split("/");
            pageName = tokens[tokens.length - 1].replaceAll("(_)([a-z]+){2}{3}", "");
        }
        logger.debug((Object)("Find page handler: " + pageName + " Localized: " + isLocalized));
        String handlerClass = pageClasses.get(pageName);
        if (handlerClass != null) {
            try {
                this.handler = (BasePage)Class.forName(handlerClass).newInstance();
                this.handler.init(context, this.dataroot, this.resourceBundle);
            }
            catch (Exception ex) {
                logger.error((Object)("Self Service Portal Page handler " + handlerClass + " could not be loaded or was not in classpath. Details: " + ex.getMessage()));
                try {
                    this.handler = (BasePage)Class.forName(DefaultPage.class.getName()).newInstance();
                    this.handler.init(context, this.dataroot, this.resourceBundle);
                }
                catch (Exception fex) {
                    throw new BirdException(fex);
                }
            }
        } else {
            try {
                this.handler = (BasePage)Class.forName(DefaultPage.class.getName()).newInstance();
                this.handler.init(context, this.dataroot, this.resourceBundle);
            }
            catch (Exception ex) {
                logger.error((Object)"Could not create Default Page instance");
                throw new BirdException("Could not create Default Page instance." + ex);
            }
        }
    }

    protected void setParamsContext(WebContext context, User user) {
        if (paramsEnabled && "metadata".equalsIgnoreCase(paramsStorage)) {
            for (String paramKey : validParamsKeys) {
                String value;
                MetaData meta = user.getMetaDataByKey(paramKey);
                if (meta == null || !StringUtil.isValid(meta.getValue()) || !StringUtil.isValid(value = meta.getValue().replaceAll("[^a-zA-Z0-9_\\s]", "")) || value.length() > 255) continue;
                this.dataroot.addAttribute(meta.getKey(), value);
            }
        }
    }

    private void setUserInfo(User user, HttpServletRequest request) throws SelfServiceException {
        Element el = this.dataroot.addElement("user");
        el.addElement("user_id").setText(user.getId());
        Dom4JUtil.addElement(el, "username", user.getUsername());
        Dom4JUtil.addElement(el, "fullname", user.getFullname());
        Dom4JUtil.addElement(el, "email", user.getEmail());
        Dom4JUtil.addElement(el, "initials", user.getInitials());
        Dom4JUtil.addElement(el, "picture", user.getProfileImage());
        Dom4JUtil.addElement(el, "readonly-access", String.valueOf(user.isReadOnlyRestricted()));
        if (user.getLocale() != null) {
            Dom4JUtil.addElement(el, "locale", user.getLocale());
        } else {
            Dom4JUtil.addElement(el, "locale", LocaleUtil.getDefaultLocale().getLanguage());
        }
        Principal principal = request.getUserPrincipal();
        if (principal instanceof BirdUserPrincipal) {
            Dom4JUtil.addElement(el, "x509-login", String.valueOf(((BirdUserPrincipal)principal).isCertificateAuthentication()));
        } else {
            Dom4JUtil.addElement(el, "x509-login", "false");
        }
        for (UserRole userRole : user.getUserRoles()) {
            Dom4JUtil.addElement(el, "role", userRole.getSubject());
        }
        if (user.isContact()) {
            Dom4JUtil.addElement(el, "is-contact-manager", String.valueOf(user.isContactManager()));
            Element cel = el.addElement("contacts");
            for (Contact contact : user.getContactList()) {
                Element celx = cel.addElement("contact");
                celx.addAttribute("id", contact.getId());
                celx.addAttribute("company_id", contact.getCompanyId());
                Dom4JUtil.addElement(celx, "company", contact.getCompanyName());
                Dom4JUtil.addElement(celx, "email", contact.getEmail());
            }
        }
        if (user.getTargetGroups().size() > 0) {
            Element tel = el.addElement("targetgroups");
            for (TargetGroup tg : user.getTargetGroups()) {
                Element telx = tel.addElement("group");
                telx.addAttribute("id", tg.getId());
                Dom4JUtil.addElement(telx, "subject", tg.getSubject());
            }
        }
        Element elStatus = el.addElement("status");
        Dom4JUtil.addElement(elStatus, "messages", String.valueOf(MessageService.getUnreadMessageCount(user.getId())));
        try {
            IRemoteUserDirectory iRemoteUserDirectory;
            DirectoryUser directoryUser;
            if (isMunicipality && StringUtil.isValid(SelfServiceEngine.getConfig(IRemoteUserDirectory.class.getCanonicalName())) && (directoryUser = (iRemoteUserDirectory = EngineFactory.getCustomEngine(IRemoteUserDirectory.class)).getDirectoryUser(user)) != null) {
                boolean isResident = municipalityCodes.contains(directoryUser.getMunicipalityCode());
                Dom4JUtil.addElement(el, "is-resident", String.valueOf(isResident));
                el.add(directoryUser.getXml());
            }
        }
        catch (Exception exception) {
            log.error("Error using Remote user directory: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            List<Module> list = ConfigService.getModules();
            if (list.size() > 0) {
                Element mel = el.addElement("modules");
                ArrayList<String> aliasList = new ArrayList<String>();
                for (Module module : list) {
                    if (aliasList.contains(module.getAlias())) continue;
                    Element elcm = mel.addElement(module.getAlias());
                    ISelfServiceModule instance = module.getInstance();
                    if (instance.isEnabled(user.getId(), user.getUsername())) {
                        elcm.addAttribute("visible", "true");
                    } else {
                        elcm.addAttribute("visible", "false");
                    }
                    aliasList.add(module.getAlias());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            log.error("Error creating module instance: " + runtimeException.getMessage());
        }
        catch (SelfServiceException selfServiceException) {
            log.error("Error in module check: " + selfServiceException.getMessage());
        }
        catch (ModuleException moduleException) {
            log.error("Error in module check: " + moduleException.getMessage());
        }
    }

    private User validateAuthenticatedUser(WebContext context) throws IOException, SelfServiceException {
        User user = null;
        Principal principal = context.getRequest().getUserPrincipal();
        if (principal != null) {
            user = UserService.getUserByUsername(principal.getName());
            if (user == null) {
                context.getResponse().sendError(401);
            }
        } else {
            context.getResponse().sendError(403);
        }
        return user;
    }

    @Override
    protected String getLocalizedRedirectUrl(WebContext context, boolean fullpath) throws BirdException {
        Principal principal = context.getRequest().getUserPrincipal();
        String requestUrl = context.getRequest().getRequestURI();
        if (requestUrl.endsWith(".html")) {
            String[] urlparts;
            boolean isSupportedLocale;
            String requestLocale = null;
            if (principal instanceof BirdUserPrincipal) {
                requestLocale = ((BirdUserPrincipal)principal).getLocale();
            } else {
                try {
                    User currentUser = UserService.getUserByUsername(principal.getName());
                    requestLocale = currentUser.getLocale();
                }
                catch (SelfServiceException ex) {
                    throw new BirdException((Exception)ex);
                }
            }
            if (requestLocale != null && (isSupportedLocale = LocaleUtil.isAvailableLocale(requestLocale)) && (urlparts = requestUrl.split("/")).length > 1) {
                String localizedPageKey;
                String langKey = requestLocale.split("_")[0];
                String pageKey = urlparts[urlparts.length - 1];
                String lookupPageKey = localizedPageKey = pageKey.replace(".html", "." + langKey + ".html");
                if (principal != null && requestUrl.contains("/portal/")) {
                    lookupPageKey = "portal/" + localizedPageKey;
                }
                logger.debug((Object)("Check for localized page for: " + requestUrl + " in lang: " + requestLocale));
                logger.debug((Object)("Looking for pageKey: " + lookupPageKey + " in lang: " + requestLocale));
                BirdPage birdPage = SelfServiceEngine.getBirdSession().getDatabase().getPageByName(lookupPageKey);
                if (birdPage != null) {
                    context.setAttribute("locale", (Object)requestLocale);
                    context.setAttribute("parentPage", (Object)context.getPageName());
                    context.getResponse().setHeader("language", requestLocale);
                    logger.debug((Object)("Found localized page for pagekey: " + localizedPageKey));
                    if (fullpath) {
                        return context.getRequest().getContextPath() + "/web/" + localizedPageKey;
                    }
                    return localizedPageKey;
                }
            }
        }
        return null;
    }

    protected void setNoCacheHeaders(WebContext context) {
        HttpServletResponse response = context.getResponse();
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    static {
        if ("true".equalsIgnoreCase(SelfServiceEngine.getConfig("municipality.enabled"))) {
            String[] mIds;
            isMunicipality = true;
            for (String mid : mIds = SelfServiceEngine.getConfig("municipality.numbers").split(",")) {
                municipalityCodes.add(mid.trim());
            }
        }
    }
}

