/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webelement;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class FormTemplateList
extends WebElementBase {
    public void doGet(WebContext context) throws BirdException {
        try {
            Element el = context.getRootElement().addElement("formtemplates");
            this.createFormTemplateList(el);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private void createFormTemplateList(Element el) throws SelfServiceException {
        List<FormTemplate> templateList = FormService.getFormTemplates();
        Hashtable bucket = new Hashtable();
        for (FormTemplate ft : templateList) {
            String category = ft.getCategory();
            if (!StringUtil.isValid(category)) continue;
            category = category.toLowerCase();
            if (ft.isDeleted() || !ft.isVisible() || !ft.isWithinDateRestriction() || this.isTargetGroupRestricted(ft)) continue;
            if (bucket.containsKey(category)) {
                ((List)bucket.get(category)).add(ft);
                continue;
            }
            ArrayList<FormTemplate> l = new ArrayList<FormTemplate>();
            l.add(ft);
            bucket.put(category, l);
        }
        List<Object> keys = new ArrayList(bucket.keySet());
        if (bucket.size() > 6) {
            Collections.shuffle(keys);
            keys = keys.subList(0, 6);
        }
        Collections.sort(keys);
        for (String categoryKey : keys) {
            Element elcategory = el.addElement("category");
            elcategory.addAttribute("name", StringUtils.capitalize((String)categoryKey));
            for (FormTemplate template : (List)bucket.get(categoryKey)) {
                elcategory.add(this.createTemplateElement(template));
            }
        }
    }

    private boolean isTargetGroupRestricted(FormTemplate ft) {
        if (ft != null && ft.getExtendedData() != null) {
            return StringUtil.isValid(ft.getExtendedData().getTargetGroupId());
        }
        return false;
    }

    private Element createTemplateElement(FormTemplate template) {
        Organization o;
        Element el = template.getXml();
        if (template.getOrganizations() != null && template.getOrganizations().size() > 0 && (o = template.getOrganizations().get(0)) != null) {
            el.addAttribute("organization", o.getSubject());
            el.addAttribute("alias", o.getAlias());
            el.addAttribute("link", template.getLinkToken(o.getId()));
        }
        return el;
    }
}

