/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import is.hugvit.bird.WebContext;
import java.util.Random;
import java.util.ResourceBundle;
import net.gopro.selfservice.ICaptchaProvider;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.SignatureUtil;
import org.dom4j.Element;

public class SimpleMathCaptcha
implements ICaptchaProvider {
    private int sum;
    private int fieldCount = 2;
    private final String passKey = "Simple.Captcha.Pass";
    private Number[] selectedNumbers = new Number[this.fieldCount];
    private WebContext context;

    public SimpleMathCaptcha() {
        this.generateSum();
    }

    public String getQuestion() {
        ResourceBundle rb = null;
        rb = this.context != null ? LocaleUtil.getResourceBundle("portal.captcha", this.context.getRequest()) : LocaleUtil.getResourceBundle("portal.captcha");
        String math = "";
        for (int i = 0; i < this.fieldCount; ++i) {
            Number number = this.selectedNumbers[i];
            math = math + rb.getString("num." + number.toString().toLowerCase());
            if (i >= this.fieldCount - 1) continue;
            math = math + " " + rb.getString("cap.plus") + " ";
        }
        String question = String.format(rb.getString("cap.title"), math);
        return question;
    }

    public String getChallenge() {
        return SignatureUtil.encryptString(String.valueOf(this.sum), this.passKey);
    }

    public boolean validateAnswer(int answer, String challange) {
        String challangeDescrypted = SignatureUtil.decryptString(challange, this.passKey);
        try {
            int correctAnswer = Integer.parseInt(challangeDescrypted);
            return correctAnswer == answer;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private void generateSum() {
        for (int i = 0; i < this.fieldCount; ++i) {
            Number randNumber;
            int random = new Random().nextInt(Number.values().length);
            this.selectedNumbers[i] = randNumber = Number.values()[random];
            this.sum += randNumber.number.intValue();
        }
    }

    @Override
    public void setRequest(Element el) throws SelfServiceException {
        el.addElement("text").setText(this.getQuestion());
        el.addElement("challenge").setText(this.getChallenge());
    }

    @Override
    public void setContext(WebContext context) throws SelfServiceException {
        this.context = context;
    }

    @Override
    public boolean verify(String response, String challenge) throws SelfServiceException {
        try {
            int iReponse = Integer.parseInt(response);
            return this.validateAnswer(iReponse, challenge);
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static enum Number {
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SIX(6),
        SEVEN(7),
        EIGHT(8),
        NINE(9),
        TEN(10);

        private Integer number;

        private Number(Integer num) {
            this.number = num;
        }
    }
}

