/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.IPDFSigningProvider;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.exceptions.SigningException;
import net.gopro.selfservice.util.ModuleHelper;
import org.apache.log4j.Logger;
import org.jasypt.util.text.BasicTextEncryptor;

public class SignatureUtil {
    private static final Logger logger = Logger.getLogger(SignatureUtil.class);

    public static boolean validateCertificate(InputStream in, String key) throws SelfServiceException {
        try {
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(in, key.toCharArray());
            String alias = ks.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)ks.getKey(alias, key.toCharArray());
            Certificate[] chain = ks.getCertificateChain(alias);
            return true;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SelfServiceException(ex);
        }
        catch (KeyStoreException ex) {
            throw new SelfServiceException(ex);
        }
        catch (CertificateException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static boolean validateCertificate(byte[] certificate, String key) throws SelfServiceException {
        ByteArrayInputStream in = new ByteArrayInputStream(certificate);
        return SignatureUtil.validateCertificate(in, key);
    }

    public static X509Certificate getCertificate(Organization org) throws SelfServiceException {
        try {
            String cryptKey = SelfServiceEngine.getConfig("crypto.secret");
            String certificateKey = SignatureUtil.decryptString(org.getCertificateKey(), cryptKey);
            if (cryptKey == null) {
                throw new SelfServiceException("No crypto key exists in the config file!");
            }
            ByteArrayInputStream certIn = new ByteArrayInputStream(org.getCertificate());
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(certIn, certificateKey.toCharArray());
            String alias = ks.aliases().nextElement();
            return (X509Certificate)ks.getCertificate(alias);
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SelfServiceException(ex);
        }
        catch (CertificateException ex) {
            throw new SelfServiceException(ex);
        }
        catch (KeyStoreException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static byte[] signDocument(byte[] pdfFile, Organization org) throws SigningException {
        try {
            String signerProviderClass = SelfServiceEngine.getConfig(IPDFSigningProvider.class.getName());
            if (ModuleHelper.isClassAvailable(signerProviderClass)) {
                IPDFSigningProvider signer = EngineFactory.getCustomEngine(IPDFSigningProvider.class);
                return signer.signDocument(pdfFile, org);
            }
            throw new SigningException("The Self Service PDF Signing module is not available.");
        }
        catch (SelfServiceException ex) {
            throw new SigningException(ex);
        }
    }

    public static final String encryptString(String plainText, String passKey) {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword(passKey);
        return textEncryptor.encrypt(plainText);
    }

    public static final String decryptString(String cryptedText, String passKey) {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword(passKey);
        return textEncryptor.decrypt(cryptedText);
    }
}

