/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;

public final class PKCS7Util {
    public PKCS7Util() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public final String getSignedContent(byte[] signature) throws CertificateException, SelfServiceException {
        try {
            CMSSignedData signedData = new CMSSignedData(signature);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (signedData.getSignedContent() != null) {
                signedData.getSignedContent().write((OutputStream)out);
                return out.toString();
            }
            return null;
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (CMSException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    public final boolean verifySignature(byte[] signature) throws CertificateException, SelfServiceException {
        try {
            boolean isVerified = true;
            CMSSignedData signedData = new CMSSignedData(signature);
            Store certsStore = signedData.getCertificates();
            SignerInformationStore signersStores = signedData.getSignerInfos();
            if (signersStores == null || signersStores.getSigners().size() == 0) {
                return false;
            }
            for (SignerInformation signer : signersStores.getSigners()) {
                Collection certCollection = certsStore.getMatches(null);
                if (certCollection.isEmpty()) continue;
                X509Certificate cert = (X509Certificate)certCollection.iterator().next();
                isVerified &= signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert));
            }
            return isVerified;
        }
        catch (CMSException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (OperatorCreationException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    public final List<X509Certificate> getCertificates(byte[] signature) throws CertificateException, SelfServiceException {
        try {
            CMSSignedData signedData = new CMSSignedData(signature);
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (X509CertificateHolder ch : signedData.getCertificates().getMatches(null)) {
                X509CertificateObject c = new X509CertificateObject(ch.toASN1Structure());
                if (list.contains(c)) continue;
                list.add((X509Certificate)c);
            }
            return list;
        }
        catch (CMSException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }
}

