/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.net.HttpUtil;
import is.hugvit.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.util.ThreadContext;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.json.JSONException;

public final class LocaleUtil {
    private static final Logger logger = Logger.getLogger(LocaleUtil.class);
    private static final String LocaleFilePath = SelfServiceEngine.getConfig("web.locale.filepath");
    public static final String ADMIN_BUNDLE = "admin.admin";
    public static final String REPORT_BUNDLE = "admin.reports";
    public static final String COMPUTED_BUNDLE = "admin.computed";
    public static final String COMMON_BUNDLE = "portal.common";
    public static final String SCRIPT_BUNDLE = "portal.jscripts";
    public static final String MESSAGE_BUNDLE = "portal.messages";
    public static final String RSS_BUNDLE = "portal.rss";
    public static final String CAPTCHA_BUNDLE = "portal.captcha";
    public static final String EXCEPTION_BUNDLE = "portal.exception";
    private static SimpleDateFormat sdf = null;
    private static SimpleDateFormat sdfshort = null;
    private static SimpleDateFormat sortFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public static String formatDate(long date) {
        String format = SelfServiceEngine.getConfig("web.locale.dateformat");
        if (format != null && !format.equals("")) {
            if (sdf == null) {
                sdf = new SimpleDateFormat(format);
            }
            return sdf.format(new Date(date));
        }
        return LocaleUtil.getTimeFormat().format(new Date(date));
    }

    public static String formatDateAsSortable(long date) {
        return sortFormat.format(new Date(date));
    }

    public static String formatDateShort(long date) {
        String format = SelfServiceEngine.getConfig("web.locale.shortdateformat");
        if (format != null && !format.equals("")) {
            if (sdfshort == null) {
                sdfshort = new SimpleDateFormat(format);
            }
            return sdfshort.format(new Date(date));
        }
        return LocaleUtil.getDateFormat().format(new Date(date));
    }

    public static final Locale getLocale() {
        Locale locale = new Locale("en", "EN");
        BirdUserPrincipal principal = ThreadContext.getCurrentUser();
        if (principal != null && principal.getLocale() != null) {
            String[] parts;
            if (LocaleUtil.isAvailableLocale(principal.getLocale()) && (parts = principal.getLocale().split("_")).length == 2) {
                locale = new Locale(parts[0], parts[1].toUpperCase());
            }
        } else {
            locale = LocaleUtil.getDefaultLocale();
        }
        return locale;
    }

    public static Locale getDefaultLocale() {
        Vector v;
        String sLocale = SelfServiceEngine.getConfig("web.locale.language");
        if (sLocale != null && !"".equals(sLocale) && (v = Util.split((String)sLocale, (String)",")) != null && v.size() == 2) {
            return new Locale((String)v.get(0), (String)v.get(1));
        }
        return new Locale("en", "EN");
    }

    private static Locale getLocale(HttpServletRequest req) {
        String cookieLocale = HttpUtil.getCookieValue((HttpServletRequest)req, (String)"locale");
        String reqLocaleValue = (String)req.getAttribute("locale");
        BirdUserPrincipal currentUser = ThreadContext.getCurrentUser();
        if (currentUser != null && LocaleUtil.isAvailableLocale(currentUser.getLocale())) {
            logger.debug((Object)("User:" + currentUser.getFullName() + ", setting locale from profile: " + currentUser.getLocale()));
            String[] langCode = currentUser.getLocale().split("_");
            return new Locale(langCode[0], langCode[1].toUpperCase());
        }
        if (LocaleUtil.isAvailableLocale(reqLocaleValue)) {
            logger.debug((Object)("Setting locale from request: " + reqLocaleValue));
            String[] langCode = reqLocaleValue.split("_");
            if (langCode.length == 2) {
                return new Locale(langCode[0], langCode[1]);
            }
        } else if (LocaleUtil.isAvailableLocale(cookieLocale) && cookieLocale.contains("_")) {
            logger.debug((Object)("Setting locale from cookie: " + cookieLocale));
            String[] langCode = cookieLocale.split("_");
            if (langCode.length == 2) {
                return new Locale(langCode[0], langCode[1]);
            }
        }
        return LocaleUtil.getLocale();
    }

    public static final DateFormat getTimeFormat() {
        Locale locale = LocaleUtil.getLocale();
        return DateFormat.getDateTimeInstance(2, 3, locale);
    }

    public static final DateFormat getDateFormat() {
        Locale locale = LocaleUtil.getLocale();
        return DateFormat.getDateInstance(1, locale);
    }

    public static final DateFormat getDateFormat(Locale locale) {
        return DateFormat.getDateInstance(2, locale);
    }

    public static final ResourceBundle getResourceBundle(String resource) {
        return ResourceBundle.getBundle(resource, LocaleUtil.getLocale(), LocaleUtil.getLocaleClassLoader(), new LocaleUtil().new UTF8Control());
    }

    public static ResourceBundle getResourceBundle(String resource, String userLocale) {
        if ("true".equalsIgnoreCase(SelfServiceEngine.getConfig("web.locale.user.option")) && LocaleUtil.isAvailableLocale(userLocale)) {
            String[] loc = userLocale.split("_");
            Locale locale = new Locale(loc[0], loc[1]);
            return ResourceBundle.getBundle(resource, locale, LocaleUtil.getLocaleClassLoader(), new LocaleUtil().new UTF8Control());
        }
        return LocaleUtil.getResourceBundle(resource);
    }

    public static ResourceBundle getResourceBundle(String resource, Locale locale) {
        return ResourceBundle.getBundle(resource, locale, LocaleUtil.getLocaleClassLoader(), new LocaleUtil().new UTF8Control());
    }

    public static final ResourceBundle getResourceBundle(String resource, HttpServletRequest req) {
        if ("true".equalsIgnoreCase(SelfServiceEngine.getConfig("web.locale.user.option"))) {
            ResourceBundle rb = null;
            Locale locale = LocaleUtil.getLocale(req);
            try {
                rb = ResourceBundle.getBundle(resource, locale, LocaleUtil.getLocaleClassLoader(), new LocaleUtil().new UTF8Control());
            }
            catch (MissingResourceException ex) {
                logger.warn((Object)("Resource bundle for resource: " + resource + " is not available for locale: " + locale.getDisplayName()));
                rb = LocaleUtil.getResourceBundle(resource);
            }
            return rb;
        }
        return LocaleUtil.getResourceBundle(resource);
    }

    public static final Hashtable<String, Properties> getComputedKeys() throws JSONException {
        ResourceBundle rb = LocaleUtil.getResourceBundle(COMPUTED_BUNDLE);
        Set<String> keys = rb.keySet();
        Hashtable<String, Properties> bucket = new Hashtable<String, Properties>();
        for (String key : keys) {
            String value = rb.getString(key);
            String section = key.substring(0, key.lastIndexOf("."));
            if (!bucket.containsKey(section)) {
                bucket.put(section, new Properties());
            }
            bucket.get(section).put(key, value);
        }
        return bucket;
    }

    public static final void initResourceBundle(Element root, String resource) throws BirdException {
        Locale locale = LocaleUtil.getLocale();
        ResourceBundle lang = ResourceBundle.getBundle(resource, locale, LocaleUtil.getLocaleClassLoader());
        if (lang != null) {
            Element elLocale = root.addElement("locale");
            Enumeration<String> e = lang.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                elLocale.addElement(key).addText(lang.getString(key));
            }
        } else {
            throw new BirdException("The bundle " + resource + " was not found for locale: " + locale.getDisplayName());
        }
    }

    public static final List<String> getAvailableLocales() {
        ArrayList<String> list = new ArrayList<String>();
        String[] localeList = SelfServiceEngine.getConfig("web.locale.list").split(",");
        if (localeList.length > 0) {
            for (String locale : localeList) {
                list.add(locale.trim());
            }
        }
        return list;
    }

    public static boolean isAvailableLocale(String locale) {
        if (StringUtil.isValid(locale)) {
            for (String s : LocaleUtil.getAvailableLocales()) {
                if (!s.equalsIgnoreCase(locale)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getStringSafe(ResourceBundle bundle, String key, String bundleBaseName) {
        if (bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        if (!Locale.UK.equals(bundle.getLocale()) && !Locale.US.equals(bundle.getLocale())) {
            ResourceBundle rb = ResourceBundle.getBundle(bundleBaseName, new Locale("en", "EN"), LocaleUtil.getLocaleClassLoader(), new LocaleUtil().new UTF8Control());
            return rb.getString(key);
        }
        return String.format("Translation key \"%s\" not found", key);
    }

    private static final ClassLoader getLocaleClassLoader() {
        try {
            String filepath = LocaleFilePath;
            if (!StringUtil.isValid(filepath)) {
                throw new RuntimeException("The configuration property \"web.locale.filepath\" is not set!");
            }
            URLClassLoader loader = null;
            if (filepath.contains("${context}")) {
                filepath = filepath.replace("${context}", "");
                String realpath = SelfServiceEngine.getContext().getRealPath(filepath);
                if (!realpath.endsWith("/")) {
                    realpath = realpath + "/";
                }
                logger.trace((Object)("Using filepath: " + filepath + " (" + realpath + ") for translations."));
                File file = new File(realpath);
                URL[] urls = new URL[]{file.toURI().toURL()};
                loader = new URLClassLoader(urls);
            } else {
                File file = new File(filepath);
                URL[] urls = new URL[]{file.toURI().toURL()};
                loader = new URLClassLoader(urls);
            }
            return loader;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final class UTF8Control
    extends ResourceBundle.Control {
        protected UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

