/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.util.Comparator;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.StatusListItem;

public class DocumentComparator {

    public final class DocumentModifiedDateComparator
    implements Comparator<BaseDocument> {
        @Override
        public int compare(BaseDocument doc, BaseDocument other) {
            if (doc.getDateModified() < other.getDateModified()) {
                return 1;
            }
            if (doc.getDateModified() > other.getDateModified()) {
                return -1;
            }
            return 0;
        }
    }

    public final class DocumentCreationDateComparator
    implements Comparator<BaseDocument> {
        @Override
        public int compare(BaseDocument doc, BaseDocument other) {
            if (doc.getDateCreated() < other.getDateCreated()) {
                return 1;
            }
            if (doc.getDateCreated() > other.getDateCreated()) {
                return -1;
            }
            return 0;
        }
    }

    public final class CaseCompletedDateComparator
    implements Comparator<BaseCase> {
        @Override
        public int compare(BaseCase doc, BaseCase other) {
            if (doc.getDateCompleted() < other.getDateCompleted()) {
                return 1;
            }
            if (doc.getDateCompleted() > other.getDateCompleted()) {
                return -1;
            }
            return 0;
        }
    }

    public final class CaseTitleComparator
    implements Comparator<BaseCase> {
        @Override
        public int compare(BaseCase doc, BaseCase other) {
            if (doc.getSubject().equalsIgnoreCase(other.getSubject())) {
                return doc.getSubject().compareTo(other.getSubject());
            }
            return doc.getSubject().toUpperCase().compareTo(other.getSubject().toUpperCase());
        }
    }

    public final class CaseResponseCountComparator
    implements Comparator<BaseCase> {
        @Override
        public int compare(BaseCase doc, BaseCase other) {
            if (doc.getResponseCount() == other.getResponseCount()) {
                return 0;
            }
            return doc.getResponseCount() > other.getResponseCount() ? 1 : -1;
        }
    }

    public final class ReferenceNumberComparator
    implements Comparator<BaseCase> {
        @Override
        public int compare(BaseCase doc, BaseCase other) {
            return doc.getReferenceNumber().compareTo(other.getReferenceNumber());
        }
    }

    public final class CaseStatusComparator
    implements Comparator<BaseCase> {
        @Override
        public int compare(BaseCase doc, BaseCase other) {
            StatusListItem docStatus = doc.getStatus();
            StatusListItem otherStatus = other.getStatus();
            if (docStatus != null && otherStatus != null) {
                return docStatus.getSubject().compareTo(otherStatus.getSubject());
            }
            return 0;
        }
    }
}

