/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.lang.reflect.Method;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CustomizationHelper {
    public static Element toElement(String elementName, Object o) throws RuntimeException {
        try {
            Method[] methods;
            Element el = DocumentHelper.createElement((String)elementName);
            for (Method method : methods = o.getClass().getMethods()) {
                Object res;
                if (method.getName().startsWith("get") && method.getReturnType().equals(String.class)) {
                    if (method.getParameterTypes().length != 0 || (res = (String)method.invoke(o, new Object[0])) == null) continue;
                    String elName = method.getName().replace("get", "");
                    Dom4JUtil.addElement(el, elName, (String)res);
                    continue;
                }
                if (!method.getName().startsWith("has") && !method.getName().startsWith("is") || method.getName().equals("hashCode") || method.getParameterTypes().length != 0) continue;
                res = method.invoke(o, new Object[0]);
                Dom4JUtil.addElement(el, method.getName(), String.valueOf(res));
            }
            return el;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final DocumentService getService(Organization org) throws SelfServiceException {
        String documentServiceUrl = org.getEndpoint().getHostname();
        String authUsername = org.getEndpoint().getUsername();
        String authPassword = org.getEndpoint().getPassword();
        if (documentServiceUrl == null) {
            throw new SelfServiceException("GoPro Service Url is missing for the organization!");
        }
        if (authUsername == null) {
            throw new SelfServiceException("GoPro username is missing for the organization!");
        }
        if (authPassword == null) {
            throw new SelfServiceException("GoPro password is missing for the organization!");
        }
        documentServiceUrl = RemoteGoPro.GoPro.GOPRO_NET.equals((Object)org.getEndpoint().getGoproType()) ? documentServiceUrl + "WebServices/Gdf/BaseDocumentWebService.asmx" : documentServiceUrl + "services/DocumentService";
        return new DocumentService(documentServiceUrl, authUsername, authPassword, false);
    }
}

