/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.WebContext;
import is.hugvit.image.ImageUtil;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.util.UID;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public final class BirdUtil {
    public static final List<String> getCustomFiles(WebContext context, String filetype) throws BirdException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            con = (Connection)context.getAttribute("bird.connection");
            String sql = "SELECT f.name,f.filename from bird_file f INNER JOIN bird_page p ON p.id = f.folder WHERE p.title = 'custom' AND f.filename LIKE ? AND f.isprivate IS NULL ORDER BY f.filename";
            stmt = con.prepareStatement(sql);
            String like = "%." + filetype;
            stmt.setString(1, like);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String filename = rs.getString("name") + "/" + rs.getString("filename");
                list.add(filename);
            }
            rs.close();
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new BirdException((Exception)ex);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                throw new BirdException((Exception)ex);
            }
        }
    }

    public static final List<String> getFiles(WebContext context, String filetype) throws BirdException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            con = (Connection)context.getAttribute("bird.connection");
            String sql = "SELECT name,filename from bird_file where filename LIKE ? AND isprivate IS NULL ORDER BY filename";
            stmt = con.prepareStatement(sql);
            String like = "%." + filetype;
            stmt.setString(1, like);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String filename = rs.getString("name") + "/" + rs.getString("filename");
                list.add(filename);
            }
            rs.close();
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new BirdException((Exception)ex);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                throw new BirdException((Exception)ex);
            }
        }
    }

    public static final String createFile(WebContext context, InputStream in, String name, String filename, boolean isHidden) throws BirdException {
        if (name == null) {
            name = UID.getUID();
        }
        BirdDatabase db = context.getSession().getDatabase();
        BirdFile file = db.createFile();
        file.setBody(in);
        file.setEncoding("UTF-8");
        file.setFilename(filename);
        file.setPrivate(isHidden);
        file.setType("ATTACHMENT");
        file.setName(name);
        file.save();
        BirdFile f = db.getFileByName(name);
        if (f != null) {
            return f.getID();
        }
        throw new BirdException("Could not retrieve the Id of the uploaded file");
    }

    public static final BirdFile getFile(WebContext context, String fileId) throws BirdException {
        BirdDatabase db = context.getSession().getDatabase();
        BirdFile xFile = db.getFileByID(fileId);
        if (xFile != null) {
            return db.getFileByName(xFile.getName());
        }
        return null;
    }

    public static final byte[] resizeImage(InputStream in, int pixels) throws IOException, BirdException {
        Image source = ImageUtil.getImage((InputStream)in);
        in.reset();
        int ww = ImageUtil.getWidth((Image)source);
        if (ww == -1) {
            throw new BirdException("The supplied file is not an image");
        }
        ByteArrayOutputStreamEx pout = new ByteArrayOutputStreamEx(2048);
        if (ww > pixels) {
            Image dest = ImageUtil.scale((Image)source, (int)pixels);
            ImageUtil.saveImageJPG((Image)dest, (OutputStream)pout, (int)90);
            return pout.getBuffer();
        }
        byte[] bytes = new byte[in.available()];
        in.read(bytes);
        in.close();
        return bytes;
    }
}

