/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;

public class AdminUtil {
    private static final Logger logger = Logger.getLogger(AdminUtil.class);
    private static final String dateFormatNormal = "dd/MM/yyyy";
    private static final String dateFormatEnglish = "MM/dd/yy";

    public static final Date parseDateString(String s, Locale locale) {
        if (!StringUtil.isValid(s)) {
            return null;
        }
        try {
            if (locale != null && locale.getLanguage() != null) {
                String dateFormat = locale.getLanguage().startsWith("en") ? dateFormatEnglish : dateFormatNormal;
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, locale);
                Date date = sdf.parse(s);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Using dateformat %s for language: %s", dateFormat, locale.getLanguage()));
                    logger.debug((Object)("Parsed date: " + date.toGMTString()));
                }
                return date;
            }
            SimpleDateFormat dfx = new SimpleDateFormat(dateFormatNormal);
            return dfx.parse(s);
        }
        catch (ParseException ex) {
            logger.error((Object)("Error parsing date: " + s), (Throwable)ex);
            return null;
        }
    }

    public static final void sendErrorReport(String subject, String body) throws CommunicationException {
        String adminEmail = SelfServiceEngine.getConfig("web.webmaster");
        if (StringUtil.isValidEmail(adminEmail)) {
            Messenger.sendEmailMessage(adminEmail, subject, body, false);
        }
    }

    public static final void sendErrorReport(String subject, String body, Exception ex) throws CommunicationException {
        if (ex != null) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            ex.printStackTrace(printWriter);
            body = body + "\n\n";
            body = body + ((Object)result).toString();
        }
        AdminUtil.sendErrorReport(subject, body);
    }
}

