/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.servlets.UploadListener;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class UploadServlet
extends HttpServlet {
    private static final long serialVersionUID = -5092081286000197210L;
    private static final String CHARSET_ENCODING = SelfServiceEngine.getEncoding();
    protected List<String> fileExtensionWhitelist = new ArrayList<String>();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String caseId = request.getParameter("case_id");
        String parentId = request.getParameter("parent_id");
        HttpSession session = request.getSession();
        request.setCharacterEncoding(CHARSET_ENCODING);
        Document doc = new DocumentFactory().createDocument();
        Element root = doc.addElement("data");
        root.addElement("case_id").setText(caseId);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        UploadListener listener = new UploadListener();
        session.setAttribute("LISTENER", (Object)listener);
        upload.setProgressListener((ProgressListener)listener);
        List items = null;
        FileItem fileItem2 = null;
        String fileTitle = null;
        String fileBody = null;
        boolean isGDPR = false;
        FileItem uploadedFile = null;
        try {
            items = upload.parseRequest(request);
            for (FileItem fileItem2 : items) {
                if (fileItem2.isFormField()) {
                    String name = fileItem2.getFieldName();
                    if ("file-title".equals(name)) {
                        fileTitle = new String(fileItem2.getString(CHARSET_ENCODING));
                        continue;
                    }
                    if ("file-body".equals(name)) {
                        fileBody = new String(fileItem2.getString(CHARSET_ENCODING));
                        continue;
                    }
                    if (!"gdpr".equals(name)) continue;
                    isGDPR = fileItem2.getString().equals("true");
                    continue;
                }
                if (fileItem2.isFormField() || fileItem2.getSize() <= 0L) continue;
                uploadedFile = fileItem2;
            }
            if (uploadedFile == null) {
                throw new SelfServiceException("No file was uploaded!");
            }
            String attachmentId = this.createAttachment(fileTitle, fileBody, isGDPR, caseId, parentId, uploadedFile, request.getUserPrincipal());
            root.addElement("id").setText(attachmentId);
        }
        catch (Exception ex) {
            root.addElement("error").setText(ex.getMessage());
            root.addElement("errortype").setText(ex.getClass().getSimpleName());
        }
        try {
            JSONObject json = XML.toJSONObject((String)doc.asXML());
            response.setContentType("text/html; charset=" + CHARSET_ENCODING + "");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            out.write(json.toString().getBytes(CHARSET_ENCODING));
            out.close();
        }
        catch (JSONException ex) {
            throw new ServletException((Throwable)ex);
        }
        finally {
            session.removeAttribute("LISTENER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createAttachment(String title, String body, boolean isGDPR, String caseId, String parentId, FileItem fileItem, Principal principal) throws SelfServiceException, CaseException {
        try {
            User user = UserService.getUserByUsername(principal.getName());
            BaseCase bc = CaseService.getCase(caseId);
            if (bc == null) {
                throw new SelfServiceException("The parent Case was not found.");
            }
            if (!StringUtil.isValid(title)) {
                title = fileItem.getName();
            }
            Attachment att = new Attachment();
            att.setCreatedById(user.getId());
            att.setModifiedById(user.getId());
            att.setCaseId(bc.getId());
            att.setSubject(StringUtil.stripHTML(title));
            att.setBody(StringUtil.stripHTML(body));
            att.setFilename(fileItem.getName());
            att.setFilesize(fileItem.getSize());
            att.setStream(fileItem.get());
            att.setMimetype(fileItem.getContentType());
            att.setPersonalSensitive(isGDPR);
            att.setSent(bc.isSent());
            if (att.isSent()) {
                att.setDateCompleted(new Date().getTime());
                att.setCompletedById(user.getId());
            }
            if (parentId != null) {
                att.setParentId(parentId);
            }
            att.getAccessControlList().addAll(bc.getAccessControlList());
            CaseService.createSubDocument(att);
            String string = att.getId();
            return string;
        }
        finally {
            fileItem.delete();
        }
    }
}

