/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import java.io.IOException;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.EmailAttachment;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.DocumentSecurityException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.log4j.Logger;

public class FileServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(FileServlet.class);
    private static final long serialVersionUID = -1533934861633003620L;
    private ResourceBundle lang;

    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean forcedownload;
        String id = request.getParameter("id");
        String action = request.getParameter("type");
        boolean bl = forcedownload = request.getParameter("force") == null;
        if (id != null && action != null) {
            if (action.equalsIgnoreCase("file")) {
                this.doFile(id, forcedownload, request, response);
            } else if (action.equalsIgnoreCase("emailattachment")) {
                String emailId = request.getParameter("parent");
                this.doEmailAttachment(emailId, id, request, response);
            } else if (action.equalsIgnoreCase("completed")) {
                this.doCompletedFormDocument(id, request, response, forcedownload);
            } else if (action.equalsIgnoreCase("case")) {
                this.doCase(id, request, response);
            }
        } else if (action != null && action.equalsIgnoreCase("strings")) {
            this.doLocalizationScript(request, response);
        }
    }

    private void doLocalizationScript(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.lang = LocaleUtil.getResourceBundle("portal.jscripts", req);
        Enumeration<String> e = this.lang.getKeys();
        StringBuffer sb = new StringBuffer();
        sb.append("var Trans = {");
        sb.append("items: {\n");
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (!key.startsWith("js") && !key.startsWith("status")) continue;
            String line = "\"" + key + "\":\"" + this.lang.getString(key) + "\",\n";
            sb.append(line);
        }
        sb = sb.delete(sb.length() - 2, sb.length());
        sb.append("},");
        sb.append("late: function(s) {");
        sb.append("if (!(this.items[s]===undefined)) {");
        sb.append("return this.items[s];");
        sb.append("} else {");
        sb.append("return 'null';");
        sb.append("} } };");
        res.setContentType("text/javascript; charset=UTF-8");
        res.setCharacterEncoding("UTF-8");
        byte[] b = sb.toString().getBytes("UTF-8");
        res.setContentLength(b.length);
        res.getOutputStream().write(b);
        res.getOutputStream().flush();
        res.getOutputStream().close();
    }

    private void doCompletedFormDocument(String caseId, HttpServletRequest request, HttpServletResponse response, boolean forcedownload) throws ServletException {
        block23: {
            BaseCase bc = null;
            try {
                CompletedFormDocument com;
                bc = CaseService.getCase(caseId);
                if (bc != null) {
                    User user = UserService.getUserByUsername(request.getUserPrincipal().getName());
                    DocumentSecurityUtil.validatePermission(bc, user, AccessControl.Permission.READ);
                }
                if (bc != null && bc instanceof FormCase && (com = ((FormCase)bc).getCompletedFormDocument()) instanceof CompletedFormDocument) {
                    com = (CompletedFormDocument)CaseService.getSubDocument(com.getId(), true);
                    response.setContentLength((int)com.getFilesize());
                    if (forcedownload) {
                        response.setHeader("Content-Disposition", "attachment;\tfilename=\"" + com.getFilename() + "\"");
                    } else {
                        response.setContentType(com.getMimetype());
                    }
                    response.setHeader("Pragma", "public");
                    response.setHeader("Cache-Control", "private, max-age=15");
                    response.getOutputStream().write(com.getStream());
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
            }
            catch (SocketException ex) {
                if (bc == null) break block23;
                try {
                    AuditLogEntry entry = new AuditLogEntry(bc.getId(), AuditLogEntry.DataType.COMPLETED_FORM, AuditLogEntry.Action.DOWNLOAD);
                    LogService.createLogEntry(entry);
                }
                catch (SelfServiceException ex2) {
                    throw new ServletException((Throwable)ex2);
                }
            }
            catch (IOException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (DocumentSecurityException ex) {
                if (bc != null) {
                    try {
                        AuditLogEntry entry = new AuditLogEntry(bc.getId(), AuditLogEntry.DataType.COMPLETED_FORM, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
                        LogService.createLogEntry(entry);
                    }
                    catch (SelfServiceException sex) {
                        throw new ServletException((Throwable)sex);
                    }
                }
                throw new ServletException((Throwable)ex);
            }
            catch (SelfServiceException ex) {
                throw new ServletException((Throwable)ex);
            }
            finally {
                if (bc != null) {
                    try {
                        AuditLogEntry entry = new AuditLogEntry(bc.getId(), AuditLogEntry.DataType.COMPLETED_FORM, AuditLogEntry.Action.DOWNLOAD);
                        LogService.createLogEntry(entry);
                    }
                    catch (SelfServiceException ex) {
                        throw new ServletException((Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void doCase(String caseId, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doEmailAttachment(String emailId, String id, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        EmailAttachment doc = null;
        try {
            Email email = CaseService.getEmail(emailId, true);
            if (email != null) {
                if (email != null) {
                    User user = UserService.getUserByUsername(request.getUserPrincipal().getName());
                    DocumentSecurityUtil.validatePermission(email, user, AccessControl.Permission.READ);
                }
                for (EmailAttachment att : email.getAttachments()) {
                    if (!att.getAttachmentId().equals(id)) continue;
                    doc = att;
                    break;
                }
            }
            if (doc != null) {
                response.setContentLength((int)doc.getFileSize());
                response.setHeader("Content-Disposition", "attachment;\tfilename=\"" + doc.getFileName() + "\"");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "private, max-age=15");
                response.getOutputStream().write(doc.getStream());
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
        catch (SocketException ex) {
        }
        catch (SelfServiceException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (DocumentSecurityException ex) {
            try {
                AuditLogEntry entry = new AuditLogEntry(emailId, AuditLogEntry.DataType.EMAIL, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
                LogService.createLogEntry(entry);
            }
            catch (SelfServiceException sex) {
                throw new ServletException((Throwable)sex);
            }
            throw new ServletException((Throwable)ex);
        }
        finally {
            if (doc != null) {
                try {
                    AuditLogEntry entry = new AuditLogEntry(id, AuditLogEntry.DataType.EMAIL_ATTACHMENT, AuditLogEntry.Action.DOWNLOAD);
                    LogService.createLogEntry(entry);
                }
                catch (SelfServiceException ex) {
                    throw new ServletException((Throwable)ex);
                }
            }
            doc = null;
        }
    }

    private void doFile(String attachmentId, boolean forcedownload, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ExternalDocument doc = null;
        try {
            doc = CaseService.getExternalDocument(attachmentId, true);
            if (doc != null) {
                User user = UserService.getUserByUsername(request.getUserPrincipal().getName());
                DocumentSecurityUtil.validatePermission(doc, user, AccessControl.Permission.READ);
            }
            if (doc != null) {
                response.setContentLength((int)doc.getFilesize());
                if (forcedownload) {
                    response.setHeader("Content-Disposition", "attachment;\tfilename=\"" + doc.getFilename() + "\"");
                } else {
                    response.setContentType(doc.getMimetype());
                }
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "private, max-age=15");
                response.getOutputStream().write(doc.getStream());
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
        catch (SocketException ex) {
        }
        catch (SelfServiceException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (DocumentSecurityException ex) {
            if (doc != null) {
                try {
                    AuditLogEntry entry = new AuditLogEntry(doc.getId(), AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
                    LogService.createLogEntry(entry);
                }
                catch (SelfServiceException sex) {
                    throw new ServletException((Throwable)sex);
                }
            }
            throw new ServletException((Throwable)ex);
        }
        finally {
            if (doc != null) {
                try {
                    AuditLogEntry entry = new AuditLogEntry(doc.getId(), AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.DOWNLOAD);
                    LogService.createLogEntry(entry);
                }
                catch (SelfServiceException ex) {
                    throw new ServletException((Throwable)ex);
                }
            }
            doc = null;
        }
    }
}

