/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;

public class ExternalParamFilter
implements Filter {
    private static Logger logger = Logger.getLogger(ExternalParamFilter.class);
    private static List<String> validParamsKeys = new ArrayList<String>();
    private static boolean paramsEnabled = false;
    private static String paramsStorage = "session";

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doLanguageFilter(request, response);
        paramsEnabled = Boolean.valueOf(SelfServiceEngine.getConfig("params.enabled", "false"));
        validParamsKeys = Arrays.asList(SelfServiceEngine.getConfig("params.list", "").split(","));
        paramsStorage = SelfServiceEngine.getConfig("params.storage", "session");
        String doRequest = request.getParameter("ref");
        if (paramsEnabled && doRequest != null && "".equals(doRequest)) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpSession session = ((HttpServletRequest)request).getSession();
            Enumeration params = req.getParameterNames();
            while (params.hasMoreElements()) {
                Principal principal;
                String paramKey = (String)params.nextElement();
                if ("ref".equals(paramKey) || !validParamsKeys.contains(paramKey)) continue;
                String value = req.getParameter(paramKey);
                String sanitizedKey = paramKey.replaceAll("[^a-zA-Z0-9_\\s]", "");
                String sanitizedValue = value.toString().replaceAll("[^a-zA-Z0-9_\\s]", "");
                if (!StringUtil.isValid(sanitizedKey) || !StringUtil.isValid(sanitizedValue)) continue;
                if ("session".equalsIgnoreCase(paramsStorage)) {
                    session.setAttribute(sanitizedKey, (Object)sanitizedValue);
                    continue;
                }
                if (!"metadata".equalsIgnoreCase(paramsStorage) || !((principal = req.getUserPrincipal()) instanceof BirdUserPrincipal)) continue;
                try {
                    String userId = ((BirdUserPrincipal)principal).getUserId();
                    MetaData m = new MetaData(sanitizedKey, sanitizedValue, userId);
                    m.setReferenceId(userId);
                    m.setDirty(true);
                    ConfigService.createMetaData(m);
                    session.setAttribute(sanitizedKey, (Object)sanitizedValue);
                }
                catch (SelfServiceException ex) {
                    logger.error((Object)ex);
                }
            }
        }
        chain.doFilter(request, response);
    }

    private void doLanguageFilter(ServletRequest request, ServletResponse response) {
        String languageParam = request.getParameter("lang");
        if (StringUtil.isValid(languageParam)) {
            String requestedLanguage = languageParam.trim();
            logger.debug((Object)("Request for specific language: " + requestedLanguage));
            if (LocaleUtil.isAvailableLocale(requestedLanguage)) {
                HttpServletRequest req = (HttpServletRequest)request;
                HttpServletResponse resp = (HttpServletResponse)response;
                Cookie cookie = new Cookie("locale", requestedLanguage);
                cookie.setPath(request.getServletContext().getContextPath());
                cookie.setMaxAge(Integer.MAX_VALUE);
                resp.addCookie(cookie);
                req.setAttribute("locale", (Object)requestedLanguage);
                logger.debug((Object)("Language cookie set to: " + requestedLanguage));
            } else {
                logger.warn((Object)("Request for unsupported locale: " + requestedLanguage));
            }
        }
    }
}

