/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import java.util.ArrayList;
import java.util.Iterator;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.math.NumberUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TaskPage
extends BasePage {
    public static final String pageName = "task.html";
    private static final int FALLBACK_RECORDS_PER_PAGE = 15;
    private java.util.List<Task> allTasks = new ArrayList<Task>();

    @Override
    public void doGet(WebContext context) throws BirdException {
        String taskId = context.getRequest().getParameter("id");
        String resolve = context.getRequest().getParameter("forward");
        String view = context.getRequest().getParameter("view");
        String status = context.getRequest().getParameter("status");
        try {
            String parentId;
            Task task;
            User currentUser = this.getCurrentUser(context);
            if ("parent".equals(resolve) && StringUtil.isValid(resolve) && (task = TaskService.getTask(taskId)) != null && (parentId = task.getParentId()) != null) {
                BaseCase parentCase;
                if (currentUser.getId().equals(task.getResponsibleId()) && Task.TaskStatus.NotStarted.equals((Object)task.getStatus())) {
                    task.setStatus(Task.TaskStatus.InProgress);
                    task.setStartedById(currentUser.getId());
                    TaskService.updateTask(task);
                }
                if ((parentCase = CaseService.getCase(parentId)) != null) {
                    this.redirect(context, "case.html?id=" + parentCase.getId());
                    return;
                }
                SubDocument sub = CaseService.getSubDocument(parentId, false);
                if (sub != null) {
                    if (sub instanceof ApplicationForm) {
                        this.redirect(context, "application.html?id=" + sub.getId());
                    } else if (sub instanceof ExternalDocument) {
                        this.redirect(context, "attachment.html?id=" + sub.getId());
                    } else if (sub instanceof Memo) {
                        this.redirect(context, "memo.html?id=" + sub.getId());
                    } else if (sub instanceof Email) {
                        this.redirect(context, "email.html?id=" + sub.getId());
                    }
                }
            }
            java.util.List<Task> tasks = TaskService.getTasksByResponsibleUser(currentUser.getId());
            BaseDocumentUtil.removeDeletedDocuments(tasks);
            this.allTasks = new ArrayList<Task>(tasks);
            if (view != null && StringUtil.isValid(view)) {
                BaseDocument filteredCategory = null;
                List taskCategoryList = ConfigService.getList("527DDC43A963ADAB000001426FD2551F");
                if (taskCategoryList != null) {
                    for (ListItem listItem : taskCategoryList.getListItems()) {
                        if (!listItem.getAlias().equalsIgnoreCase(view) && !listItem.getId().equals(view)) continue;
                        filteredCategory = listItem;
                        break;
                    }
                }
                if (filteredCategory != null) {
                    Iterator<Task> it = tasks.iterator();
                    while (it.hasNext()) {
                        Task task2 = it.next();
                        if (filteredCategory.getId().equals(task2.getCategoryId())) continue;
                        it.remove();
                    }
                }
            }
            if (status != null && NumberUtils.isNumber((String)status)) {
                try {
                    Task.TaskStatus filteredStatus = Task.TaskStatus.of(Integer.parseInt(status));
                    if (filteredStatus != null) {
                        Iterator<Task> it = tasks.iterator();
                        while (it.hasNext()) {
                            Task task3 = it.next();
                            if (task3.getStatus().equals((Object)filteredStatus)) continue;
                            it.remove();
                        }
                    }
                }
                catch (Exception filteredStatus) {
                    // empty catch block
                }
            }
            int recordsPerPage = this.getRecordCountPerPage();
            if (tasks.size() > 0 && tasks.size() > recordsPerPage) {
                int pagerSize;
                int totalRecords = tasks.size();
                int currentPage = this.getPageNumber(context);
                if (currentPage > (pagerSize = this.getPagerSize(totalRecords, recordsPerPage))) {
                    currentPage = 1;
                }
                tasks = this.getPagedList(tasks, currentPage, recordsPerPage);
                this.createPager(totalRecords, currentPage, recordsPerPage, pagerSize, tasks.size());
            }
            this.showList(tasks);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    @Override
    public void doXML(WebContext context, Form data) throws BirdException {
        String filterStatus = context.getRequest().getParameter("status");
        Element elStatusList = this.dataroot.addElement("statuslist");
        for (Task.TaskStatus status : Task.TaskStatus.values()) {
            String translated = status.toString();
            if (this.resourceBundle.containsKey("task.status." + status.toString().toLowerCase())) {
                translated = this.resourceBundle.getString("task.status." + status.toString().toLowerCase());
            }
            Element el = DocumentHelper.createElement((String)"status");
            el.addAttribute("id", String.valueOf(status.getCode()));
            el.addAttribute("name", status.toString());
            el.addAttribute("counter", String.valueOf(this.getTaskCount(status, this.allTasks)));
            if (String.valueOf(status.getCode()).equals(filterStatus)) {
                el.addAttribute("selected", "true");
            }
            el.setText(translated);
            elStatusList.add(el);
        }
    }

    private int getTaskCount(Task.TaskStatus status, java.util.List<Task> taskList) {
        if (status == null || taskList.isEmpty()) {
            return 0;
        }
        int counter = 0;
        for (Task task : taskList) {
            if (!status.equals((Object)task.getStatus())) continue;
            ++counter;
        }
        return counter;
    }

    private java.util.List<Task> getPagedList(java.util.List<Task> list, int page, int recordsPerPage) {
        int endPos;
        int startPos = (page - 1) * recordsPerPage;
        if (startPos > list.size()) {
            startPos = 0;
        }
        if ((endPos = startPos + recordsPerPage) > list.size()) {
            endPos = list.size();
        }
        return list.subList(startPos, endPos);
    }

    protected void createPager(int totalRecords, int currentPage, int recordsPerPage, int pagerSize, int currentRecordCount) {
        Element el = this.dataroot.addElement("pager");
        el.addAttribute("page", String.valueOf(currentPage));
        el.addAttribute("total", String.valueOf(totalRecords));
        el.addAttribute("perpage", String.valueOf(recordsPerPage));
        el.addAttribute("size", String.valueOf(pagerSize));
        int startPos = (currentPage - 1) * recordsPerPage;
        if (startPos > totalRecords) {
            startPos = 0;
        }
        int endPos = startPos + currentRecordCount;
        el.addAttribute("start", String.valueOf(startPos + 1));
        el.addAttribute("end", String.valueOf(endPos));
        for (int i = 1; i <= pagerSize; ++i) {
            el.addElement("page").setText(String.valueOf(i));
        }
    }

    protected final int getPagerSize(int totalRecords, int recordsPerPage) {
        int pages = totalRecords / recordsPerPage;
        if (totalRecords % recordsPerPage != 0) {
            ++pages;
        }
        return pages;
    }

    protected final int getPageNumber(WebContext context) {
        String s = context.getRequest().getParameter("page");
        int pageNumber = 1;
        if (StringUtil.isValid(s)) {
            try {
                pageNumber = Integer.parseInt(s);
                if (pageNumber < 1) {
                    pageNumber = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pageNumber;
    }

    protected final int getRecordCountPerPage() {
        int pagerSize = 15;
        String sCount = SelfServiceEngine.getConfig("web.viewcount.tasks");
        if (StringUtil.isValid(sCount)) {
            try {
                pagerSize = Integer.parseInt(sCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pagerSize;
    }
}

