/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.excel.ExcelData;
import net.gopro.selfservice.excel.ExcelDataRow;
import net.gopro.selfservice.excel.ExcelWriter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.servlet.ServletContextURIResolver;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.xml.sax.SAXException;

public class MyCasesExportPage
extends WebElementBase {
    protected static final String FOP_CONFIG = "selfservice/fop-config.xml";
    protected static final String XSLFO = "selfservice/selfservice-pdf-views-fo.xsl";
    protected String documentTitle = null;

    public void doGet(WebContext context) throws BirdException {
        try {
            this.documentTitle = null;
            OutputType out = this.getOutputType(context);
            User user = UserService.getUserByUsername(context.getRequest().getUserPrincipal().getName());
            if (user == null) {
                throw new BirdException("Access denied, no valid user was found.");
            }
            List<BaseCase> caseList = this.generateCaseList(context, user);
            Document doc = this.getListAsDocument(caseList);
            String documentTitle = this.getDocumentTitle(context);
            if (out.equals((Object)OutputType.Excel)) {
                List excelList = doc.selectNodes("//case", "refnumber");
                Collections.reverse(excelList);
                List<ExcelDataRow> rl = this.getDefaultExcelDataRows();
                this.doExcel(context, documentTitle, rl, excelList);
            } else if (out.equals((Object)OutputType.PDF)) {
                this.doPDF(context, user, documentTitle, this.getDefaultPdfHeaders(), doc, XSLFO);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected final List<String> getDefaultPdfHeaders() {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common");
        return Arrays.asList(rb.getString("my.casenumber"), rb.getString("my.case"), rb.getString("my.documents"), rb.getString("my.status"), rb.getString("my.created"), rb.getString("my.modified"));
    }

    protected final List<ExcelDataRow> getDefaultExcelDataRows() {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common");
        ArrayList<ExcelDataRow> rl = new ArrayList<ExcelDataRow>();
        rl.add(new ExcelDataRow("refnumber", rb.getString("my.casenumber")));
        rl.add(new ExcelDataRow("subject", rb.getString("my.case"), 300));
        rl.add(new ExcelDataRow("responsecount", rb.getString("my.documents")));
        rl.add(new ExcelDataRow("status", rb.getString("my.status")));
        rl.add(new ExcelDataRow("created", rb.getString("my.created"), ExcelDataRow.RowType.DATE));
        rl.add(new ExcelDataRow("modified", rb.getString("my.modified"), ExcelDataRow.RowType.DATE));
        return rl;
    }

    protected Document getListAsDocument(List<BaseCase> list) {
        Element root = DocumentHelper.createElement((String)"data");
        Document doc = DocumentHelper.createDocument((Element)root);
        Iterator<BaseCase> it = list.iterator();
        while (it.hasNext()) {
            root.add(it.next().getXml());
        }
        return doc;
    }

    protected void doExcel(WebContext context, String documentTitle, List<ExcelDataRow> dataRows, List<Node> dataList) throws SelfServiceException {
        if (!StringUtil.isValid(documentTitle)) {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common", context.getRequest());
            documentTitle = rb.getString("nav.mycases");
        }
        ExcelData excel = new ExcelData(documentTitle);
        excel.loadFromXml(dataRows, dataList);
        ExcelWriter.write(context, excel);
    }

    protected void doPDF(WebContext context, User user, String documentTitle, List<String> headers, Document doc, String XslFile) throws SelfServiceException {
        HttpServletResponse response = context.getResponseExclusive();
        response.setContentType("application/pdf");
        try {
            if (!StringUtil.isValid(documentTitle)) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common", context.getRequest());
                documentTitle = rb.getString("nav.mycases");
            }
            doc.getRootElement().addElement("fullname").setText(user.getFullname());
            doc.getRootElement().addElement("today").setText(LocaleUtil.getDateFormat().format(new Date()));
            doc.getRootElement().addElement("title").setText(documentTitle);
            for (String header : headers) {
                doc.getRootElement().addElement("header").setText(header);
            }
            byte[] data = this.transFormToPDF(doc, XslFile);
            documentTitle = documentTitle + ".pdf";
            response.setContentLength(data.length);
            response.setHeader("Content-Disposition", "attachment;\tfilename=\"" + documentTitle + "\"");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "private, max-age=15");
            response.getOutputStream().write(data);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (SocketException data) {
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    protected String getTemplateFilter(WebContext context) {
        return context.getRequest().getParameter("type");
    }

    protected String getDocumentTitle(WebContext context) {
        String contextTitle = context.getRequest().getParameter("title");
        if (StringUtil.isValid(contextTitle)) {
            return contextTitle;
        }
        return this.documentTitle;
    }

    protected OutputType getOutputType(WebContext context) {
        if ("pdf".equalsIgnoreCase(context.getRequest().getParameter("out"))) {
            return OutputType.PDF;
        }
        return OutputType.Excel;
    }

    protected String getStatusFilter(WebContext context) {
        return context.getRequest().getParameter("status");
    }

    protected List<BaseCase> generateCaseList(WebContext context, User user) throws SelfServiceException, BirdException {
        List<Object> caseList = new ArrayList();
        String userId = user.getId();
        String templateIdFilter = this.getTemplateFilter(context);
        String statusIdFilter = this.getStatusFilter(context);
        if (StringUtil.isValid(templateIdFilter)) {
            FormTemplate ft = FormService.getFormTemplate(templateIdFilter, false);
            if (ft != null) {
                LinkedList<StatusListItem> statusList = ft.getExtendedData().getCaseStatusList();
                List<FormCase> listByTemplate = CaseService.getCasesByFormTemplate(userId, templateIdFilter);
                caseList.addAll(listByTemplate);
                this.documentTitle = ft.getSubject();
                if (StringUtil.isValid(statusIdFilter)) {
                    StatusListItem currentStatus = null;
                    BaseDocument statusDoc = BaseDocumentUtil.getDocumentFromList(statusIdFilter, statusList);
                    if (statusDoc != null) {
                        currentStatus = (StatusListItem)statusDoc;
                        Iterator<Object> it = caseList.iterator();
                        while (it.hasNext()) {
                            BaseCase bc = (BaseCase)it.next();
                            if (statusIdFilter.equals(bc.getStatusId())) continue;
                            it.remove();
                        }
                        this.documentTitle = this.documentTitle + " - " + currentStatus.getSubject();
                    }
                }
            } else {
                CaseTemplate caseTemplate = CaseService.getCaseTemplate(templateIdFilter);
                if (caseTemplate != null) {
                    caseList = CaseService.getCasesByCaseTemplate(templateIdFilter, userId);
                }
            }
        } else {
            caseList = CaseService.getCases(user.getId());
            BaseDocumentUtil.removeDeletedDocuments(caseList);
        }
        return caseList;
    }

    protected final byte[] transFormToPDF(Document doc, String XslFoFile) throws SelfServiceException {
        byte[] bytes = null;
        try {
            ServletContext ctx = SelfServiceEngine.getContext();
            InputStream is = ctx.getResourceAsStream("/WEB-INF/" + XslFoFile);
            FopFactory fopFactory = FopFactory.newInstance();
            TransformerFactory tFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
            fopFactory.setURIResolver((URIResolver)new ServletContextURIResolver(ctx));
            try {
                File configFile = new File(ctx.getRealPath("/WEB-INF/selfservice/fop-config.xml"));
                fopFactory.setUserConfig(configFile);
            }
            catch (FileNotFoundException ex) {
                SelfServiceEngine.getLogger().warn("No selfservice/fop-config.xml exists, using default values.");
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Fop fop = fopFactory.newFop("application/pdf", (OutputStream)out);
            StreamSource xsltSrc = new StreamSource(is);
            Transformer transformer = tFactory.newTransformer(xsltSrc);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            StreamSource src = new StreamSource(new StringReader(doc.asXML()));
            transformer.transform(src, res);
            is.close();
            bytes = out.toByteArray();
        }
        catch (FOPException ex) {
            ex.printStackTrace();
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            throw new SelfServiceException(ex);
        }
        return bytes;
    }

    public void doPost(WebContext context) throws BirdException {
    }

    protected static enum OutputType {
        Excel,
        PDF;

    }
}

