/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.DocumentSecurityException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class EmailPage
extends BasePage {
    public static final String pageName = "email.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
        boolean isValidRequest = false;
        String emailId = context.getRequest().getParameter("id");
        try {
            SubDocument doc;
            if (StringUtil.isValid(emailId) && (doc = CaseService.getSubDocument(emailId, false)) != null && doc instanceof Email) {
                User currentUser = this.getCurrentUser(context);
                DocumentSecurityUtil.validatePermission(doc, currentUser, AccessControl.Permission.READ);
                BaseCase bc = CaseService.getCase(doc.getCaseId());
                if (bc != null) {
                    if (!currentUser.getId().equals(doc.getCreatedById())) {
                        Element el = doc.getXml();
                        User author = UserService.getUser(doc.getCreatedById());
                        if (author != null) {
                            el.addElement("author").setText(author.getFullname());
                        }
                        this.dataroot.add(el);
                    } else {
                        this.dataroot.add(doc.getXml());
                    }
                    isValidRequest = true;
                    int otherCount = bc.getResponseCount();
                    this.dataroot.addAttribute("othercount", String.valueOf(otherCount));
                    this.dataroot.add(bc.getXml());
                }
            }
            if (!isValidRequest) {
                this.redirect(context, "mycases.html");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (DocumentSecurityException ex) {
            AuditLogEntry entry = new AuditLogEntry(emailId, AuditLogEntry.DataType.EMAIL, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
            try {
                LogService.createLogEntry(entry);
            }
            catch (SelfServiceException sex) {
                throw new BirdException((Exception)sex);
            }
            log.warn(ex.getMessage());
            this.redirect(context, "mycases.html");
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }
}

