/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.UserService;
import org.dom4j.Element;

public class ContactManagerPage
extends BasePage {
    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            User currentUser = this.getCurrentUser(context);
            if (!currentUser.isContactManager()) {
                this.redirect(context, "home.html");
            } else {
                Element el = this.dataroot.addElement("manager");
                for (Contact contact : currentUser.getContactList()) {
                    if (!contact.isManager() || contact.isDeleted()) continue;
                    Company com = UserService.getCompany(contact.getCompanyId());
                    Element elCompany = com.getXml();
                    Element elContacts = elCompany.addElement("contacts");
                    for (User cu : com.getContacts()) {
                        elContacts.add(cu.getXml());
                    }
                    el.add(elCompany);
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }
}

