/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.data.SignedFormDocument;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.DocumentSecurityException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.ModuleHelper;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.util.URLBuilder;
import org.apache.commons.lang.WordUtils;
import org.dom4j.Element;

public class CasePage
extends BasePage {
    public static final String pageName = "case.html";
    protected static final ResourceBundle rb = LocaleUtil.getResourceBundle("admin.admin");
    protected static final boolean isTasksEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("tasks.enabled"));
    protected static final boolean isSharingEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("goproforms.sharing")) && ModuleHelper.isValidLicense("Collaboration Module");

    @Override
    public void doGet(WebContext context) throws BirdException {
        boolean isValidRequest = false;
        try {
            BaseCase bc;
            String caseId = context.getRequest().getParameter("id");
            if (StringUtil.isValid(caseId) && (bc = CaseService.getCase(caseId)) != null) {
                ApplicationForm form;
                isValidRequest = true;
                boolean showCasePage = true;
                if (bc instanceof FormCase && (form = ((FormCase)bc).getApplicationForm()) != null && !form.isSent()) {
                    showCasePage = false;
                    String url = "application.html?id=" + form.getId();
                    String doParam = this.getExtraParameter(context);
                    if (doParam != null) {
                        url = url + "&do=" + doParam;
                    }
                    String redirectUrl = URLBuilder.buildUrl(context, url);
                    context.setRedirectURL(redirectUrl);
                }
                if (showCasePage) {
                    BaseCase parentCase;
                    Company company;
                    User currentUser = this.getCurrentUser(context);
                    try {
                        DocumentSecurityUtil.validatePermission(bc, currentUser, AccessControl.Permission.READ);
                    }
                    catch (DocumentSecurityException ex) {
                        AuditLogEntry entry = new AuditLogEntry(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
                        LogService.createLogEntry(entry);
                        throw ex;
                    }
                    Organization organization = ConfigService.getOrganization(bc.getOrganizationId());
                    Element caseElement = bc.getXml();
                    caseElement.addElement("organization").setText(organization.getSubject());
                    if (bc.isCompanyCase() && (company = UserService.getCompany(bc.getCompanyId())) != null) {
                        caseElement.addElement("company").setText(company.getName());
                    }
                    if (bc.isCompanyCase() || bc instanceof FormCase && ((FormCase)bc).isShared()) {
                        AuditLog caseHistory = LogService.getCaseHistory(bc.getId());
                        this.createHistoryElement(caseHistory);
                        caseHistory.getEntries();
                    }
                    if (bc instanceof FormCase && ((FormCase)bc).getParentId() != null && (parentCase = CaseService.getCase(((FormCase)bc).getParentId())) != null) {
                        caseElement.addElement("parent-title").setText(parentCase.getSubject());
                        caseElement.addElement("parent-ref").setText(parentCase.getReferenceNumber());
                    }
                    this.dataroot.add(caseElement);
                    CaseTemplate caseTemplate = CaseService.getCaseTemplate(bc.getCaseTemplateId());
                    if (caseTemplate == null) {
                        throw new SelfServiceException("Case template for Case was not found!");
                    }
                    this.dataroot.add(caseTemplate.getXml());
                    List<SubDocument> subDocuments = CaseService.getCaseDocuments(bc.getId(), false);
                    BaseDocumentUtil.removeDeletedDocuments(subDocuments);
                    Element elSub = this.dataroot.addElement("subdocuments");
                    boolean isNewDocsEnabled = this.isDocumentCreationEnabled(bc, currentUser);
                    if (bc instanceof FormCase) {
                        FormTemplateFile templateFile;
                        SignedFormDocument signedDoc;
                        FormTemplate ft = FormService.getFormTemplate(((FormCase)bc).getFormtemplateId(), false);
                        if (ft != null) {
                            this.dataroot.add(ft.getXml());
                        }
                        if (bc.isSigned() && (signedDoc = ((FormCase)bc).getSignedFormDocument()) != null) {
                            signedDoc = (SignedFormDocument)CaseService.getExternalDocument(signedDoc.getId(), true);
                            try {
                                this.dataroot.add(signedDoc.getCertificateDataAsXml());
                            }
                            catch (CertificateException ex) {
                                log.error((Exception)ex);
                            }
                        }
                        if (ft != null && ft.isSecondaryEnabled()) {
                            Element elSecondaries = this.dataroot.addElement("secondaries");
                            Element elApplications = elSecondaries.addElement("applications");
                            Element elCases = elSecondaries.addElement("cases");
                            List<BaseCase> childCases = CaseService.getCasesByParentId(bc.getId());
                            ArrayList<String> caseIdsBucket = new ArrayList<String>();
                            boolean isSecondaryAvailable = !childCases.isEmpty();
                            for (SecondaryForm secondary : ft.getSecondaryReferences()) {
                                String linkToken = secondary.getLinkToken(bc.getOrganizationId());
                                if (linkToken == null) continue;
                                Element els = elApplications.addElement("application");
                                els.addAttribute("id", secondary.getTemplateId());
                                els.addAttribute("token", linkToken);
                                boolean isAvailable = bc.getStatusId().equals(secondary.getStatusId());
                                boolean isTargetAccessible = true;
                                if (StringUtil.isValid(secondary.getTargetgroupId()) && !currentUser.isInTargetGroup(secondary.getTargetgroupId())) {
                                    isTargetAccessible = false;
                                }
                                isSecondaryAvailable = isSecondaryAvailable || isAvailable || isTargetAccessible;
                                els.addAttribute("available", String.valueOf(isAvailable && isTargetAccessible));
                                els.addAttribute("limit", String.valueOf(secondary.getTimelimit()));
                                boolean isExpired = false;
                                int deadlineDays = secondary.getTimelimit();
                                if (deadlineDays > 0) {
                                    Calendar cal = Calendar.getInstance();
                                    cal.setTimeInMillis(bc.getDateCompleted());
                                    cal.set(11, 24);
                                    cal.set(12, 0);
                                    cal.set(13, 0);
                                    cal.add(5, deadlineDays);
                                    els.addAttribute("deadline", String.valueOf(cal.getTimeInMillis()));
                                    isExpired = cal.getTime().before(new Date());
                                }
                                els.addAttribute("expired", String.valueOf(isExpired));
                                els.addAttribute("type", "template");
                                els.addElement("title").setText(secondary.getTemplateName());
                                List<FormCase> secList = this.getSecondaryApplications(childCases, secondary.getTemplateId());
                                if (secList.isEmpty()) continue;
                                for (FormCase secondaryApplication : secList) {
                                    if (caseIdsBucket.contains(secondaryApplication.getId())) continue;
                                    Element elCase = elCases.addElement("case");
                                    elCase.addAttribute("id", secondaryApplication.getId());
                                    elCase.addElement("title").setText(secondaryApplication.getSubject());
                                    elCase.addElement("created").setText(LocaleUtil.formatDate(secondaryApplication.getDateCreated()));
                                    if (secondaryApplication.getDateCompleted() > 0L) {
                                        elCase.addElement("completed").setText(LocaleUtil.formatDate(secondaryApplication.getDateCompleted()));
                                    }
                                    elCase.addElement("status").setText(secondaryApplication.getStatus().getSubject());
                                    caseIdsBucket.add(secondaryApplication.getId());
                                }
                            }
                            elSecondaries.addAttribute("available", String.valueOf(isSecondaryAvailable));
                        }
                        boolean isClonable = false;
                        if (ft != null && bc.isSent() && !bc.isCompanyCase() && !ft.isDeleted() && ft.isVisible() && ft.isWithinDateRestriction() && (templateFile = FormService.getFormTemplateFile(ft.getId(), FormTemplateFile.Tag.DATA, false)) != null && !templateFile.isDeleted() && bc.getDateCreated() > templateFile.getDateModified()) {
                            isClonable = true;
                        }
                        this.dataroot.addAttribute("clonable", String.valueOf(isClonable));
                    } else if (bc instanceof Case && caseTemplate.isSecondaryEnabled()) {
                        Element elSecondaries = this.dataroot.addElement("secondaries");
                        Element elApplications = elSecondaries.addElement("applications");
                        Element elCases = elSecondaries.addElement("cases");
                        List<BaseCase> childCases = CaseService.getCasesByParentId(bc.getId());
                        ArrayList<String> caseIdsBucket = new ArrayList<String>();
                        boolean isSecondaryAvailable = !childCases.isEmpty();
                        for (SecondaryForm secondary : caseTemplate.getSecondaryReferences()) {
                            String linkToken = secondary.getLinkToken(bc.getOrganizationId());
                            if (linkToken == null) {
                                linkToken = FormService.createFormTemplateLink(secondary.getTemplateId(), bc.getOrganizationId());
                            }
                            if (linkToken != null) {
                                Element els = elApplications.addElement("application");
                                els.addAttribute("id", secondary.getTemplateId());
                                els.addAttribute("token", linkToken);
                                boolean isAvailable = bc.getStatusId().equals(secondary.getStatusId());
                                els.addAttribute("available", String.valueOf(isAvailable));
                                els.addAttribute("limit", String.valueOf(secondary.getTimelimit()));
                                isSecondaryAvailable = isSecondaryAvailable || isAvailable;
                                boolean isExpired = false;
                                int deadlineDays = secondary.getTimelimit();
                                if (deadlineDays > 0) {
                                    Calendar cal = Calendar.getInstance();
                                    cal.setTimeInMillis(bc.getDateCreated());
                                    cal.set(11, 24);
                                    cal.set(12, 0);
                                    cal.set(13, 0);
                                    cal.add(5, deadlineDays);
                                    els.addAttribute("deadline", String.valueOf(cal.getTimeInMillis()));
                                    isExpired = cal.getTime().before(new Date());
                                }
                                els.addAttribute("expired", String.valueOf(isExpired));
                                els.addAttribute("type", "template");
                                els.addElement("title").setText(secondary.getTemplateName());
                                List<FormCase> secList = this.getSecondaryApplications(childCases, secondary.getTemplateId());
                                if (!secList.isEmpty()) {
                                    for (FormCase secondaryApplication : secList) {
                                        if (caseIdsBucket.contains(secondaryApplication.getId())) continue;
                                        Element elCase = elCases.addElement("case");
                                        elCase.addAttribute("id", secondaryApplication.getId());
                                        elCase.addElement("title").setText(secondaryApplication.getSubject());
                                        elCase.addElement("created").setText(LocaleUtil.formatDate(secondaryApplication.getDateCreated()));
                                        if (secondaryApplication.getDateCompleted() > 0L) {
                                            elCase.addElement("completed").setText(LocaleUtil.formatDate(secondaryApplication.getDateCompleted()));
                                        }
                                        elCase.addElement("status").setText(secondaryApplication.getStatus().getSubject());
                                        caseIdsBucket.add(secondaryApplication.getId());
                                    }
                                }
                            }
                            elSecondaries.addAttribute("available", String.valueOf(isSecondaryAvailable));
                        }
                    }
                    if (isTasksEnabled) {
                        Element elTasks = this.dataroot.addElement("tasks");
                        List<Task> tasks = TaskService.getTasksByParentDocument(caseId);
                        super.showList(elTasks, tasks);
                    }
                    for (SubDocument subDoc : subDocuments) {
                        elSub.add(subDoc.getXml());
                    }
                    this.dataroot.addAttribute("createdocuments", String.valueOf(isNewDocsEnabled));
                    AuditLogEntry entry = new AuditLogEntry(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.READ);
                    LogService.createLogEntry(entry);
                    this.dataroot.addAttribute("tasks-enabled", String.valueOf(isTasksEnabled));
                    this.dataroot.addAttribute("sharing-enabled", String.valueOf(isSharingEnabled));
                }
            }
            if (!isValidRequest) {
                this.redirect(context, "mycases.html");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (DocumentSecurityException ex) {
            log.warn(ex.getMessage());
            this.redirect(context, "mycases.html");
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected List<FormCase> getSecondaryApplications(List<BaseCase> list, String formTemplateId) {
        ArrayList<FormCase> caseList = new ArrayList<FormCase>();
        for (BaseCase fc : list) {
            if (!(fc instanceof FormCase) || fc.isDeleted() || !((FormCase)fc).getFormtemplateId().equals(formTemplateId)) continue;
            caseList.add((FormCase)fc);
        }
        return caseList;
    }

    protected void createHistoryElement(AuditLog caseHistory) {
        Element elHistory = this.dataroot.addElement("history");
        List<AuditLogEntry> list = caseHistory.getEntries();
        HashMap<String, Integer> bucket = new HashMap<String, Integer>();
        for (AuditLogEntry entry : list) {
            if (bucket.containsKey(entry.getUserId())) continue;
            bucket.put(entry.getUserId(), bucket.size() + 1);
        }
        elHistory.addAttribute("users", String.valueOf(bucket.size()));
        boolean isUniqueImage = bucket.size() <= 5;
        for (AuditLogEntry entry : list) {
            Element el = this.getElement(entry);
            if (isUniqueImage) {
                el.addElement("class").setText("user-" + bucket.get(entry.getUserId()));
            } else {
                el.addElement("class").setText("user-1");
            }
            if (el.selectSingleNode("fullname") == null) {
                el.addElement("fullname").setText(this.resourceBundle.getString("inb.system"));
            } else if ("Agent Manager".equals(el.selectSingleNode("fullname").getText())) {
                el.selectSingleNode("fullname").setText(this.resourceBundle.getString("inb.system"));
            }
            elHistory.add(el);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    protected String getExtraParameter(WebContext context) {
        String doParam = context.getRequest().getParameter("do");
        if (StringUtil.isValid(doParam)) {
            return doParam;
        }
        return null;
    }

    protected boolean isDocumentCreationEnabled(BaseCase bc, User user) {
        return DocumentSecurityUtil.getDocumentPermission(AccessControl.Permission.WRITE, user, bc);
    }

    protected Element getElement(AuditLogEntry entry) {
        Element el = entry.getXml();
        Element elType = (Element)el.selectSingleNode("type");
        elType.setText(this.getTextValue("dt", entry.getDataType().toString()));
        elType.addAttribute("key", entry.getDataType().toString());
        Element elAction = (Element)el.selectSingleNode("action");
        elAction.setText(this.getTextValue("ac", entry.getAction().toString()));
        elAction.addAttribute("key", entry.getAction().toString());
        return el;
    }

    protected String getTextValue(String prefix, String enumType) {
        try {
            String key = prefix + "." + enumType;
            return rb.getString(key.toLowerCase());
        }
        catch (Exception ex) {
            return WordUtils.capitalize((String)enumType);
        }
    }
}

