/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class ApplicationsPage
extends BasePage {
    public static final String pageName = "applications.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            List<FormTemplate> templates = FormService.getFormTemplates();
            BaseDocumentUtil.removeDeletedDocuments(templates);
            this.removeExpiredTemplates(templates);
            this.removeHiddenTemplates(templates);
            User user = this.getCurrentUser(context);
            this.checkTargetGroupTemplates(templates, user);
            if (!user.isContact()) {
                this.removeContactTemplates(templates);
            }
            this.setFormTemplateData(context, templates);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    protected void setFormTemplateData(WebContext context, List<FormTemplate> list) {
        Hashtable ht = new Hashtable();
        for (FormTemplate ft : list) {
            for (Organization o : ft.getOrganizations()) {
                List<FormTemplate> l;
                if (o.isDeleted() || !o.isEnabled()) continue;
                if (ht.containsKey(o)) {
                    l = (List)ht.get(o);
                    l.add(ft);
                    continue;
                }
                l = new ArrayList();
                l.add(ft);
                ht.put(o, l);
            }
        }
        ArrayList organizationList = new ArrayList(ht.keySet());
        Collections.sort(organizationList);
        for (int i = 0; i < organizationList.size(); ++i) {
            Organization o = (Organization)organizationList.get(i);
            Element el = o.getXml(true);
            el.addAttribute("classname", this.getColumnCssClassName(this.getColumnCssClass(i + 1, organizationList.size())));
            List<String> categoryList = this.getCategoryIndex(list);
            List templateList = (List)ht.get(o);
            Hashtable<String, List<FormTemplate>> categoryTemplates = this.getCategorySortedTemplateList(templateList);
            for (String category : categoryList) {
                List<FormTemplate> lct = categoryTemplates.get(category);
                if (lct == null || lct.size() <= 0) continue;
                Collections.sort(lct);
                Element elCategory = el.addElement("category");
                elCategory.addAttribute("name", category);
                for (FormTemplate ft : lct) {
                    Element fel = ft.getXml();
                    fel.addAttribute("linktoken", ft.getLinkToken(o.getId()));
                    elCategory.add(fel);
                }
            }
            this.dataroot.add(el);
        }
    }

    protected Hashtable<String, List<FormTemplate>> getCategorySortedTemplateList(List<FormTemplate> list) {
        Hashtable<String, List<FormTemplate>> ht = new Hashtable<String, List<FormTemplate>>();
        if (list != null) {
            for (FormTemplate ft : list) {
                if (ht.containsKey(ft.getCategory())) {
                    ht.get(ft.getCategory()).add(ft);
                    continue;
                }
                ArrayList<FormTemplate> l = new ArrayList<FormTemplate>();
                l.add(ft);
                ht.put(ft.getCategory(), l);
            }
        }
        return ht;
    }

    protected List<String> getCategoryIndex(List<FormTemplate> list) {
        ArrayList<String> categoryList = new ArrayList<String>();
        for (FormTemplate ft : list) {
            if (categoryList.contains(ft.getCategory())) continue;
            categoryList.add(ft.getCategory());
        }
        Collections.sort(categoryList);
        return categoryList;
    }

    private void removeExpiredTemplates(List<FormTemplate> list) {
        Iterator<FormTemplate> it = list.iterator();
        while (it.hasNext()) {
            FormTemplate ft = it.next();
            if (ft.isWithinDateRestriction()) continue;
            it.remove();
        }
    }

    private void removeHiddenTemplates(List<FormTemplate> list) {
        Iterator<FormTemplate> it = list.iterator();
        while (it.hasNext()) {
            FormTemplate ft = it.next();
            if (ft.isVisible()) continue;
            it.remove();
        }
    }

    private void removeContactTemplates(List<FormTemplate> list) {
        Iterator<FormTemplate> it = list.iterator();
        while (it.hasNext()) {
            FormTemplate ft = it.next();
            if (!FormTemplate.Restriction.CONTACT.equals((Object)ft.getRestriction())) continue;
            it.remove();
        }
    }

    private void checkTargetGroupTemplates(List<FormTemplate> list, User currentUser) {
        Iterator<FormTemplate> it = list.iterator();
        while (it.hasNext()) {
            FormTemplate ft = it.next();
            FormTemplateExtras fex = ft.getExtendedData();
            if (fex == null || !StringUtil.isValid(fex.getTargetGroupId()) || currentUser.isInTargetGroup(fex.getTargetGroupId())) continue;
            it.remove();
        }
    }

    private String getColumnCssClassName(int classNum) {
        switch (classNum) {
            case 1: {
                return "onecol";
            }
            case 2: {
                return "twocols";
            }
            case 3: {
                return "threecols";
            }
            case 4: {
                return "fullcol";
            }
        }
        return "";
    }

    private int getColumnCssClass(int index, int total) {
        boolean isSingleTwoCol = (total - 1) % 3 == 0;
        boolean isNoTwoCol = (total - 2) % 3 == 0;
        int remains = total - index;
        if (total == 1) {
            return 1;
        }
        if (total == 2) {
            return 2;
        }
        if (total == 3) {
            if (index == total) {
                return 4;
            }
            return 2;
        }
        if (index <= 2) {
            return 2;
        }
        if (isSingleTwoCol && remains < 2) {
            return 2;
        }
        if (!isNoTwoCol && !isSingleTwoCol && remains < 4) {
            return 2;
        }
        return 3;
    }
}

