/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.services.UserService;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebUserPassword
extends WebElementBase {
    private static final String XSL_TEMPLATE = "selfservice/xml-password.xsl";
    private String userId;
    private String password;

    public void doGet(WebContext context) throws BirdException {
        try {
            this.userId = context.getRequest().getParameter("uid");
            this.password = context.getRequest().getParameter("pw");
            User user = UserService.getUser(this.userId);
            if (user != null) {
                Document doc = DocumentHelper.createDocument();
                Element root = doc.addElement("form");
                root.addElement("fullname").setText(user.getFullname());
                root.addElement("username").setText(user.getUsername());
                root.addElement("password").setText(this.password);
                root.addElement("address").setText(user.getAddress().getStreetName());
                root.addElement("state").setText(user.getAddress().getPostcode() + " " + user.getAddress().getCity());
                HttpServletResponse res = context.getResponseExclusive();
                res.setContentType("text/html; charset=" + SelfServiceEngine.getEncoding() + "");
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
                out.write(this.transformDocument(doc).getBytes("UTF-8"));
                out.close();
            }
        }
        catch (Exception ex) {
            throw new BirdException(ex);
        }
    }

    private String transformDocument(Document doc) throws Exception {
        InputStream in = SelfServiceEngine.getContext().getResourceAsStream("/WEB-INF/selfservice/xml-password.xsl");
        StreamSource sXsl = new StreamSource(in);
        StreamSource sXml = new StreamSource(new ByteArrayInputStream(doc.asXML().getBytes("UTF-8")));
        StringWriter strWriter = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        Transformer transformer = tFactory.newTransformer(sXsl);
        transformer.transform(sXml, new StreamResult(strWriter));
        return strWriter.toString();
    }
}

