/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.util.UID;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.UserRole;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.CaseExportUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.PasswordUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class WebUser
extends WebForm {
    public WebUser() {
        this.add(new Field("username"));
        this.add(new Field("fullname"));
        this.add(new Field("email"));
        this.add(new Field("phonenumber"));
        this.add(new Field("mobilenumber"));
        this.add(new Field("password"));
        this.add(new Field("address"));
        this.add(new Field("city"));
        this.add(new Field("postcode"));
        this.add(new Field("state"));
        this.add(new Field("country"));
        this.add(new Field("is-contact", 2));
        this.add(new Field("is-readonly-user", 2));
        this.add(new Field("is-send-notification", 2));
        this.add(new Field("is-gopro-relation", 2));
        this.add(new Field("companies", 5));
        this.add(new Field("contacts", 5));
        this.add(new Field("roles", 5));
        this.add(new Field("saveaction"));
    }

    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        String param = context.getRequest().getParameter("download");
        if (param != null) {
            String downloadType = context.getRequest().getParameter("type");
            String caseId = context.getRequest().getParameter("id");
            if (downloadType != null && caseId != null && "zip".equals(downloadType)) {
                this.getCaseAsZip(context, caseId);
            }
        }
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            User user = null;
            if (data.isCreate()) {
                user = new User();
                user.setPassword(data.getString("password"));
            } else if (data.isEdit()) {
                user = UserService.getUser(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && user != null) {
                user.setFullname(data.getString("fullname"));
                user.setEmail(data.getString("email"));
                user.setHomephoneNumber(data.getString("phonenumber", null));
                user.setMobilephoneNumber(data.getString("mobilenumber", null));
                user.setReadOnlyRestricted(data.getBoolean("is-readonly-user"));
                Address address = null;
                if (data.isCreate()) {
                    address = new Address();
                    user.setAddress(address);
                } else {
                    address = user.getAddress();
                }
                address.setStreetName(data.getString("address", null));
                address.setCity(data.getString("city", null));
                address.setPostcode(data.getString("postcode", null));
                address.setState(data.getString("state", null));
                address.setCountry(data.getString("country", null));
                user.getUserRoles().clear();
                List<UserRole> roleList = UserService.getUserRoles();
                Vector roles = data.getVector("roles");
                for (String role : roles) {
                    BaseDocument bs = BaseDocumentUtil.getDocumentFromList(role, roleList);
                    if (bs == null) continue;
                    user.getUserRoles().add((UserRole)bs);
                }
                if (data.isCreate()) {
                    user.setUsername(data.getString("username"));
                    user.setVerified(true);
                    UserService.createUser(user);
                    user.setPassword(data.getString("password"));
                    if (data.getBoolean("is-send-notification")) {
                        this.sendRegistrationEmail(user, user.getPassword());
                    }
                } else if (data.isEdit()) {
                    UserService.updateUser(user);
                }
            }
            if ("save".equals(data.getString("saveaction"))) {
                context.setRedirectPage("ss:user", "edit&id=" + user.getId() + "&reload=true");
            } else {
                context.setRedirectPage("ss:userlist");
            }
        }
        catch (SelfServiceException ex) {
            data.setError(ex.getMessage());
            ex.printStackTrace();
        }
        catch (UserException ex) {
            data.setError(ex.getMessage());
        }
        catch (CommunicationException ex) {
            data.setError(ex.getMessage());
        }
        catch (MessageException ex) {
            data.setError(ex.getMessage());
        }
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        if (data.isCreate()) {
            String genPass = data.getString("password");
            if ("".equals(genPass)) {
                genPass = UID.getUID().substring(0, 8);
            }
            el.addElement("generated-password").setText(genPass);
        }
        if (data.isEdit()) {
            try {
                User user = UserService.getUser(data.getID());
                if (user != null && user.getGoproClientReferences().size() > 0) {
                    Element elRef = el.addElement("references");
                    for (GoProClientBaseReference goProClientBaseReference : user.getGoproClientReferences()) {
                        Organization org = ConfigService.getOrganization(goProClientBaseReference.getOrganizationId());
                        if (org == null) continue;
                        Element xml = goProClientBaseReference.getXml();
                        xml.add(org.getXml());
                        elRef.add(xml);
                    }
                }
                if (user != null && user.isContact()) {
                    Element elContacts = el.addElement("contacts");
                    for (Contact contact : user.getContactList()) {
                        elContacts.add(contact.getXml());
                    }
                }
                if (!user.isInRole("A2AAC04696D89CBC6C56EF934F892410")) {
                    List<BaseCase> caselist = CaseService.getCases(data.getID());
                    BaseDocumentUtil.removeDeletedDocuments((Collection<? extends BaseDocument>)caselist);
                    if (caselist != null && caselist.size() > 0) {
                        Element elCases = el.addElement("cases");
                        Iterator iterator = caselist.iterator();
                        while (iterator.hasNext()) {
                            BaseCase bc = (BaseCase)iterator.next();
                            if (!(bc instanceof FormCase)) continue;
                            StatusListItem status = bc.getStatus();
                            Element caseEl = bc.getXml();
                            if (status != null && !status.getStatus().equals((Object)StatusListItem.Status.ACTIVE)) {
                                caseEl.addAttribute("active", String.valueOf(false));
                            } else {
                                caseEl.addAttribute("active", String.valueOf(true));
                            }
                            elCases.add(caseEl);
                        }
                    }
                }
            }
            catch (SelfServiceException ex) {
                throw new BirdException((Exception)ex);
            }
        }
        try {
            List<UserRole> userRoles = UserService.getUserRoles();
            for (UserRole role : userRoles) {
                el.add(role.getXml());
            }
            List<Company> companies = UserService.getCompanies();
            BaseDocumentUtil.removeDeletedDocuments(companies);
            for (Company company : companies) {
                el.add(company.getXml());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            User user;
            if ((data.isOpen() || data.isEdit()) && (user = UserService.getUser(data.getID())) != null) {
                data.put("username", user.getUsername());
                data.put("fullname", user.getFullname());
                data.put("email", user.getEmail());
                data.put("phonenumber", user.getHomephoneNumber());
                data.put("mobilenumber", user.getMobilephoneNumber());
                data.put("is-readonly-user", (Object)user.isReadOnlyRestricted());
                data.put("is-gopro-relation", (Object)(user.getGoproClientReferences().size() > 0 ? 1 : 0));
                Vector<String> vRoles = new Vector<String>();
                for (UserRole userRole : user.getUserRoles()) {
                    vRoles.add(userRole.getId());
                }
                data.put("roles", vRoles);
                if (user.getAddress() != null) {
                    data.put("address", user.getAddress().getStreetName());
                    data.put("city", user.getAddress().getCity());
                    data.put("postcode", user.getAddress().getPostcode());
                    data.put("state", user.getAddress().getState());
                    data.put("country", user.getAddress().getCountry());
                }
                data.put("is-contact", (Object)(!user.getContactList().isEmpty() ? 1 : 0));
                Vector<String> vContacts = new Vector<String>();
                for (Contact contact : user.getContactList()) {
                    vContacts.add(contact.getId());
                }
                try {
                    String string = this.checkPasswordReset(context, user);
                    if (string != null) {
                        ResourceBundle rb = LocaleUtil.getResourceBundle("admin.admin", context.getSession().getLocale());
                        context.getRootElement().addAttribute("message", rb.getString("user.passreset") + ": " + string);
                    }
                }
                catch (UserException userException) {
                    data.setError(userException.getMessage());
                    return false;
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        String[] fields;
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        for (String field : fields = new String[]{"username", "fullname", "email", "address", "city", "country"}) {
            if (!data.getString(field).equals("")) continue;
            String rbKey = "user." + field;
            data.setError(rb.getString(rbKey));
            return false;
        }
        try {
            User user;
            if (data.isEdit() && (user = UserService.getUser(data.getID())) != null && user.isContact()) {
                data.put("is-company-user", (Object)true);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        if (!StringUtil.isValidEmail(data.getString("email"))) {
            data.setError(rb.getString("user.email"));
            return false;
        }
        Vector roles = data.getVector("roles");
        if (roles == null || roles.size() == 0) {
            data.setError(rb.getString("user.roles"));
            return false;
        }
        return true;
    }

    private String checkPasswordReset(WebContext context, User user) throws UserException, SelfServiceException {
        String action = context.getRequest().getParameter("do");
        String letter = context.getRequest().getParameter("letter");
        if (action != null && "reset".equals(action)) {
            String password = UID.getUID().substring(0, 8);
            user.setPassword(PasswordUtil.encryptPassword(password));
            user.setTriggerGoProUpdate(false);
            UserService.updateUser(user);
            if (letter != null && "true".equals(letter)) {
                context.getRootElement().addAttribute("useraction", "letter");
                context.getRootElement().addAttribute("password", password);
            }
            return password;
        }
        return null;
    }

    private final void sendRegistrationEmail(User user, String password) throws CommunicationException, MessageException, SelfServiceException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
        String subject = Translator.translate((BaseDocument)user, rb.getString("register.subject"));
        String message = rb.getString("register.body") + rb.getString("mail.footer");
        message = Translator.translate((BaseDocument)user, message);
        message = message.replace("[user.password]", password);
        Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.EMAIL, false);
    }

    private void getCaseAsZip(WebContext context, String caseId) throws BirdException {
        block24: {
            ServletOutputStream stream = null;
            BufferedInputStream buf = null;
            File zipFile = null;
            try {
                HttpServletResponse response = context.getResponseExclusive();
                zipFile = CaseExportUtil.getCaseFiles(caseId, true);
                if (zipFile != null) {
                    response.setContentType("application/zip");
                    response.setContentLength((int)zipFile.length());
                    String filename = zipFile.getName();
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                    response.setHeader("Pragma", "public");
                    response.setHeader("Cache-Control", "private, max-age=15");
                    FileInputStream input = new FileInputStream(zipFile);
                    buf = new BufferedInputStream(input);
                    stream = response.getOutputStream();
                    int readBytes = 0;
                    while ((readBytes = buf.read()) != -1) {
                        stream.write(readBytes);
                    }
                }
            }
            catch (SocketException deleteSuccess) {
                boolean deleteSuccess2 = false;
                try {
                    if (zipFile != null) {
                        deleteSuccess2 = zipFile.delete();
                    }
                    if (buf != null) {
                        buf.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException ex) {
                    if (!deleteSuccess2) {
                        context.getSession().getLog().error("Could not clean up and delete file. " + ex.getMessage());
                        break block24;
                    }
                    throw new BirdException((Exception)ex);
                }
            }
            catch (IOException ex) {
                throw new BirdException((Exception)ex);
            }
            catch (SelfServiceException ex) {
                throw new BirdException((Exception)ex);
            }
            finally {
                boolean deleteSuccess = false;
                try {
                    if (zipFile != null) {
                        deleteSuccess = zipFile.delete();
                    }
                    if (buf != null) {
                        buf.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException ex) {
                    if (!deleteSuccess) {
                        context.getSession().getLog().error("Could not clean up and delete file. " + ex.getMessage());
                    }
                    throw new BirdException((Exception)ex);
                }
            }
        }
    }
}

