/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.FormTranslationFactory;
import net.gopro.selfservice.forms.IFormTranslation;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.FormService;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class WebTranslationList
extends WebBaseList {
    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        String templateId = context.getRequest().getParameter("template_id");
        String action = context.getRequest().getParameter("action");
        try {
            if ("status".equals(action)) {
                this.doChangeStatus(context, context.getRequest().getParameter("id"));
            } else if ("download".equals(action)) {
                this.doDownloadTranslationFile(context, context.getRequest().getParameter("id"));
            }
            if (templateId != null) {
                this.getStaticElement().addAttribute("template-id", templateId);
                if ("template".equals(action)) {
                    FormTemplate formTemplate = FormService.getFormTemplate(templateId, false);
                    this.downloadTemplate(context, formTemplate);
                }
                List<FormTranslation> list = FormService.getTranslations(templateId);
                this.showList(list);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (FormException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private void doDownloadTranslationFile(WebContext context, String translationId) throws SelfServiceException {
        try {
            HttpServletResponse response = context.getResponseExclusive();
            FormTranslation trans = FormService.getTranslation(translationId);
            FormTemplate template = FormService.getFormTemplate(trans.getTemplateId(), false);
            Document doc = FormsUtil.createDocument(trans.getStream());
            OutputFormat format = OutputFormat.createPrettyPrint();
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(doc);
            byte[] data = sw.toString().getBytes("UTF-8");
            String filename = template.getSubject() + "_" + trans.getIsocode() + ".xml";
            response.setContentLength(data.length);
            response.setContentType("text/xml;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "private, max-age=15");
            response.getOutputStream().write(data);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void downloadTemplate(WebContext context, FormTemplate template) throws FormException, SelfServiceException {
        try {
            IFormTranslation ift = FormTranslationFactory.getInstance(template);
            Document translationTemplate = ift.getTranslationTemplate();
            OutputFormat format = OutputFormat.createPrettyPrint();
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(translationTemplate);
            HttpServletResponse response = context.getResponseExclusive();
            byte[] data = sw.toString().getBytes("UTF-8");
            String filename = "translation_template_" + template.getSubject() + ".xml";
            response.setContentLength(data.length);
            response.setContentType("text/xml;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "private, max-age=15");
            response.getOutputStream().write(data);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void doChangeStatus(WebContext context, String translationId) throws BirdException {
        try {
            FormTranslation tr = FormService.getTranslation(translationId);
            if (tr != null) {
                tr.setEnabled(!tr.isEnabled());
                FormService.updateTranslation(tr);
                context.setRedirectPage("ss:translationlist", "template_id=" + tr.getTemplateId());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
        try {
            FormTranslation tr = FormService.getTranslation(documentId);
            if (tr != null) {
                tr.setDeleted(true);
                FormService.updateTranslation(tr);
                context.setRedirectPage("ss:translationlist", "template_id=" + tr.getTemplateId());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
    }
}

