/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;

public class WebTranslationFile
extends WebForm {
    private String templateId = null;

    public WebTranslationFile() {
        this.add(new Field("language-id"));
        this.add(new Field("is-enabled", 2));
        this.add(new Field("translation-file", 6));
        this.add(new Field("template-id"));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        FormTranslation trans = null;
        try {
            if (data.isCreate()) {
                trans = new FormTranslation();
            } else if (data.isEdit()) {
                trans = FormService.getTranslation(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && trans != null) {
                trans.setTemplateId(this.templateId);
                String languageId = data.getString("language-id");
                Locale loc = new Locale(languageId);
                trans.setLanguage(loc.getDisplayLanguage());
                trans.setIsocode(languageId);
                trans.setEnabled(data.getBoolean("is-enabled"));
                InputStream in = data.getInputStream("translation-file");
                if (in != null) {
                    byte[] stream = IOUtils.toByteArray((InputStream)in);
                    trans.setStream(stream);
                }
                if (data.isCreate()) {
                    FormService.createTranslation(trans);
                } else if (data.isEdit()) {
                    FormService.updateTranslation(trans);
                }
            }
            context.setRedirectPage("ss:translationlist", "template_id=" + this.templateId);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (IOException ex) {
            data.setError(ex.getMessage());
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isCreate()) {
                this.templateId = context.getRequest().getParameter("template_id");
                data.put("template-id", this.templateId);
            } else if (data.isEdit() || data.isOpen()) {
                FormTranslation translation = FormService.getTranslation(data.getID());
                if (translation != null) {
                    this.templateId = translation.getTemplateId();
                    data.put("is-enabled", (Object)translation.isEnabled());
                    data.put("template-id", this.templateId);
                    data.put("language-id", translation.getIsocode());
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        data.put("language-id", data.getString("language-id"));
        data.put("is-enabled", (Object)data.getBoolean("is-enabled"));
        if ("".equals(data.getString("language-id"))) {
            data.setError(rb.getString("transfile.title"));
            return false;
        }
        try {
            List<FormTranslation> translations = FormService.getTranslations(data.getString("template-id"));
            for (FormTranslation ft : translations) {
                if (ft.getId().equals(data.getID()) || !ft.getIsocode().equalsIgnoreCase(data.getString("language-id"))) continue;
                data.setError(rb.getString("transfile.exists"));
                return false;
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        try {
            InputStream in = data.getInputStream("translation-file");
            if (data.isCreate() && in == null) {
                data.setError(rb.getString("transfile.invalid"));
                return false;
            }
            if (in != null && in.available() == 0) {
                data.setError(rb.getString("transfile.invalid"));
                return false;
            }
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        for (String lang : Locale.getISOLanguages()) {
            Locale l = new Locale(lang);
            Element elLang = el.addElement("language");
            elLang.addAttribute("id", l.getLanguage());
            elLang.setText(l.getDisplayLanguage());
        }
    }
}

