/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.FormTranslationFactory;
import net.gopro.selfservice.forms.IFormTranslation;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class WebTranslation
extends WebForm {
    public WebTranslation() {
        this.add(new Field("template-id"));
        this.add(new Field("language-id"));
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            FormTranslation trans;
            if (data.isCreate()) {
                String templateId = context.getRequest().getParameter("template_id");
                data.put("template-id", templateId);
            } else if ((data.isEdit() || data.isOpen()) && (trans = FormService.getTranslation(data.getID())) != null) {
                data.put("template-id", trans.getTemplateId());
                data.put("language-id", trans.getIsocode());
                Document template = FormsUtil.createDocument(trans.getStream());
                FormTemplate ft = FormService.getFormTemplate(trans.getTemplateId(), true);
                IFormTranslation ift = FormTranslationFactory.getInstance(ft);
                Hashtable<String, String> bucket = ift.getTranslationBucket(template);
                Set<String> keys = bucket.keySet();
                data.put(bucket);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (FormException ex) {
            throw new BirdException((Exception)ex);
        }
        return true;
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            if (data.isCreate()) {
                String templateId = data.getString("template-id");
                String languageId = data.getString("language-id");
                Locale locale = new Locale(languageId);
                FormTemplate ft = FormService.getFormTemplate(templateId, true);
                IFormTranslation ift = FormTranslationFactory.getInstance(ft);
                Document doc = ift.generateTranslationFile(locale, data.getHashtable());
                FormTranslation trans = new FormTranslation();
                trans.setTemplateId(templateId);
                trans.setLanguage(locale.getDisplayLanguage());
                trans.setIsocode(locale.getLanguage());
                trans.setStream(doc.asXML().getBytes("UTF-8"));
                FormService.createTranslation(trans);
                context.setRedirectPage("ss:translationlist", "template_id=" + templateId);
            } else if (data.isEdit()) {
                String templateId = data.getString("template-id");
                FormTranslation trans = FormService.getTranslation(data.getID());
                Locale locale = new Locale(trans.getIsocode());
                FormTemplate ft = FormService.getFormTemplate(templateId, true);
                IFormTranslation ift = FormTranslationFactory.getInstance(ft);
                Document doc = ift.generateTranslationFile(locale, data.getHashtable());
                trans.setStream(doc.asXML().getBytes("UTF-8"));
                FormService.updateTranslation(trans);
                if (data.getBoolean("save-and-close")) {
                    context.setRedirectPage("ss:translationlist", "template_id=" + templateId);
                } else {
                    context.setRedirectPage("ss:translation", "edit&id=" + data.getID() + "&template_id=" + templateId);
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (FormException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        if (data.isCreate() && data.getString("language-id").equals("")) {
            data.setError(rb.getString("transfile.title"));
            return false;
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        Element elLanguages = el.addElement("languages");
        for (String lang : Locale.getISOLanguages()) {
            Locale l = new Locale(lang);
            Element elLang = elLanguages.addElement("language");
            elLang.addAttribute("id", l.getLanguage());
            elLang.setText(l.getDisplayLanguage());
        }
        try {
            if (data.isCreate() || data.isEdit()) {
                String templateId = data.getString("template-id");
                FormTemplate fte = FormService.getFormTemplate(templateId, true);
                IFormTranslation ift = FormTranslationFactory.getInstance(fte);
                Document translationTemplate = ift.getTranslationTemplate();
                if (translationTemplate == null) {
                    throw new BirdException("Could not retrieve translation template");
                }
                el.add(translationTemplate.getRootElement());
                List<FormTranslation> translations = FormService.getTranslations(templateId);
                Element elExisting = el.addElement("available");
                for (FormTranslation ft : translations) {
                    Element elx = elExisting.addElement("entry");
                    elx.setText(ft.getLanguage());
                    elx.addAttribute("iso", ft.getIsocode());
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (FormException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

