/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.Iterator;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.TargetgroupService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import org.dom4j.Element;

public class WebTargetgroupList
extends WebBaseList {
    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        try {
            List<TargetGroup> list = TargetgroupService.getTargetGroups();
            BaseDocumentUtil.removeDeletedDocuments(list);
            Iterator<TargetGroup> it = list.iterator();
            while (it.hasNext()) {
                TargetGroup group = it.next();
                if (!TargetGroup.Generator.CONTACTS.equals((Object)group.getGenerator())) continue;
                it.remove();
            }
            this.showList(list);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
        try {
            TargetgroupService.deleteTargetGroup(documentId);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
        try {
            TargetGroup group;
            if ("userview".equals(filter) && (group = TargetgroupService.getTargetGroup(key, true)) != null) {
                this.getStaticElement().add(group.getXml());
                Element el = this.getStaticElement().addElement("users");
                for (TargetGroupUser user : group.getGroupUsers()) {
                    el.add(user.getXml());
                }
            }
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

