/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.ResourceBundle;
import net.gopro.selfservice.ITargetGroupGenerator;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.agents.TargetGroupAgent;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.services.TargetgroupService;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class WebTargetgroup
extends WebForm {
    public WebTargetgroup() {
        this.add(new Field("name"));
        this.add(new Field("description"));
        this.add(new Field("is-enabled", 2));
        this.add(new Field("user-list"));
        this.add(new Field("classname"));
        this.add(new Field("classparams"));
        this.add(new Field("population"));
        this.add(new Field("update-interval", 1));
    }

    /*
     * Exception decompiling
     */
    public void doSave(WebContext context, Form data) throws BirdException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            TargetGroup tg;
            if ((data.isOpen() || data.isEdit()) && (tg = TargetgroupService.getTargetGroup(data.getID(), false)) != null) {
                data.put("name", tg.getSubject());
                data.put("is-enabled", (Object)tg.isEnabled());
                data.put("description", tg.getDescription());
                data.put("population", tg.getGenerator().toString().toLowerCase());
                data.put("classname", tg.getClassName());
                data.put("classparams", tg.getClassParameters());
                data.put("update-interval", tg.getUpdateHourInterval());
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        data.put("is-enabled", (Object)data.getBoolean("is-enabled"));
        data.put("population", data.getString("population"));
        if ("".equals(data.getString("name"))) {
            data.setError(rb.getString("target.name"));
            return false;
        }
        TargetGroup.Generator generator = TargetGroup.Generator.valueOf(data.getString("population").toUpperCase());
        if (generator.equals((Object)TargetGroup.Generator.CLASS)) {
            String className = data.getString("classname");
            try {
                Object o = Class.forName(className).newInstance();
                if (!(o instanceof ITargetGroupGenerator)) {
                    data.setError("The class " + className + " does not implement the interface:  ITargetGroupGenerator");
                    return false;
                }
            }
            catch (Exception ex) {
                data.setError(rb.getString("target.class"));
                return false;
            }
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        try {
            TargetGroup tg;
            int[] interval;
            Element el = context.getRootElement().addElement("static");
            Element elInterval = el.addElement("interval");
            for (int i : interval = new int[]{24, 12, 8, 6, 4, 2, 1}) {
                Element elItem = elInterval.addElement("count");
                elItem.setText(StringUtil.zeroPad(i));
                elItem.addAttribute("key", String.valueOf(i));
            }
            if (data.isEdit() && !StringUtil.isValid((tg = TargetgroupService.getTargetGroup(data.getID(), false)).getClassName())) {
                tg = TargetgroupService.getTargetGroup(data.getID(), true);
                for (TargetGroupUser user : tg.getGroupUsers()) {
                    el.add(user.getXml());
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private void triggerExecution(TargetGroup tg) throws BirdException {
        try {
            if (tg != null && tg.isEnabled() && tg.getGenerator().equals((Object)TargetGroup.Generator.CLASS)) {
                String jobName = "RunTime-" + tg.getSubject();
                String groupName = "TargetGroup";
                JobDataMap map = new JobDataMap();
                map.put("id", tg.getId());
                JobDetail jobDetail = new JobDetail(jobName, "TargetGroup", TargetGroupAgent.class);
                jobDetail.setJobDataMap(map);
                jobDetail.setName(jobName);
                Trigger trigger = TriggerUtils.makeImmediateTrigger((int)0, (long)0L);
                trigger.setName(jobName);
                trigger.setGroup("TargetGroup");
                SelfServiceEngine.getScheduler().scheduleJob(jobDetail, trigger);
                SelfServiceEngine.getScheduler().deleteJob(jobName, "TargetGroup");
            }
        }
        catch (SchedulerException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
    }
}

