/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.ws.WebServiceException;
import net.gopro.broker.client.BrokerClientService;
import net.gopro.broker.client.data.DocumentType;
import net.gopro.broker.client.data.ErrorType;
import net.gopro.broker.client.data.RoutingStatus;
import net.gopro.broker.client.data.RoutingTransitType;
import net.gopro.broker.client.data.types.RoutingStatusType;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.data.routing.BrokerRelationEntry;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.QueueService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebRoute
extends WebElementBase {
    private static final String BASE = "services/BrokerService";
    private ResourceBundle rb = null;

    public void doGet(WebContext context) throws BirdException {
        block12: {
            try {
                ErrorType errorType;
                BrokerRelationEntry brokerRelation;
                Organization target;
                BrokerClientService client;
                RoutingStatus status;
                String queueId = context.getRequest().getParameter("id");
                this.rb = LocaleUtil.getResourceBundle("admin.admin", context.getSession().getLocale());
                ArrayList<RoutingNode> routeList = new ArrayList<RoutingNode>();
                if (queueId == null || "".equals(queueId) || (status = (client = this.getService(target = ConfigService.getOrganization((brokerRelation = QueueService.getBrokerRelationEntry(queueId)).getOrganizationId()))).getRoutingStatus(brokerRelation.getTransactionId())) == null) break block12;
                this.createRouteList(routeList, status);
                if (status.getStatus().equals(RoutingStatusType.ERROR) && (errorType = status.getErrorType()) != null) {
                    Element elError = context.getRootElement().addElement("error");
                    elError.addElement("subject").addCDATA(errorType.getSubject());
                    elError.addElement("stacktrace").addCDATA(errorType.getStacktrace());
                }
                Date startDate = null;
                Date endDate = null;
                Element root = context.getRootElement();
                for (RoutingNode node : routeList) {
                    root.add(node.getXml());
                    if (node.isOrigin) {
                        startDate = node.departure;
                        continue;
                    }
                    if (!node.isDestination) continue;
                    endDate = node.arrival;
                }
                if (!RoutingStatusType.FINISHED.equals(status.getStatus())) break block12;
                Element el = root.addElement("routeinfo");
                el.addAttribute("confirmed", "true");
                el.addElement("status").setText(this.rb.getString("status.finished"));
                el.addElement("hops").setText(String.valueOf(routeList.size()));
                if (startDate != null && endDate != null) {
                    String duration = DurationFormatUtils.formatPeriod((long)startDate.getTime(), (long)endDate.getTime(), (String)"H:mm:ss");
                    el.addElement("duration").setText(duration);
                }
                el.addElement("goproclient").setText(target.getSubject());
                for (RoutingNode node : routeList) {
                    if (!node.isDestination) continue;
                    el.addElement("goproname").setText(node.typeName);
                    el.addElement("goprohost").setText(node.name);
                    break;
                }
                for (DocumentType doc : status.getDocuments().getDocumentTypes()) {
                    if (!doc.getDocumentId().equals(brokerRelation.getId())) continue;
                    el.addElement("doctype").setText(doc.getType());
                    Dom4JUtil.addElement(el, "casenumber", doc.getCaseNumber());
                    if (doc.getType().equals(CaseType.class.getSimpleName())) {
                        BaseCase bc = CaseService.getCase(doc.getDocumentId());
                        User owner = UserService.getUser(bc.getCreatedById());
                        el.addElement("caseowner").setText(owner.getFullname());
                    } else {
                        SubDocument sub = CaseService.getSubDocument(doc.getDocumentId(), false);
                        User owner = UserService.getUser(sub.getCreatedById());
                        el.addElement("caseowner").setText(owner.getFullname());
                    }
                    break;
                }
            }
            catch (SelfServiceException ex) {
                throw new BirdException((Exception)ex);
            }
            catch (GoProDataStoreException ex) {
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                ex.printStackTrace(printWriter);
                Element elError = context.getRootElement().addElement("exception");
                elError.addElement("subject").addCDATA(ex.getMessage());
                elError.addElement("stacktrace").addCDATA(((Object)result).toString());
            }
            catch (GdfServiceException ex) {
                throw new BirdException((Exception)((Object)ex));
            }
        }
    }

    private void createRouteList(List<RoutingNode> list, RoutingStatus status) {
        if (status.getTransits() != null) {
            for (RoutingTransitType transit : status.getTransits().getRoutingTransitTypes()) {
                RoutingNode node = new RoutingNode(transit);
                list.add(node);
            }
        }
    }

    private final BrokerClientService getService(Organization org) throws GoProDataStoreException {
        try {
            Endpoint endpoint = org.getEndpoint();
            if (endpoint == null) {
                throw new GoProDataStoreException("The Organization Endpoint is missing");
            }
            String hostname = endpoint.getHostname();
            String destinationId = endpoint.getBrokerDestinationId();
            String senderId = SelfServiceEngine.getConfig("broker.selfservice.id");
            if (!StringUtil.isValid(hostname)) {
                throw new GoProDataStoreException("The Broker hostname is missing!");
            }
            if (!StringUtil.isValid(destinationId)) {
                throw new GoProDataStoreException("The Broker destination Id for this organization is missing!");
            }
            if (!StringUtil.isValid(senderId)) {
                throw new GoProDataStoreException("The Broker Sender id is missing, please add the config key: \"broker.selfservice.id\" and try again.");
            }
            String url = hostname + BASE + "?wsdl";
            BrokerClientService service = new BrokerClientService(url);
            return service;
        }
        catch (WebServiceException ex) {
            throw new GoProDataStoreException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private class RoutingNode {
        private String name;
        private String type;
        private String typeName;
        private Date arrival;
        private Date departure;
        private RoutingStatusType status;
        private boolean isOrigin = false;
        private boolean isDestination = false;

        public RoutingNode(RoutingTransitType rt) {
            this.name = rt.getTransitName();
            this.type = rt.getTransitType();
            this.typeName = rt.getTransitTypeName();
            this.arrival = rt.getArrivalDate();
            this.departure = rt.getDepartureDate();
            this.status = rt.getStatus();
            this.isOrigin = rt.isIsOrigin();
            this.isDestination = rt.isIsDestination();
        }

        public Element getXml() {
            Element el = DocumentHelper.createElement((String)"routingnode");
            if (this.isOrigin) {
                Dom4JUtil.addElement(el, "name", "Self Service");
            } else {
                Dom4JUtil.addElement(el, "name", this.name);
            }
            el.addAttribute("endpoint", this.type.toString());
            Dom4JUtil.addElement(el, "type", this.type);
            Dom4JUtil.addElement(el, "typename", this.typeName);
            if (this.arrival != null) {
                Dom4JUtil.addElement(el, "arrival", LocaleUtil.formatDate(this.arrival.getTime()));
            } else if (this.isOrigin) {
                Dom4JUtil.addElement(el, "arrival", LocaleUtil.formatDate(this.departure.getTime()));
            }
            if (this.departure != null) {
                Dom4JUtil.addElement(el, "departure", LocaleUtil.formatDate(this.departure.getTime()));
            }
            if (this.arrival != null) {
                if (this.isDestination || this.isOrigin) {
                    Dom4JUtil.addElement(el, "delay", "-");
                } else {
                    Date departureDate = this.departure != null ? this.departure : new Date();
                    String duration = DurationFormatUtils.formatPeriod((long)this.arrival.getTime(), (long)departureDate.getTime(), (String)"H:mm:ss");
                    Dom4JUtil.addElement(el, "delay", duration);
                }
            }
            if (this.status != null) {
                String st = "status." + this.status.toString();
                try {
                    Dom4JUtil.addElement(el, "status", WebRoute.this.rb.getString(st.toLowerCase()));
                }
                catch (MissingResourceException ex) {
                    Dom4JUtil.addElement(el, "status", this.status.toString());
                }
            }
            return el;
        }
    }
}

