/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.MessageTemplate;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class WebMessageTemplate
extends WebForm {
    public WebMessageTemplate() {
        this.add(new Field("title", true));
        this.add(new Field("description", 0));
        this.add(new Field("category", 0, true));
        this.add(new Field("subject", 0, true));
        this.add(new Field("body", 0, true));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            MessageTemplate mt = null;
            if (data.isCreate()) {
                mt = new MessageTemplate();
            } else if (data.isEdit()) {
                mt = ConfigService.getMessageTemplate(data.getID());
            }
            if (data.isCreate() || data.isEdit()) {
                mt.setTitle(data.getString("title"));
                mt.setDescription(data.getString("description"));
                mt.setCategoryId(data.getString("category"));
                mt.setSubject(data.getString("subject"));
                mt.setBody(data.getString("body"));
                if (data.isCreate()) {
                    ConfigService.createMessageTemplate(mt);
                } else if (data.isEdit()) {
                    ConfigService.updateMessageTemplate(mt);
                }
            }
            context.setRedirectPage("ss:messagetemplatelist");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isOpen() || data.isEdit()) {
                MessageTemplate mt = ConfigService.getMessageTemplate(data.getID());
                if (mt != null) {
                    data.put("title", mt.getTitle());
                    data.put("description", mt.getDescription());
                    data.put("category", mt.getCategoryId());
                    data.put("subject", mt.getSubject());
                    data.put("body", mt.getBody());
                }
            } else if (data.isCreate()) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
                data.put("subject", LocaleUtil.getStringSafe(rb, "application.new.subject", "portal.messages"));
                data.put("body", LocaleUtil.getStringSafe(rb, "application.new.body", "portal.messages"));
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        data.put("category", data.get("category"));
        if (data.getString("title").equals("")) {
            data.setError(rb.getString("ann.title"));
            return false;
        }
        if (data.getString("subject").equals("")) {
            data.setError("Subject cannot be empty");
            return false;
        }
        if (data.getString("category").equals("")) {
            data.setError("You must select a category");
            return false;
        }
        if (data.getString("body").equals("")) {
            data.setError(rb.getString("ann.body"));
            return false;
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        try {
            Element el = context.getRootElement().addElement("static");
            List categoryList = ConfigService.getList("2AEA6BBC7B8DBD1400000159208FEE82");
            for (ListItem item : categoryList.getListItems()) {
                if (item.isDeleted()) continue;
                Element elCategory = el.addElement("category");
                elCategory.setText(item.getSubject());
                elCategory.addAttribute("id", item.getId());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

