/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormGuidance;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.GuidanceException;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.SaxReader;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.lang.WordUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class WebGuidance
extends WebForm {
    public WebGuidance() {
        this.add(new Field("template-id"));
        this.add(new Field("section-id"));
        this.add(new Field("subject", true));
        this.add(new Field("description"));
        this.add(new Field("weblink"));
        this.add(new Field("image-path"));
        this.add(new Field("is-expanded", 2));
        this.add(new Field("is-goproform", 2));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            String templateId = data.getString("template-id");
            FormTemplate ft = FormService.getFormTemplate(templateId, true);
            FormGuidance gd = null;
            if (ft == null) {
                throw new BirdException("The parent form template was not found!");
            }
            if (data.isCreate()) {
                gd = new FormGuidance();
                gd.setFormtemplateId(ft.getId());
            } else if (data.isEdit()) {
                gd = ft.getGuidance(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && gd != null) {
                gd.setSubject(data.getString("subject", null));
                gd.setBody(data.getString("description", null));
                gd.setSectionId(data.getString("section-id", null));
                gd.setExpanded(data.getBoolean("is-expanded"));
                gd.setImage(data.getString("image-path", null));
                gd.setUrlLink(data.getString("weblink", null));
                if (data.isCreate()) {
                    FormService.createGuidance(gd);
                } else if (data.isEdit()) {
                    FormService.updateGuidance(gd);
                }
            }
            context.setRedirectPage("ss:formtemplate", "edit&id=" + ft.getId() + "#guidance");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (GuidanceException ex) {
            data.setError(ex.getMessage());
        }
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        try {
            String templateId = null;
            if (data.isCreate()) {
                templateId = context.getRequest().getParameter("template_id");
                if (templateId == null) {
                    templateId = data.getString("template-id");
                }
            } else if (data.isEdit() || data.isOpen()) {
                templateId = context.getRequest().getParameter("tid");
            }
            if (templateId != null) {
                FormTemplate ft = FormService.getFormTemplate(templateId, true);
                data.put("template-id", ft.getId());
                data.put("is-goproform", (Object)(ft instanceof GoProFormTemplate));
                if (ft instanceof GoProFormTemplate) {
                    Hashtable<String, String> sectionList = ((GoProFormTemplate)ft).getSections();
                    Enumeration<String> keys = sectionList.keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        Element elk = el.addElement("section");
                        elk.addAttribute("fulltext", sectionList.get(key));
                        elk.setText(StringUtil.shortenText(sectionList.get(key), 50));
                        elk.addAttribute("id", key);
                    }
                }
            }
            InputStream in = WebGuidance.class.getResourceAsStream("/net/gopro/selfservice/files/guidance-icons.xml");
            SAXReader reader = SaxReader.createReader();
            Document docIcons = reader.read(in);
            Iterator it = docIcons.getRootElement().selectNodes("icon").iterator();
            while (it.hasNext()) {
                Node elIcon = ((Element)it.next()).detach();
                String icon = elIcon.valueOf("@value");
                ((Element)elIcon).addAttribute("title", WordUtils.capitalize((String)icon.replace("icon", "").replace("-", " ")));
                el.add(elIcon);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (FormException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (DocumentException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isCreate()) {
                String templateId = context.getRequest().getParameter("template_id");
                if (templateId == null) return true;
                FormTemplate ft = FormService.getFormTemplate(templateId, false);
                if (ft == null) throw new BirdException("Invalid template Id");
                data.put("template-id", ft.getId());
                data.put("is-goproform", (Object)(ft instanceof GoProFormTemplate));
                return true;
            } else {
                String templateId;
                if (!data.isEdit() && !data.isOpen() || (templateId = context.getRequest().getParameter("tid")) == null) return true;
                FormTemplate ft = FormService.getFormTemplate(templateId, false);
                if (ft == null) throw new BirdException("Invalid template Id");
                FormGuidance gd = ft.getGuidance(data.getID());
                if (gd == null) return true;
                data.put("template-id", ft.getId());
                data.put("is-goproform", (Object)(ft instanceof GoProFormTemplate));
                data.put("subject", gd.getSubject());
                data.put("section-id", gd.getSectionId());
                data.put("description", gd.getBody());
                data.put("weblink", gd.getUrlLink());
                data.put("image-path", gd.getImage());
                data.put("is-expanded", (Object)gd.isExpanded());
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        data.put("is-expanded", (Object)data.getBoolean("is-expanded"));
        if (data.contains("section-id")) {
            data.put("is-goproform", (Object)true);
        }
        if (data.getString("template-id").equals("")) {
            data.setError(rb.getString("gd.template"));
            return false;
        }
        if (data.getString("subject").equals("")) {
            data.setError(rb.getString("gd.subject"));
            return false;
        }
        if (data.getString("description").equals("") && data.getString("weblink").equals("")) {
            data.setError(rb.getString("gd.missing"));
            return false;
        }
        return true;
    }
}

