/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.Set;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.exceptions.ConfigException;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class WebConfigList
extends WebBaseList {
    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        try {
            Element root = this.getRootElement();
            String section = context.getRequest().getParameter("section");
            String ref = context.getRequest().getParameter("ref");
            Set<ConfigEntry> list = null;
            if (section != null && !"".equals(section)) {
                list = ConfigService.getConfig(section);
                root.addAttribute("section", section);
                if (ref != null && !"".equals(ref)) {
                    root.addAttribute("ref", ref);
                }
            } else {
                list = ConfigService.getConfig();
            }
            BaseDocumentUtil.removeDeletedDocuments(list);
            if (list.size() > 0) {
                for (ConfigEntry entry : list) {
                    if (!entry.isVisible()) continue;
                    Element el = entry.getXml();
                    if (section != null && !"".equals(section) && ref != null && !"".equals(ref)) {
                        el.addElement("ref").setText(ref);
                    }
                    el.addElement("shortvalue").setText(StringUtil.shortenText(entry.getValue(), 45));
                    root.add(el);
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
        try {
            for (ConfigEntry entry : ConfigService.getConfig()) {
                if (!entry.getId().equals(documentId)) continue;
                SelfServiceEngine.removeFromCache(entry.getKey());
                ConfigService.deleteConfig(documentId);
                break;
            }
        }
        catch (ConfigException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
    }
}

