/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.exceptions.ConfigException;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.LocaleUtil;

public class WebConfig
extends WebForm {
    public WebConfig() {
        this.add(new Field("key"));
        this.add(new Field("value"));
        this.add(new Field("section"));
        this.add(new Field("ref"));
    }

    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        String section = context.getRequest().getParameter("section");
        String ref = context.getRequest().getParameter("ref");
        if (section != null && !"".equals(section)) {
            context.getRootElement().addAttribute("section", section);
        }
        if (ref != null && !"".equals(ref)) {
            context.getRootElement().addAttribute("ref", ref);
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            ConfigEntry entry;
            if ((data.isOpen() || data.isEdit()) && (entry = ConfigService.getConfigByKey(data.getID())) != null) {
                data.put("key", entry.getKey());
                data.put("value", entry.getValue());
                data.put("section", entry.getSection());
                String ref = context.getRequest().getParameter("ref");
                if (ref != null && !"".equals(ref)) {
                    data.put("ref", ref);
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            String ref;
            ConfigEntry entry = null;
            if (data.isCreate()) {
                entry = new ConfigEntry();
            } else if (data.isEdit()) {
                entry = ConfigService.getConfigByKey(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && entry != null) {
                String key = data.getString("key").replace(" ", ".");
                String value = data.getString("value");
                if (data.isCreate()) {
                    entry.setKey(key);
                }
                entry.setValue(value);
                entry.setSection(data.getString("section"));
                if (data.isCreate()) {
                    ConfigService.createConfig(entry);
                } else if (data.isEdit()) {
                    ConfigService.updateConfig(entry);
                }
                SelfServiceEngine.addToCache(key, value);
            }
            if ((ref = data.getString("ref")) != null && !"".equals(ref)) {
                context.setRedirectPage(ref);
            } else {
                context.setRedirectPage("ss:configlist");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (ConfigException ex) {
            data.setError(ex.getMessage());
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        String[] fields;
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        for (String field : fields = new String[]{"key", "value"}) {
            if (!data.getString(field).equals("")) continue;
            String rbKey = "config." + field;
            data.setError(rb.getString(rbKey));
            return false;
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
    }
}

