/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;

public class WebCompanyList
extends WebBaseList {
    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        try {
            List<Organization> organizationList = ConfigService.getOrganizations();
            BaseDocumentUtil.removeDeletedDocuments(organizationList);
            for (Organization o : organizationList) {
                this.getStaticElement().add(o.getXml());
            }
            if (!this.isFilter()) {
                List<Company> list = UserService.getCompanies();
                this.showList(list);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
        try {
            UserService.deleteCompany(documentId);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
        try {
            List<Company> list = UserService.getCompaniesByOrganization(key);
            this.showList(list);
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

