/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.ArrayList;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.ModuleHelper;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebCaseTemplate
extends WebForm {
    public WebCaseTemplate() {
        this.add(new Field("title", true));
        this.add(new Field("description"));
        this.add(new Field("category"));
        this.add(new Field("timelimit", 1));
        this.add(new Field("is-system", 2));
        this.add(new Field("is-visible", 2));
        this.add(new Field("is-indefaultview", 2));
        this.add(new Field("customclass", 0));
        this.add(new Field("is-secondary-enabled", 2));
        this.add(new Field("secondary-handling", 1));
        this.add(new Field("secondary-payload", 0));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            CaseTemplate template = null;
            if (data.isCreate()) {
                template = new CaseTemplate();
            } else if (data.isEdit()) {
                template = CaseService.getCaseTemplate(data.getID());
            }
            if ((data.isCreate() || data.isEdit()) && template != null) {
                template.setSubject(data.getString("title"));
                template.setDescription(data.getString("description"));
                template.setTimeLimitInDays(data.getInt("timelimit"));
                template.setVisibleInDefaultView(data.getBoolean("is-indefaultview"));
                template.setSystemTemplate(false);
                template.setVisible(true);
                template.setCustomClass(data.getString("customclass"));
                String category = data.getString("category");
                if ("".equals(category)) {
                    template.setCategoryId(null);
                } else {
                    template.setCategoryId(category);
                }
                template.setSecondaryEnabled(data.getBoolean("is-secondary-enabled"));
                template.setSecondaryHandling(FormTemplate.SecondaryCaseHandling.of(data.getInt("secondary-handling")));
                template.getSecondaryReferences().clear();
                template.getSecondaryReferences().addAll(this.getSecondaryApplications(data));
                if (data.isCreate()) {
                    CaseService.createCaseTemplate(template);
                } else if (data.isEdit()) {
                    CaseService.updateCaseTemplate(template);
                }
            }
            context.setRedirectPage("ss:casetemplatelist");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (CaseException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            if (data.isOpen() || data.isEdit()) {
                CaseTemplate template = CaseService.getCaseTemplate(data.getID());
                if (template != null) {
                    data.put("title", template.getSubject());
                    data.put("description", template.getDescription());
                    data.put("category", template.getCategoryId());
                    data.put("timelimit", template.getTimeLimitInDays());
                    data.put("is-system", (Object)template.isSystemTemplate());
                    data.put("is-visible", (Object)template.isVisible());
                    data.put("is-indefaultview", (Object)template.isVisibleInDefaultView());
                    data.put("customclass", template.getCustomClass());
                    data.put("is-secondary-enabled", (Object)template.isSecondaryEnabled());
                    data.put("secondary-handling", template.getSecondaryHandling().getCode());
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        String[] booleanKeys;
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        for (String key : booleanKeys = new String[]{"is-indefaultview", "is-secondary-enabled"}) {
            data.put(key, (Object)data.getBoolean(key));
        }
        if (data.getString("title").equals("")) {
            data.setError(rb.getString("casetemplate.title"));
            return false;
        }
        try {
            int timelimit = data.getInt("timelimit");
            if (timelimit < 0) {
                data.setError(rb.getString("casetemplate.invalidtime"));
                return false;
            }
        }
        catch (Exception ex) {
            data.setError(rb.getString("casetemplate.timelimit"));
            return false;
        }
        if (data.getBoolean("is-secondary-enabled")) {
            if (!ModuleHelper.isValidLicense("Secondary Applications Module")) {
                data.setError("You cannot use the secondary forms functionality.  No license for that module was found or the license is no longer valid!");
                return false;
            }
            java.util.List<SecondaryForm> secList = this.getSecondaryApplications(data);
            if (secList.isEmpty()) {
                data.setError("You must select at least 1 secondary application, when the secondary option is enabled.");
                return false;
            }
        }
        return true;
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        try {
            CaseTemplate ct;
            List categoryList = ConfigService.getList("01DCA04CC85B6E8E0000012E0FCA5C5A");
            if (categoryList != null) {
                for (ListItem item : categoryList.getListItems()) {
                    Element cel = el.addElement("category");
                    cel.addAttribute("id", item.getId());
                    cel.setText(item.getSubject());
                }
            }
            java.util.List<FormTemplate> formTemplates = FormService.getFormTemplates();
            BaseDocumentUtil.removeDeletedDocuments(formTemplates);
            if (formTemplates.size() > 1) {
                Element elSec = el.addElement("secondaries");
                for (FormTemplate ft : formTemplates) {
                    Element els = elSec.addElement("form");
                    els.addAttribute("id", ft.getId());
                    els.setText(ft.getSubject());
                }
            }
            List caseStatusList = ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
            for (ListItem item : caseStatusList.getListItems()) {
                if (item.isDeleted()) continue;
                el.add(item.getXml());
            }
            if (data.isEdit() && (ct = CaseService.getCaseTemplate(data.getID())) != null) {
                java.util.List<SecondaryForm> secondaryReferences = ct.getSecondaryReferences();
                for (SecondaryForm sf : secondaryReferences) {
                    ListItem listItem;
                    BaseDocument bd = BaseDocumentUtil.getDocumentFromList(sf.getTemplateId(), formTemplates);
                    if (bd != null) {
                        sf.setStatusName(((FormTemplate)bd).getSubject());
                    }
                    if ((listItem = caseStatusList.getListItem(sf.getStatusId())) != null) {
                        sf.setStatusName(listItem.getSubject());
                    }
                    el.add(sf.getXml());
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private java.util.List<SecondaryForm> getSecondaryApplications(Form data) {
        ArrayList<SecondaryForm> list = new ArrayList<SecondaryForm>();
        if (data.getBoolean("is-secondary-enabled") == Boolean.TRUE.booleanValue() && data.contains("secondary-payload")) {
            String secondaryRefJson = data.getString("secondary-payload");
            JSONArray arr = new JSONArray(secondaryRefJson);
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject jo = arr.getJSONObject(i);
                list.add(new SecondaryForm(jo.getString("id"), jo.getString("sid"), jo.getInt("limit")));
            }
        }
        return list;
    }
}

