/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.util.HashMap;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class WebCaseNamer
extends WebForm {
    private static final String CaseNamePlaceHolder = "ComputedCaseNameHookin";
    private static final String UseCaseNamePrefix = "ComputedCaseNamePrefix";

    public WebCaseNamer() {
        this.add(new Field("template-id"));
        this.add(new Field("field-id"));
        this.add(new Field("is-goproform", 2));
        this.add(new Field("is-prefix", 2));
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            String templateId = data.getString("template-id");
            FormTemplate ft = FormService.getFormTemplate(templateId, true);
            if (ft == null) {
                throw new BirdException("The parent form template was not found!");
            }
            MetaData meta = ft.getMetaDataByKey(CaseNamePlaceHolder);
            MetaData metaPrefix = ft.getMetaDataByKey(UseCaseNamePrefix);
            String selectedField = data.getString("field-id");
            if (meta != null) {
                if (StringUtil.isValid(selectedField)) {
                    meta.setValue(selectedField);
                } else {
                    meta.setDeleted(true);
                }
                ConfigService.updateMetaData(meta);
            } else if (StringUtil.isValid(selectedField)) {
                meta = new MetaData();
                meta.setKey(CaseNamePlaceHolder);
                meta.setReferenceId(ft.getId());
                meta.setValue(selectedField);
                ConfigService.createMetaData(meta);
            }
            if (metaPrefix != null) {
                metaPrefix.setValue(String.valueOf(data.getBoolean("is-prefix")));
                ConfigService.updateMetaData(metaPrefix);
            } else {
                metaPrefix = new MetaData();
                metaPrefix.setKey(UseCaseNamePrefix);
                metaPrefix.setReferenceId(ft.getId());
                metaPrefix.setValue(String.valueOf(data.getBoolean("is-prefix")));
                ConfigService.createMetaData(metaPrefix);
            }
            context.setRedirectPage("ss:formtemplate", "edit&id=" + ft.getId() + "#casenamer");
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        data.put("is-prefix", (Object)data.getBoolean("is-prefix"));
        return true;
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            String templateId;
            if (data.isCreate() && (templateId = context.getRequest().getParameter("template_id")) != null) {
                FormTemplate ft = FormService.getFormTemplate(templateId, false);
                if (ft != null) {
                    MetaData prefixMeta;
                    data.put("template-id", ft.getId());
                    data.put("is-goproform", (Object)(ft instanceof GoProFormTemplate));
                    MetaData meta = ft.getMetaDataByKey(CaseNamePlaceHolder);
                    if (meta != null && meta.getValue() != null) {
                        data.put("field-id", meta.getValue());
                    }
                    if ((prefixMeta = ft.getMetaDataByKey(UseCaseNamePrefix)) != null && "true".equals(prefixMeta.getValue())) {
                        data.put("is-prefix", (Object)true);
                    } else {
                        data.put("is-prefix", (Object)false);
                    }
                } else {
                    throw new BirdException("Invalid template Id");
                }
            }
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        try {
            String templateId = null;
            if (data.isCreate()) {
                templateId = context.getRequest().getParameter("template_id");
            } else if (data.isEdit() || data.isOpen()) {
                templateId = context.getRequest().getParameter("tid");
            }
            if (templateId != null) {
                FormTemplate ft = FormService.getFormTemplate(templateId, true);
                data.put("template-id", ft.getId());
                data.put("is-goproform", (Object)(ft instanceof GoProFormTemplate));
                if (ft instanceof GoProFormTemplate) {
                    Element elTree = this.generateApplicationTree(ft);
                    el.add(elTree);
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (FormException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    private Element generateApplicationTree(FormTemplate template) throws FormException {
        Element el;
        block4: {
            Document doc;
            block5: {
                doc = FormsUtil.getApplicationForm(template);
                el = DocumentHelper.createElement((String)"tree");
                if (doc == null) break block4;
                double schemaVersion = template.getSchemaVersion();
                if (!(schemaVersion >= 2.0) || !(schemaVersion < 3.0)) break block5;
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
                String xpathQuery = "//gpf:section/gpf:label";
                String xpathFields = "gpf:input|gpf:group/gpf:input|gpf:range|gpf:selection|gpf:lookup";
                XPath xpath = doc.createXPath("//gpf:section/gpf:label");
                xpath.setNamespaceURIs(uris);
                List list = xpath.selectNodes((Object)doc);
                for (Node node : list) {
                    String sectionLabel = node.getText();
                    Element section = el.addElement("section");
                    section.addAttribute("label", sectionLabel);
                    xpath = node.getParent().createXPath("gpf:input|gpf:group/gpf:input|gpf:range|gpf:selection|gpf:lookup");
                    xpath.setNamespaceURIs(uris);
                    List fieldNodes = xpath.selectNodes((Object)node.getParent());
                    for (Node fieldNode : fieldNodes) {
                        xpath = fieldNode.createXPath("gpf:label");
                        xpath.setNamespaceURIs(uris);
                        Node fieldLabelNode = xpath.selectSingleNode((Object)fieldNode);
                        if (fieldLabelNode == null) continue;
                        Element field = section.addElement("field");
                        field.setText(fieldLabelNode.getText());
                        field.addAttribute("id", fieldNode.valueOf("@id"));
                        field.addAttribute("name", fieldNode.valueOf("@id"));
                        field.addAttribute("is-valid", String.valueOf(fieldNode.valueOf("@type").equalsIgnoreCase("text")));
                    }
                }
                break block4;
            }
            String xpath = "//sections/section/sectionlabel";
            String xpathFields = "fields/field";
            List nodeList = doc.selectNodes("//sections/section/sectionlabel".toUpperCase());
            if (nodeList == null || nodeList.size() <= 0) break block4;
            for (Node node : nodeList) {
                String sectionLabel = node.getText();
                Element section = el.addElement("section");
                section.addAttribute("label", sectionLabel);
                List fieldNodes = node.getParent().selectNodes("fields/field".toUpperCase());
                for (Node fieldNode : fieldNodes) {
                    Node fieldLabelNode = fieldNode.selectSingleNode("FIELDLABEL");
                    if (fieldLabelNode == null) continue;
                    Element field = section.addElement("field");
                    field.setText(fieldLabelNode.getText());
                    field.addAttribute("id", fieldNode.valueOf("@ID"));
                    field.addAttribute("name", fieldNode.valueOf("@NAME"));
                    field.addAttribute("is-valid", String.valueOf(fieldNode.valueOf("@TYPE").equals("TEXT")));
                }
            }
        }
        return el;
    }
}

