/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.UID;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.ICaptchaProvider;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.IBankMessageProvider;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.RecoveryTicket;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.SecurityService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.CollaborationHelper;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.util.WebSecurityUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class WebXml
extends WebElementBase {
    private static Logger logger = Logger.getLogger(WebXml.class);
    private static final String ENCODING_CHARSET = SelfServiceEngine.getEncoding();
    private String focusField;

    public void doPost(WebContext context) throws BirdException {
        String json;
        Document doc;
        HttpServletResponse res;
        block51: {
            JSONObject jo;
            String postaction = context.getRequest().getParameter("action");
            res = context.getResponseExclusive();
            OutputFormat format = OutputFormat.createCompactFormat();
            format.setEncoding(ENCODING_CHARSET);
            format.setSuppressDeclaration(false);
            format.setOmitEncoding(false);
            if ("true".equalsIgnoreCase(SelfServiceEngine.getConfig("web.security.csfr"))) {
                WebSecurityUtil.validateOrigin(context.getRequest());
            }
            doc = new DocumentFactory().createDocument();
            Element root = doc.addElement("data");
            if (postaction != null && "register".equals(postaction)) {
                try {
                    String formJSON = context.getRequest().getParameter("data");
                    jo = new JSONObject(formJSON);
                    ICaptchaProvider captcha = this.getCaptchaProvider();
                    if (captcha != null) {
                        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getRequest());
                        captcha.setContext(context);
                        if (jo.has("captcha-response") && jo.has("captcha-challenge")) {
                            if (!captcha.verify(jo.getString("captcha-response"), jo.getString("captcha-challenge"))) {
                                this.focusField = "captcha-response";
                                throw new SelfServiceException(rb.getString("register.captcha"));
                            }
                        } else {
                            this.focusField = "captcha-response";
                            throw new SelfServiceException(rb.getString("register.captcha"));
                        }
                    }
                    this.registerUser(context.getRequest(), jo);
                    boolean isEmailActivation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.emailactivation"));
                    boolean isAdminActivation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.administrator.confirmation"));
                    boolean isBankActivation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.sendpasswordtobank"));
                    if (isAdminActivation) {
                        root.addElement("redirect").setText("registration-confirmation.html");
                        break block51;
                    }
                    if (isEmailActivation) {
                        root.addElement("redirect").setText("registration-activate.html");
                        break block51;
                    }
                    if (isBankActivation) {
                        root.addElement("redirect").setText("registration-bank.html");
                        break block51;
                    }
                    root.addElement("redirect").setText("registration-success.html");
                }
                catch (JSONException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
                catch (MissingResourceException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
                catch (SelfServiceException ex) {
                    root.addElement("error").setText(ex.getMessage());
                    Dom4JUtil.addCDATAElement(root, "focus", this.focusField);
                }
                catch (UserException ex) {
                    root.addElement("error").setText(ex.getMessage());
                    if (ex.getFieldName() != null) {
                        this.focusField = ex.getFieldName();
                    }
                    Dom4JUtil.addCDATAElement(root, "focus", this.focusField);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    root.addElement("error").setText(ex.getMessage() != null ? ex.getMessage() : "Exception occurred.");
                }
            } else if (postaction != null && "recovery".equals(postaction)) {
                try {
                    String recoveryJSON = context.getRequest().getParameter("data");
                    jo = new JSONObject(recoveryJSON);
                    String email = jo.getString("email");
                    ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", context.getRequest());
                    User user = UserService.getUserByEmail(email);
                    if (user != null) {
                        if (user.isDeleted()) {
                            throw new SelfServiceException(rb.getString("recovery.error.deleted"));
                        }
                        if (!user.isVerified()) {
                            throw new SelfServiceException(rb.getString("recovery.error.verified"));
                        }
                    } else {
                        throw new SelfServiceException(rb.getString("recovery.error.email"));
                    }
                    String ip = context.getRequest().getRemoteAddr();
                    String subject = Translator.translate((BaseDocument)user, rb.getString("recovery.request.subject"));
                    String message = Translator.translate((BaseDocument)user, rb.getString("recovery.request.body"));
                    RecoveryTicket ticket = new RecoveryTicket(user.getId(), ip);
                    SecurityService.createRecoveryTicket(ticket);
                    String recoveryLink = SelfServiceEngine.getConfig("web.domain");
                    recoveryLink = recoveryLink + "/web/recover.html?id=" + ticket.getId();
                    message = message.replace("[recover.link]", recoveryLink);
                    message = message.replace("[recover.ip]", ip);
                    Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.EMAIL, true);
                    root.addElement("status").setText("success");
                    root.addElement("message").setText(rb.getString("recovery.sent"));
                }
                catch (JSONException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
                catch (MissingResourceException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
                catch (SelfServiceException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
                catch (CommunicationException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
                catch (MessageException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
            } else if (postaction != null && "companysearch".equals(postaction)) {
                try {
                    String searchKey = context.getRequest().getParameter("query");
                    if (searchKey != null && !"".equals(searchKey)) {
                        this.searchCompanies(searchKey, root);
                    }
                }
                catch (SelfServiceException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
            } else if (postaction != null && "lang".equals(postaction)) {
                try {
                    json = context.getRequest().getParameter("data");
                    jo = new JSONObject(json);
                    if (jo.has("locale")) {
                        String locale = jo.getString("locale");
                        this.setLanguage(context, locale);
                    }
                }
                catch (JSONException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
            } else if (postaction != null) {
                try {
                    String JSON = context.getRequest().getParameter("data");
                    jo = new JSONObject(JSON);
                    if (jo.has("_class")) {
                        String className = jo.getString("_class");
                        try {
                            IWebFormQuery handler = (IWebFormQuery)Class.forName(className).newInstance();
                            handler.setContext(context);
                            handler.doAction(root, postaction, jo);
                        }
                        catch (FormQueryException ex) {
                            root.addElement("error").setText("Handler exception: " + ex.getMessage());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            root.addElement("error").setText("Class loader exception: " + className + ". \nMessage: " + ex.getMessage());
                        }
                        break block51;
                    }
                    root.addElement("error").setText("Invalid request.");
                }
                catch (JSONException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    root.addElement("error").setText(ex.getMessage());
                }
            } else {
                root.addElement("error").setText("Invalid request.");
            }
        }
        try {
            json = XML.toJSONObject((String)doc.asXML());
            res.setContentType("application/json; charset=" + ENCODING_CHARSET + "");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            out.write(json.toString().getBytes(ENCODING_CHARSET));
            out.close();
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (JSONException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
    }

    private void searchCompanies(String keyword, Element el) throws SelfServiceException {
        List<Company> list = UserService.searchCompanies(keyword);
        el.addElement("query").setText(keyword);
        if (list != null && list.size() > 0) {
            for (Company com : list) {
                el.addElement("suggestions").setText(com.getName());
                el.addElement("data").add(com.getXml());
            }
        }
    }

    private void registerUser(HttpServletRequest request, JSONObject json) throws UserException, SelfServiceException, JSONException, CommunicationException, MessageException {
        this.focusField = null;
        boolean isContact = false;
        if (json.has("userrole")) {
            isContact = "company".equals(json.getString("userrole"));
        }
        boolean isNewCompany = true;
        Company com = null;
        User user = new User();
        if (isContact) {
            Company existingCompany;
            String companyName = json.getString("companyname");
            String companyId = json.getString("company-id");
            if (companyId != null && !"".equals(companyId) && (existingCompany = UserService.getCompany(companyId)) != null && existingCompany.getName().equals(companyName)) {
                com = existingCompany;
                isNewCompany = false;
            }
            if (isNewCompany && (existingCompany = UserService.getCompanyByName(companyName)) != null) {
                com = existingCompany;
                isNewCompany = false;
            }
            if (isNewCompany) {
                com = new Company();
                com.setName(companyName);
                Address ca = new Address();
                ca.setStreetName(json.getString("companyaddress"));
                ca.setCountry(json.getString("companycountry"));
                ca.setCity(json.getString("companycity"));
                ca.setPostcode(json.getString("companypostcode"));
                com.setAddress(ca);
            }
        }
        user.setUsername(json.getString("username"));
        user.setFullname(json.getString("fullname"));
        user.setEmail(json.getString("email"));
        user.setCommunication(User.Communications.EMAIL);
        boolean isBankActivation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.sendpasswordtobank"));
        boolean isContactConfirmation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.contact.confirmation"));
        String generatedPass = RandomStringUtils.randomAlphanumeric((int)8).toUpperCase();
        if (!isBankActivation) {
            user.setPassword(json.getString("password"));
        } else {
            user.setPassword(generatedPass);
        }
        Address ua = new Address();
        ua.setStreetName(json.getString("address"));
        ua.setCountry(json.getString("usercountry"));
        ua.setCity(json.getString("usercity"));
        ua.setPostcode(json.getString("userpostcode"));
        user.setAddress(ua);
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", request);
        if (!isBankActivation && !user.getPassword().equals(json.getString("password2"))) {
            this.setFocus("password");
            throw new SelfServiceException(rb.getString("register.nomatch"));
        }
        if (!user.getEmail().equalsIgnoreCase(json.getString("email2"))) {
            this.setFocus("email");
            throw new SelfServiceException(rb.getString("register.emailmismatch"));
        }
        String[] names = JSONObject.getNames((JSONObject)json);
        if (null != names) {
            for (int i = 0; i < names.length; ++i) {
                String value;
                Cookie[] name = names[i];
                if (null == name || !name.startsWith("meta-") || null == (value = json.getString((String)name)) || "".equals(value)) continue;
                MetaData m = new MetaData();
                m.setKey(name.substring("meta-".length()));
                m.setValue(json.getString((String)name));
                user.getMetadata().add(m);
            }
        }
        String locale = SelfServiceEngine.getConfig("web.locale.language").replace(",", "_");
        if (request.getCookies() != null && "true".equalsIgnoreCase(SelfServiceEngine.getConfig("web.locale.user.option"))) {
            for (Cookie cookie : request.getCookies()) {
                if (!"locale".equals(cookie.getName()) || !LocaleUtil.isAvailableLocale(cookie.getValue())) continue;
                locale = cookie.getValue();
                break;
            }
        }
        user.setLocale(locale);
        this.validateUser(user);
        boolean sendContactNotifications = false;
        List<Object> companyContacts = new ArrayList();
        if (isContact) {
            Contact contact = new Contact();
            if (isNewCompany) {
                this.validateCompany(com);
                UserService.createCompany(com);
                contact.setConfirmed(true);
                contact.setManager(true);
            } else if (isContactConfirmation) {
                companyContacts = UserService.getContacts(com.getId());
                if (companyContacts.size() == 0) {
                    contact.setConfirmed(true);
                    contact.setManager(true);
                } else {
                    contact.setConfirmed(false);
                    sendContactNotifications = true;
                }
            } else {
                contact.setConfirmed(true);
            }
            contact.setCompanyId(com.getId());
            user.getContactList().add(contact);
        }
        user.getUserRoles().add(UserService.getUserRole("D82C9C303767DFE8AA6BF50DCF119748"));
        boolean isEmailActivation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.emailactivation"));
        boolean isAdminActivation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.administrator.confirmation"));
        if (isEmailActivation) {
            user.setVerified(false);
        } else {
            user.setVerified(true);
        }
        if (isAdminActivation) {
            user.setVerified(false);
        }
        if (user.getUsername().length() == 10 && NumberUtils.isDigits((String)user.getUsername())) {
            user.setIdNumber(user.getUsername());
        }
        UserService.createUser(user);
        try {
            CollaborationHelper.checkInvitations(user);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        if (isEmailActivation) {
            this.sendActivationEmail(user);
        } else if (isBankActivation) {
            user.setPassword(generatedPass);
            this.sendBankActivationEmail(user);
            IBankMessageProvider provider = this.getBankMessageProvider();
            provider.sendRegistrationMessage(user);
        } else {
            try {
                this.sendRegistrationEmail(user, json.getString("password"));
                if (sendContactNotifications) {
                    this.sendContactRequestEmails(user, com, companyContacts);
                }
            }
            catch (CommunicationException ex) {
                SelfServiceEngine.getLogger().error("Error sending registration email: ", (Exception)ex);
            }
            catch (MessageException ex) {
                SelfServiceEngine.getLogger().error("Error sending registration email: ", (Exception)ex);
            }
        }
    }

    private final void validateCompany(Company com) throws SelfServiceException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception");
        this.throwIfNotValid(com.getName(), rb.getString("com.name"), "companyname");
        this.validateAddress(com.getAddress(), rb, false);
    }

    private final void validateUser(User user) throws SelfServiceException {
        User existingUser;
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", user.getLocale());
        this.throwIfNotValid(user.getUsername(), rb.getString("register.username"), "username");
        this.throwIfNotValid(user.getFullname(), rb.getString("register.fullname"), "fullname");
        this.throwIfNotValid(user.getEmail(), rb.getString("register.email"), "email");
        if (!StringUtil.isValidEmail(user.getEmail())) {
            this.setFocus("email");
            throw new SelfServiceException(rb.getString("register.email"));
        }
        if (user.getPassword() == null || user.getPassword().length() < 4) {
            this.setFocus("password");
            throw new SelfServiceException(rb.getString("register.passweak"));
        }
        boolean isAddressRequired = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.require.address"));
        if (isAddressRequired) {
            this.validateAddress(user.getAddress(), rb, true);
        }
        if ((existingUser = UserService.getUserByUsername(user.getUsername())) != null) {
            this.setFocus("username");
            throw new SelfServiceException(rb.getString("register.exists"));
        }
        existingUser = UserService.getUserByEmail(user.getEmail());
        if (existingUser != null) {
            this.setFocus("email");
            throw new SelfServiceException(rb.getString("register.emailexist"));
        }
    }

    private final void validateAddress(Address addr, ResourceBundle rb, boolean isUser) throws SelfServiceException {
        if (addr == null) {
            this.setFocus(isUser ? "address" : "companyaddress");
            throw new SelfServiceException(rb.getString("register.streetname"));
        }
        this.throwIfNotValid(addr.getCity(), rb.getString("register.city"), isUser ? "usercity" : "companycity");
        this.throwIfNotValid(addr.getCountry(), rb.getString("register.country"), isUser ? "usercountry" : "companycountry");
        this.throwIfNotValid(addr.getPostcode(), rb.getString("register.postcode"), isUser ? "userpostcode" : "companypostcode");
        this.throwIfNotValid(addr.getStreetName(), rb.getString("register.streetname"), isUser ? "address" : "companyaddress");
    }

    private final void throwIfNotValid(String s, String exceptionMessage, String focus) throws SelfServiceException {
        if (!StringUtil.isValid(s)) {
            this.setFocus(focus);
            throw new SelfServiceException(exceptionMessage);
        }
    }

    private final void sendActivationEmail(User user) throws CommunicationException, MessageException, SelfServiceException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", user.getLocale());
        String subject = Translator.translate((BaseDocument)user, rb.getString("activation.subject"));
        String message = rb.getString("activation.body") + rb.getString("mail.footer");
        message = Translator.translate((BaseDocument)user, message);
        String activationLink = SelfServiceEngine.getConfig("web.domain");
        activationLink = activationLink + "/web/activation.html?id=" + user.getId() + "&ai=" + UID.getUID().substring(0, 8);
        message = message.replace("[activation.link]", activationLink);
        Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.EMAIL, false);
    }

    private final void sendBankActivationEmail(User user) throws CommunicationException, MessageException, SelfServiceException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", user.getLocale());
        String subject = Translator.translate((BaseDocument)user, rb.getString("bankregister.subject"));
        String message = rb.getString("bankregister.body") + rb.getString("mail.footer");
        message = Translator.translate((BaseDocument)user, message);
        Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.EMAIL, false);
    }

    private final void sendContactRequestEmails(User user, Company com, List<User> contactList) throws CommunicationException, MessageException, SelfServiceException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", user.getLocale());
        List<BaseDocument> transObjects = Arrays.asList(user, com);
        String subject = Translator.translate(transObjects, rb.getString("contact.pending.subject"));
        String message = Translator.translate(transObjects, rb.getString("contact.pending.body"));
        Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.NONE, true);
        subject = Translator.translate(transObjects, rb.getString("contact.request.subject"));
        message = Translator.translate(transObjects, rb.getString("contact.request.body"));
        for (User contactUser : contactList) {
            Contact contact = contactUser.getContactByCompanyId(com.getId());
            if (contact == null || !contact.isManager() || contact.isDeleted()) continue;
            Messenger.sendMessage(contactUser, new SimpleMessage(subject, message), User.Communications.EMAIL, true);
            if (contact.getEmail() == null) continue;
            Messenger.sendEmailMessage(contact.getEmail(), subject, message, true);
        }
    }

    private final void sendRegistrationEmail(User user, String password) throws CommunicationException, MessageException, SelfServiceException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", user.getLocale());
        String subject = Translator.translate((BaseDocument)user, rb.getString("register.subject"));
        String message = rb.getString("register.body") + rb.getString("mail.footer");
        message = Translator.translate((BaseDocument)user, message);
        message = message.replace("[user.password]", password);
        Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.EMAIL, false);
    }

    private final void setFocus(String focus) {
        this.focusField = focus;
    }

    private IBankMessageProvider getBankMessageProvider() throws SelfServiceException {
        IBankMessageProvider provider = EngineFactory.getCustomEngine(IBankMessageProvider.class);
        if (provider != null) {
            Set<ConfigEntry> config = ConfigService.getConfig("bank");
            BaseDocumentUtil.removeDeletedDocuments(config);
            Properties prop = new Properties();
            for (ConfigEntry entry : config) {
                prop.put(entry.getKey(), entry.getValue());
            }
            provider.setProperties(prop);
        }
        return provider;
    }

    private final ICaptchaProvider getCaptchaProvider() throws SelfServiceException {
        String className = SelfServiceEngine.getConfig(ICaptchaProvider.class.getName());
        if (StringUtil.isValid(className)) {
            return EngineFactory.getCustomEngine(ICaptchaProvider.class);
        }
        return null;
    }

    private boolean setLanguage(WebContext context, String languageParam) {
        String requestedLanguage;
        if (StringUtil.isValid(languageParam) && LocaleUtil.isAvailableLocale(requestedLanguage = languageParam.trim())) {
            Cookie cookie = new Cookie("locale", requestedLanguage);
            cookie.setPath(context.getRequest().getServletContext().getContextPath());
            cookie.setMaxAge(Integer.MAX_VALUE);
            context.getResponse().addCookie(cookie);
            return true;
        }
        return false;
    }
}

