/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.exceptions.FormQueryException;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class WebFormXml
extends WebElementBase {
    private static final String ENCODING_CHARSET = SelfServiceEngine.getEncoding();

    public void doPost(WebContext context) throws BirdException {
        String postaction = context.getRequest().getParameter("action");
        HttpServletResponse res = context.getResponseExclusive();
        OutputFormat format = OutputFormat.createCompactFormat();
        format.setEncoding(ENCODING_CHARSET);
        format.setSuppressDeclaration(false);
        format.setOmitEncoding(false);
        Document doc = new DocumentFactory().createDocument();
        Element root = doc.addElement("data");
        if (postaction != null) {
            try {
                String guidanceJSON = context.getRequest().getParameter("data");
                JSONObject jo = new JSONObject(guidanceJSON);
                String className = jo.getString("_class");
                if (className == null || "".equals(className)) {
                    throw new IllegalArgumentException("No Target class defined.");
                }
                try {
                    IWebFormQuery handler = (IWebFormQuery)Class.forName(className).newInstance();
                    handler.setContext(context);
                    handler.doAction(root, postaction, jo);
                }
                catch (FormQueryException ex) {
                    root.addElement("error").setText("Handler exception: " + ex.getMessage());
                }
                catch (Exception ex) {
                    root.addElement("error").setText("Class loader exception: " + className + ". \nMessage: " + ex.getMessage());
                }
            }
            catch (JSONException ex) {
                root.addElement("error").setText(ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                root.addElement("error").setText(ex.getMessage());
            }
        } else {
            root.addElement("error").setText("Invalid request.");
        }
        try {
            JSONObject json = XML.toJSONObject((String)doc.asXML());
            res.setContentType("application/json; charset=" + ENCODING_CHARSET + "");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            out.write(json.toString().getBytes(ENCODING_CHARSET));
            out.close();
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (JSONException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
    }
}

