/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import com.PureEdge.IFSSingleton;
import com.PureEdge.error.UWIException;
import com.PureEdge.xfdl.FormNodeP;
import com.PureEdge.xfdl.XFDL;
import com.ibm.form.webform.framework.TemplateManager;
import com.ibm.form.webform.framework.TemplateManagerException;
import is.hugvit.log.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.MessageHelper;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.LotusFormTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.FormDeadlineException;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.servlets.LotusFormServlet;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LotusFormManager {
    private static Log logger;
    private static String LotusFormServerUrl;

    public static final void setLogger(Log log) {
        logger = log;
    }

    public static final void setLotusFormServerUrl(String url) {
        LotusFormServerUrl = url;
    }

    public static final void renderFormTemplate(String formTemplateId, LotusFormServlet servlet, HttpServletRequest req, HttpServletResponse res) throws SelfServiceException {
        try {
            FormTemplate template = FormService.getFormTemplate(formTemplateId, true);
            FormTemplateFile templateFile = null;
            if (template == null || !(template instanceof LotusFormTemplate) || template.isDeleted()) {
                throw new SelfServiceException("Invalid form template was specified");
            }
            templateFile = template.getFormTemplateFile(FormTemplateFile.Tag.DATA);
            if (templateFile == null) {
                throw new SelfServiceException("The Form template does not contain any XFDL data file.");
            }
            LotusFormManager.addTemplateToManager((LotusFormTemplate)template, servlet.getTemplateManager());
            servlet.setTemplateId(res, template.getId());
            String fileName = templateFile.getFilename();
            res.setContentType("application/vnd.xfdl");
            servlet.setFilename(res, fileName);
            servlet.setFormName(res, template.getSubject());
            if (fileName == null) {
                fileName = servlet.getFilename(req);
            }
            if (fileName == null) {
                fileName = "form.xfdl";
            }
            ServletOutputStream responseOS = res.getOutputStream();
            byte[] stream = templateFile.getStream();
            int requiredCount = template.getExtendedData().getRequiredAttachmentCount();
            if (requiredCount > 0) {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(stream);
                    FormNodeP theForm = null;
                    XFDL theXFDL = IFSSingleton.getXFDL();
                    theForm = theXFDL.readForm((InputStream)bis, 142777352);
                    Element elRequired = DocumentHelper.createElement((String)"required");
                    elRequired.setText(String.valueOf(requiredCount));
                    String errorMessage = "The number of required attachments have not been met.";
                    if (StringUtil.isValid(errorMessage)) {
                        Element elMessage = DocumentHelper.createElement((String)"message");
                        elMessage.setText(errorMessage);
                        theForm.updateXFormsInstance(null, "instance('attachments')/message", null, null, elMessage.asXML().getBytes("UTF-8"), 1);
                    }
                    theForm.updateXFormsInstance(null, "instance('attachments')/required", null, null, elRequired.asXML().getBytes(), 1);
                    theForm.writeForm((OutputStream)responseOS, null, 0);
                }
                catch (UWIException uex) {
                    logger.error("Error setting attachment requirements: " + uex.getMessage());
                }
            } else {
                responseOS.write(stream);
            }
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static final void renderApplication(String applicationId, LotusFormServlet servlet, HttpServletRequest req, HttpServletResponse res) throws SelfServiceException {
        try {
            ApplicationForm form = null;
            FormTemplate parentTemplate = null;
            ExternalDocument doc = CaseService.getExternalDocument(applicationId, true);
            if (doc == null || !(doc instanceof ApplicationForm)) {
                throw new SelfServiceException("Invalid application Id");
            }
            form = (ApplicationForm)doc;
            parentTemplate = FormService.getFormTemplate(form.getFormtemplateId(), false);
            String fileName = form.getFilename();
            res.setContentType("application/vnd.xfdl");
            servlet.setFilename(res, fileName);
            servlet.setFormName(res, form.getSubject());
            ServletOutputStream responseOS = res.getOutputStream();
            byte[] stream = form.getStream();
            int requiredCount = parentTemplate.getExtendedData().getRequiredAttachmentCount();
            if (requiredCount > 0) {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(stream);
                    FormNodeP theForm = null;
                    XFDL theXFDL = IFSSingleton.getXFDL();
                    theForm = theXFDL.readForm((InputStream)bis, 142777352);
                    Element elRequired = DocumentHelper.createElement((String)"required");
                    elRequired.setText(String.valueOf(requiredCount));
                    String errorMessage = "The number of required attachments have not been met.";
                    if (StringUtil.isValid(errorMessage)) {
                        Element elMessage = DocumentHelper.createElement((String)"message");
                        elMessage.setText(errorMessage);
                        theForm.updateXFormsInstance(null, "instance('attachments')/message", null, null, elMessage.asXML().getBytes("UTF-8"), 1);
                    }
                    theForm.updateXFormsInstance(null, "instance('attachments')/required", null, null, elRequired.asXML().getBytes(), 1);
                    theForm.writeForm((OutputStream)responseOS, null, 0);
                }
                catch (UWIException uex) {
                    logger.error("Error setting attachment requirements: " + uex.getMessage());
                }
            } else {
                responseOS.write(stream);
            }
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static void initializeFormTemplates(TemplateManager manager) throws SelfServiceException {
        List<FormTemplate> list = FormService.getFormTemplates();
        for (FormTemplate template : list) {
            FormTemplate fullTemplate;
            if (!(template instanceof LotusFormTemplate) || template.isDeleted() || !template.isVisible() || !LotusFormManager.addTemplateToManager((LotusFormTemplate)(fullTemplate = FormService.getFormTemplate(template.getId(), true)), manager)) continue;
            logger.info("Lotus Form Server: Adding template: " + template.getSubject());
        }
    }

    public static final boolean addTemplateToManager(LotusFormTemplate template, TemplateManager manager) throws SelfServiceException {
        ByteArrayInputStream in = null;
        try {
            String formTemplateId = template.getId();
            if (!manager.isFormTemplateInstalled(formTemplateId)) {
                FormTemplateFile file = template.getFormTemplateFile(FormTemplateFile.Tag.DATA);
                if (file == null) {
                    throw new SelfServiceException("The template: " + template.getSubject() + " contains no XFDL file.");
                }
                byte[] formdata = file.getStream();
                in = new ByteArrayInputStream(formdata);
                manager.addFormTemplate(formTemplateId, (InputStream)in);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (TemplateManagerException tme) {
            throw new SelfServiceException((Exception)((Object)tme));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new SelfServiceException(ex);
                }
            }
        }
    }

    public static final String createApplication(String templateId, String organizationId, boolean isFinalized, HttpServletRequest req) throws SelfServiceException, FormDeadlineException {
        FormNodeP theForm = null;
        try {
            StatusListItem initialStatus;
            XFDL theXFDL = IFSSingleton.getXFDL();
            theForm = theXFDL.readForm((InputStream)req.getInputStream(), 142777352);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            theForm.writeForm((OutputStream)outStream, null, 0);
            Principal principal = req.getUserPrincipal();
            User user = UserService.getUserByUsername(principal.getName());
            FormTemplate ft = FormService.getFormTemplate(templateId, false);
            if (!ft.isWithinDateRestriction()) {
                throw new FormDeadlineException("The submission deadline has expired");
            }
            FormCase fc = new FormCase(ft);
            fc.setOrganizationId(organizationId);
            fc.setSent(isFinalized);
            fc.setCreatedById(user.getId());
            if (ft.getExtendedData() != null && ft.getExtendedData().getCaseStatusList() != null && (initialStatus = ft.getExtendedData().getCaseStatusList().getFirst()) != null) {
                fc.setStatusId(initialStatus.getId());
            }
            ApplicationForm form = new ApplicationForm();
            form.setFormtemplateId(templateId);
            form.setFileName(ft.getSubject(), "xfdl");
            form.setSubject(ft.getSubject());
            form.setStream(outStream.toByteArray());
            form.setFilesize(outStream.toByteArray().length);
            form.setSent(isFinalized);
            fc.addSubDocument(form);
            if (isFinalized) {
                byte[] pdfStream = LotusFormManager.exportLotusForm(theForm, FormExportType.PDF);
                CompletedFormDocument cf = new CompletedFormDocument();
                cf.setFormtemplateId(ft.getId());
                cf.setSubject(ft.getSubject());
                cf.setFileName(ft.getSubject(), "pdf");
                cf.setStream(pdfStream);
                cf.setFilesize(pdfStream.length);
                cf.setMimetype("application/pdf");
                cf.setSent(true);
                fc.addSubDocument(cf);
                fc.setSent(true);
                LotusFormManager.setNextCaseStatus(ft, fc);
                try {
                    Hashtable<String, String> pairs = ft.getFormQueryProcessor().getKeyValuePairs(form);
                    for (String key : pairs.keySet()) {
                        MetaData md = new MetaData(key, pairs.get(key));
                        form.getMetadata().add(md);
                    }
                }
                catch (FormQueryException ex) {
                    SelfServiceEngine.getLogger().error("Error generating Metadata: " + ex);
                }
            }
            CaseService.createCase(fc);
            if (isFinalized) {
                MessageHelper.sendApplicationSendMessage(user, ft, Arrays.asList(fc, form));
            }
            String string = form.getId();
            return string;
        }
        catch (UWIException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (CaseException ex) {
            throw new SelfServiceException(ex);
        }
        finally {
            if (theForm != null) {
                try {
                    theForm.destroy();
                }
                catch (UWIException ex) {
                    throw new SelfServiceException((Exception)((Object)ex));
                }
            }
        }
    }

    public static final void updateApplication(String applicationId, boolean isFinalized, HttpServletRequest req) throws SelfServiceException, FormDeadlineException, SaveConflictException {
        FormNodeP theForm = null;
        try {
            XFDL theXFDL = IFSSingleton.getXFDL();
            theForm = theXFDL.readForm((InputStream)req.getInputStream(), 142777352);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            theForm.writeForm((OutputStream)outStream, null, 0);
            ExternalDocument exDoc = CaseService.getExternalDocument(applicationId, true);
            if (!(exDoc instanceof ApplicationForm)) {
                throw new SelfServiceException("The application Id specified is invalid, cannot continue.");
            }
            BaseCase bc = CaseService.getCase(exDoc.getCaseId());
            ApplicationForm form = (ApplicationForm)exDoc;
            FormTemplate ft = FormService.getFormTemplate(form.getFormtemplateId(), false);
            if (!ft.isWithinDateRestriction()) {
                throw new FormDeadlineException("The submission deadline has expired");
            }
            form.setStream(outStream.toByteArray());
            form.setFilesize(outStream.toByteArray().length);
            form.setSent(isFinalized);
            if (isFinalized) {
                byte[] pdfStream = LotusFormManager.exportLotusForm(theForm, FormExportType.PDF);
                CompletedFormDocument cf = new CompletedFormDocument();
                cf.setFormtemplateId(ft.getId());
                cf.setSubject(ft.getSubject());
                cf.setFileName(ft.getSubject(), "pdf");
                cf.setStream(pdfStream);
                cf.setFilesize(pdfStream.length);
                cf.setMimetype("application/pdf");
                cf.setCaseId(bc.getId());
                cf.setSent(true);
                bc.addSubDocument(cf);
                bc.setSent(true);
                LotusFormManager.setNextCaseStatus(ft, (FormCase)bc);
                try {
                    Hashtable<String, String> pairs = ft.getFormQueryProcessor().getKeyValuePairs(form);
                    for (String key : pairs.keySet()) {
                        MetaData md = new MetaData(key, pairs.get(key));
                        form.getMetadata().add(md);
                    }
                }
                catch (FormQueryException ex) {
                    SelfServiceEngine.getLogger().error("Error generating Metadata: " + ex);
                }
            }
            CaseService.updateSubDocument(form);
            CaseService.updateCase(bc);
            if (isFinalized) {
                User user = UserService.getUserByUsername(req.getUserPrincipal().getName());
                MessageHelper.sendApplicationSendMessage(user, ft, Arrays.asList(bc, form));
            }
        }
        catch (UWIException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (CaseException ex) {
            throw new SelfServiceException(ex);
        }
        finally {
            if (theForm != null) {
                try {
                    theForm.destroy();
                }
                catch (UWIException ex) {
                    throw new SelfServiceException((Exception)((Object)ex));
                }
            }
        }
    }

    public static byte[] exportLotusForm(FormNodeP form, FormExportType type) throws SelfServiceException {
        String printUrl = "";
        try {
            if (form == null) {
                throw new SelfServiceException("XDFL form instance is missing");
            }
            printUrl = LotusFormServerUrl + "/PrintService?returnType=" + type.toString().toLowerCase();
            URL url = new URL(printUrl);
            HttpURLConnection con = null;
            OutputStream os = null;
            con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/vnd.xfdl");
            os = con.getOutputStream();
            try {
                form.writeForm(os, null, 0);
            }
            catch (UWIException uWIException) {
                // empty catch block
            }
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                throw new SelfServiceException("Error retrieving file from Print Server. Response: " + responseCode);
            }
            int BUFFER_SIZE = 0x140000;
            byte[] buffer = new byte[0x140000];
            BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
            ByteBuffer buf = ByteBuffer.allocate(0x140000);
            if (bis.available() != 0) {
                int bytes_read_len;
                while ((bytes_read_len = bis.read(buffer, 0, 0x140000)) != -1) {
                    buf.put(buffer, 0, bytes_read_len);
                }
            }
            bis.close();
            return buf.array();
        }
        catch (MalformedURLException ex) {
            throw new SelfServiceException("The url for the Printserver is invalid: " + printUrl);
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private static void setNextCaseStatus(FormTemplate ft, FormCase fc) throws SelfServiceException {
        LinkedList<StatusListItem> statusList;
        FormTemplateExtras fex = ft.getExtendedData();
        if (fex != null && (statusList = fex.getCaseStatusList()) != null && statusList.size() > 1) {
            StatusListItem nextStatus = statusList.get(1);
            fc.setStatusId(nextStatus.getId());
            fc.setStatusText(nextStatus.getSubject());
        }
    }

    public static enum FormExportType {
        PDF,
        PDFA,
        ZIP;

    }
}

