/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import is.hugvit.bird.Form;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.FormTranslationFactory;
import net.gopro.selfservice.forms.IFormTranslation;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.impl.renderers.BaseGoProFormProcessor;
import net.gopro.selfservice.impl.renderers.IGoProFormProcessor;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.SaxReader;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class GoProFormV2Processor
extends BaseGoProFormProcessor
implements IGoProFormProcessor {
    private static final Map uris = new HashMap();
    private static final Logger logger = Logger.getLogger(GoProFormV2Processor.class);
    private Form formData = null;

    @Override
    public Document processForm(ApplicationForm form, FormCase fc, Form data) throws SelfServiceException {
        return this.processForm(form.getAsFormTemplateFile(), fc, data);
    }

    @Override
    public Document processForm(FormTemplate template, FormCase fc, Form data, String languageId) throws SelfServiceException {
        try {
            FormTemplateFile templateData = this.getTemplateDataFile(template);
            if (StringUtil.isValid(languageId)) {
                BaseDocument trans = null;
                for (FormTranslation translation : template.getTranslations()) {
                    if (!translation.getIsocode().equals(languageId) || !translation.isEnabled()) continue;
                    trans = translation;
                    break;
                }
                if (trans != null) {
                    FormTranslation translation = FormService.getTranslation(trans.getId());
                    Document translationDocument = FormsUtil.createDocument(translation.getStream());
                    IFormTranslation ift = FormTranslationFactory.getInstance(template);
                    Document translatedTemplate = ift.translateForm(templateData, translationDocument);
                    templateData.setStream(translatedTemplate.asXML().getBytes("UTF-8"));
                }
            }
            return this.processForm(templateData, fc, data);
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public int processFileAttachments(Document doc, Form data, FormCase fc, ApplicationForm form) throws SelfServiceException, CaseException {
        int attachmentCount = 0;
        XPath xpath = doc.createXPath("//gpf:input[@type = 'File']");
        xpath.setNamespaceURIs(uris);
        List uploadNodes = xpath.selectNodes((Object)doc);
        if (uploadNodes != null && uploadNodes.size() > 0) {
            Document lastDoc = null;
            try {
                SAXReader reader = SaxReader.createReader();
                ByteArrayInputStream is = new ByteArrayInputStream(form.getStream());
                lastDoc = reader.read((InputStream)is);
                is.close();
            }
            catch (DocumentException ex) {
                ex.printStackTrace();
                logger.error((Object)ex);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                logger.error((Object)ex);
            }
            catch (SAXException ex) {
                ex.printStackTrace();
                logger.error((Object)ex);
            }
            for (Element el : uploadNodes) {
                String fileId = el.valueOf("@id");
                try {
                    String attachmentId;
                    SubDocument aa;
                    InputStream in = data.getInputStream(fileId);
                    if (in != null && in.available() > 0) {
                        Attachment att = new Attachment();
                        att.setCaseId(fc.getId());
                        boolean isPersonalSensitive = "true".equals(el.valueOf("@personal-sensitive"));
                        att.setPersonalSensitive(isPersonalSensitive);
                        String filename = data.getFilename(fileId);
                        att.setFilename(filename);
                        att.setFilesize(in.available());
                        String mimetype = SelfServiceEngine.getContext().getMimeType(att.getFilename());
                        if (mimetype == null) {
                            mimetype = "application/octet-stream";
                        }
                        att.setMimetype(mimetype);
                        byte[] bytes = new byte[in.available()];
                        in.read(bytes);
                        in.close();
                        att.setStream(bytes);
                        att.setSubject(Util.changeFileExt((String)att.getFilename(), (String)""));
                        String attachmentId2 = UID.getUID();
                        att.setId(attachmentId2);
                        ++attachmentCount;
                        fc.addSubDocument(att);
                        boolean isNew = true;
                        Element attachmentIdNode = el.element("value");
                        if (attachmentIdNode == null) {
                            attachmentIdNode = el.addElement("value").addText(attachmentId2);
                        } else {
                            attachmentIdNode.setText(attachmentId2);
                            isNew = false;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)"## Inline file upload start ##");
                        logger.trace((Object)("## File ID: " + fileId));
                        logger.trace((Object)("## SS ID: " + attachmentId2));
                        logger.trace((Object)("## Filename: " + filename));
                        logger.trace((Object)("## Filesize: " + bytes.length + " k"));
                        logger.trace((Object)("## Value node created: " + isNew));
                        logger.trace((Object)"##############################");
                        continue;
                    }
                    if (lastDoc == null) continue;
                    String query = "//gpf:input[@type = 'File' and @id='" + fileId + "']/gpf:value";
                    xpath = lastDoc.createXPath(query);
                    xpath.setNamespaceURIs(uris);
                    Node node = xpath.selectSingleNode((Object)lastDoc);
                    if (node == null || (aa = CaseService.getSubDocument(attachmentId = node.getText(), false)) == null) continue;
                    Element attachmentIdNode = el.element("value");
                    if (attachmentIdNode == null) {
                        attachmentIdNode = el.addElement("value").addText(attachmentId);
                        continue;
                    }
                    attachmentIdNode.setText(attachmentId);
                }
                catch (IOException ex) {
                    throw new SelfServiceException(ex);
                }
            }
        }
        return attachmentCount;
    }

    private Document processForm(FormTemplateFile template, FormCase fc, Form data) throws SelfServiceException {
        this.formData = data;
        Hashtable map = data.getHashtable();
        this.sanitizeMapValues(map);
        Document doc = this.getDocumentFromTemplate(template);
        XPath xpath = doc.createXPath("//gpf:section");
        xpath.setNamespaceURIs(uris);
        List sectionNodes = xpath.selectNodes((Object)doc);
        for (Element sectionNode : sectionNodes) {
            Iterator it = sectionNode.elementIterator();
            while (it.hasNext()) {
                Element node = (Element)it.next();
                String fieldId = node.valueOf("@id");
                Object value = map.get(fieldId);
                this.processElement(node, value);
            }
        }
        this.processRepeatableSections(doc, fc, data);
        return doc;
    }

    private void processElement(Element node, Object value) {
        Node valueNode;
        XPath xpath;
        String type;
        if ("true".equals(node.getParent().valueOf("@repeatable")) && ("Table".equals(node.getParent().valueOf("@repeatable-display-mode")) || "TableWithSum".equals(node.getParent().valueOf("@repeatable-display-mode"))) && "selection".equals(node.getName()) && ("Checkbox".equals(type = node.valueOf("@type")) || "true".equals(node.valueOf("@multiple"))) && value instanceof String && ((String)value).contains(",")) {
            value = Util.split((String)value.toString(), (String)",");
            Vector v = (Vector)value;
            for (int i = 0; i < v.size(); ++i) {
                v.set(i, ((String)v.get(i)).trim());
            }
        }
        if ("input".equals(node.getName()) || "textarea".equals(node.getName()) || "lookup".equals(node.getName())) {
            xpath = node.createXPath("gpf:value");
            xpath.setNamespaceURIs(uris);
            valueNode = xpath.selectSingleNode((Object)node);
            boolean isFileNode = "File".equalsIgnoreCase(node.valueOf("@type"));
            if (valueNode != null && value != null) {
                valueNode.setText((String)value);
            } else if (valueNode != null && value == null) {
                if (!isFileNode) {
                    valueNode.setText("");
                }
            } else if (value != null) {
                node.addElement("value").setText((String)value);
            }
        } else if ("range".equals(node.getName())) {
            if (value != null) {
                xpath = node.createXPath("gpf:value");
                xpath.setNamespaceURIs(uris);
                valueNode = xpath.selectSingleNode((Object)node);
                if (valueNode != null && value != null) {
                    valueNode.setText((String)value);
                } else if (value != null) {
                    node.addElement("value").setText((String)value);
                }
            }
        } else if ("selection".equals(node.getName())) {
            XPath xpath2;
            type = node.valueOf("@type");
            if ("Select".equals(type)) {
                boolean isMultiSelect = "true".equals(node.valueOf("@multiple"));
                XPath xpath3 = node.createXPath("gpf:option");
                xpath3.setNamespaceURIs(uris);
                List optionNodes = xpath3.selectNodes((Object)node);
                xpath3 = node.createXPath("gpf:list");
                xpath3.setNamespaceURIs(uris);
                Node staticListNode = xpath3.selectSingleNode((Object)node);
                if (staticListNode != null) {
                    Attribute att;
                    if (isMultiSelect && value instanceof Vector) {
                        Vector vValues = (Vector)value;
                        value = Util.expand((Vector)vValues, (String)",");
                    }
                    if ((att = ((Element)staticListNode).attribute("selected")) == null) {
                        ((Element)staticListNode).addAttribute("selected", (String)value);
                    } else {
                        att.setText((String)value);
                    }
                } else if (isMultiSelect) {
                    Vector vecValues = new Vector();
                    if (value != null && value instanceof String) {
                        vecValues.add((String)value);
                    } else if (value != null && value instanceof Vector) {
                        vecValues = (Vector)value;
                    }
                    for (Element optionNode : optionNodes) {
                        if (vecValues.contains(optionNode.valueOf("@value"))) {
                            optionNode.addAttribute("selected", "true");
                            continue;
                        }
                        Attribute attr = optionNode.attribute("selected");
                        if (attr == null) continue;
                        optionNode.remove(attr);
                    }
                } else {
                    if (optionNodes.size() == 0) {
                        xpath3 = node.createXPath("gpf:optionGroup/gpf:option");
                        xpath3.setNamespaceURIs(uris);
                        optionNodes = xpath3.selectNodes((Object)node);
                    }
                    if (value != null) {
                        for (Element optionNode : optionNodes) {
                            if (value.equals(optionNode.valueOf("@value"))) {
                                optionNode.addAttribute("selected", "true");
                                continue;
                            }
                            Attribute attr = optionNode.attribute("selected");
                            if (attr == null) continue;
                            optionNode.remove(attr);
                        }
                    }
                }
            } else if ("Checkbox".equals(type)) {
                xpath2 = node.createXPath("gpf:option");
                xpath2.setNamespaceURIs(uris);
                List optionNodes = xpath2.selectNodes((Object)node);
                xpath2 = node.createXPath("gpf:list");
                xpath2.setNamespaceURIs(uris);
                Node staticListNode = xpath2.selectSingleNode((Object)node);
                Vector vecValues = new Vector();
                if (value != null && value instanceof String) {
                    vecValues.add((String)value);
                } else if (value != null && value instanceof Vector) {
                    vecValues = (Vector)value;
                }
                if (staticListNode != null) {
                    String selValue = Util.expand(vecValues, (String)",");
                    Attribute att = ((Element)staticListNode).attribute("selected");
                    if (att == null) {
                        ((Element)staticListNode).addAttribute("selected", selValue);
                    } else {
                        att.setText(selValue);
                    }
                } else {
                    for (Element optionNode : optionNodes) {
                        if (vecValues.contains(optionNode.valueOf("@value"))) {
                            optionNode.addAttribute("selected", "true");
                            continue;
                        }
                        Attribute attr = optionNode.attribute("selected");
                        if (attr == null) continue;
                        optionNode.remove(attr);
                    }
                }
            } else if ("Radio".equals(type)) {
                xpath2 = node.createXPath("gpf:option");
                xpath2.setNamespaceURIs(uris);
                List optionNodes = xpath2.selectNodes((Object)node);
                xpath2 = node.createXPath("gpf:list");
                xpath2.setNamespaceURIs(uris);
                Node staticListNode = xpath2.selectSingleNode((Object)node);
                if (staticListNode != null) {
                    Attribute att = ((Element)staticListNode).attribute("selected");
                    if (att == null) {
                        ((Element)staticListNode).addAttribute("selected", (String)value);
                    } else {
                        att.setText((String)value);
                    }
                } else {
                    for (Element optionNode : optionNodes) {
                        if (value != null && value.equals(optionNode.valueOf("@value"))) {
                            optionNode.addAttribute("selected", "true");
                            continue;
                        }
                        Attribute attr = optionNode.attribute("selected");
                        if (attr == null) continue;
                        optionNode.remove(attr);
                    }
                }
            }
        } else if ("group".equals(node.getName())) {
            Iterator it = node.elementIterator();
            while (it.hasNext()) {
                Element fieldNode = (Element)it.next();
                String fieldId = fieldNode.valueOf("@id");
                this.processElement(fieldNode, this.formData.get(fieldId));
            }
        } else if ("matrix".equals(node.getName())) {
            this.extractMatrixValues(node, this.formData);
        }
    }

    private void extractMatrixValues(Element matrix, Form data) {
        XPath xpath = matrix.createXPath("gpf:headers/gpf:label");
        xpath.setNamespaceURIs(uris);
        List headerLabelNodes = xpath.selectNodes((Object)matrix);
        xpath = matrix.createXPath("gpf:fields|gpf:options");
        xpath.setNamespaceURIs(uris);
        Element root = (Element)xpath.selectSingleNode((Object)matrix);
        Element elValues = matrix.element("values");
        if (elValues == null) {
            elValues = matrix.addElement("values");
        } else if (elValues.nodeCount() > 0) {
            elValues.clearContent();
        }
        if ("fields".equals(root.getName())) {
            for (Element label : headerLabelNodes) {
                String labelKey = label.valueOf("@id");
                Iterator it = root.elementIterator();
                while (it.hasNext()) {
                    Element field = (Element)it.next();
                    String fieldKey = field.valueOf("@id");
                    String lookupKey = labelKey + "-" + fieldKey;
                    Object value = data.get(lookupKey);
                    if (value == null) continue;
                    Element elField = elValues.addElement("field");
                    elField.addAttribute("id", lookupKey);
                    if (value instanceof Vector) {
                        for (Object o : (Vector)value) {
                            elField.addElement("value").setText((String)o);
                        }
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    elField.addElement("value").setText((String)value);
                }
            }
        } else if ("options".equals(root.getName())) {
            String matrixId = matrix.valueOf("@id");
            for (Element label : headerLabelNodes) {
                String labelKey = label.valueOf("@id");
                String lookupKey = matrixId + "-" + labelKey;
                Object value = data.get(lookupKey);
                if (value == null) continue;
                Element elField = elValues.addElement("field");
                elField.addAttribute("id", lookupKey);
                if (!(value instanceof String)) continue;
                elField.addElement("value").setText((String)value);
            }
        }
        if (!elValues.hasContent()) {
            matrix.remove(elValues);
        }
    }

    private final void processRepeatableSections(Document doc, FormCase fc, Form data) throws SelfServiceException {
        XPath xpath = doc.createXPath("//gpf:section[@repeatable='true']");
        xpath.setNamespaceURIs(uris);
        List sections = xpath.selectNodes((Object)doc);
        Iterator sectionIt = sections.iterator();
        Hashtable ht = data.getHashtable();
        Hashtable htFiles = data.getHtFiles();
        ArrayList<RepeatableSectionItem> itemList = null;
        while (sectionIt.hasNext()) {
            boolean isTableWithSum;
            RepeatableSectionItem rsi2;
            Object dataKey;
            Element sectionNode = (Element)sectionIt.next();
            String sectionId = sectionNode.valueOf("@id");
            String lookupKey = ":" + sectionId + ":";
            itemList = new ArrayList<RepeatableSectionItem>();
            for (Object key : ht.keySet()) {
                dataKey = (String)key;
                if (!((String)dataKey).contains(lookupKey) || (rsi2 = this.getRepeatableFieldValue(sectionId, (String)dataKey, ht, sectionNode)) == null) continue;
                itemList.add(rsi2);
            }
            if (htFiles != null) {
                for (Object key : htFiles.keySet()) {
                    dataKey = (String)key;
                    if (!((String)dataKey).contains(lookupKey)) continue;
                    rsi2 = this.getRepeatableFileValue((String)dataKey, htFiles, fc, data);
                    if (rsi2 != null) {
                        itemList.add(rsi2);
                        continue;
                    }
                    Object hiddenId = ht.get("file_" + (String)dataKey);
                    if (hiddenId == null) continue;
                    itemList.add(new RepeatableSectionItem((String)dataKey, hiddenId));
                }
            }
            xpath = doc.createXPath("gpf:values");
            xpath.setNamespaceURIs(uris);
            Node valueNode = xpath.selectSingleNode((Object)sectionNode);
            if (valueNode != null) {
                sectionNode.remove(valueNode);
            }
            if (itemList.size() > 0) {
                Element el = sectionNode.addElement("values");
                for (RepeatableSectionItem rsi2 : itemList) {
                    xpath = doc.createXPath("gpf:item[@order=" + rsi2.getRowIndex() + "]");
                    xpath.setNamespaceURIs(uris);
                    Node itemNode = xpath.selectSingleNode((Object)el);
                    if (itemNode == null) {
                        itemNode = el.addElement("item").addAttribute("order", String.valueOf(rsi2.getRowIndex()));
                    }
                    rsi2.addElement((Element)itemNode);
                }
            }
            if (!(isTableWithSum = "TableWithSum".equals(sectionNode.valueOf("@repeatable-display-mode"))) || !fc.isSent()) continue;
            Enumeration keys = ht.keys();
            while (keys.hasMoreElements()) {
                String fieldSum;
                Vector vSums;
                String fieldKey = (String)keys.nextElement();
                if (!fieldKey.startsWith(sectionId) || !fieldKey.endsWith("_sum")) continue;
                Object objSumField = ht.get(fieldKey);
                if (objSumField instanceof String) {
                    String fieldSum2 = (String)objSumField;
                    if (fieldSum2 == null || "".equals(fieldSum2)) continue;
                    fc.getMetadata().add(new MetaData(fieldKey, fieldSum2));
                    continue;
                }
                if (!(objSumField instanceof Vector) || (vSums = (Vector)objSumField).isEmpty() || (fieldSum = ((Vector)objSumField).get(0).toString()) == null || "".equals(fieldSum)) continue;
                fc.getMetadata().add(new MetaData(fieldKey, fieldSum));
            }
        }
    }

    private RepeatableSectionItem getRepeatableFieldValue(String sectionId, String dataKey, Hashtable ht, Element sectionNode) {
        String[] tokens = dataKey.split(":");
        if (tokens == null || tokens.length < 3) {
            return null;
        }
        Object fieldValue = ht.get(dataKey);
        RepeatableSectionItem rsi = new RepeatableSectionItem(dataKey, fieldValue);
        return rsi;
    }

    private RepeatableSectionItem getRepeatableFileValue(String dataKey, Hashtable fileData, FormCase fc, Form data) throws SelfServiceException {
        RepeatableSectionItem rsi = null;
        String fieldValue = null;
        String filename = this.getFilename(fileData.get(dataKey));
        try {
            InputStream in = data.getInputStream(dataKey);
            if (in != null && in.available() > 0) {
                Attachment att = new Attachment();
                att.setCaseId(fc.getId());
                att.setFilename(filename);
                att.setFilesize(in.available());
                String mimetype = SelfServiceEngine.getContext().getMimeType(att.getFilename());
                if (mimetype == null) {
                    mimetype = "application/octet-stream";
                }
                att.setMimetype(mimetype);
                byte[] bytes = new byte[in.available()];
                in.read(bytes);
                in.close();
                att.setStream(bytes);
                att.setSubject(Util.changeFileExt((String)att.getFilename(), (String)""));
                String attachmentId = UID.getUID();
                att.setId(attachmentId);
                fc.addSubDocument(att);
                fieldValue = attachmentId;
                rsi = new RepeatableSectionItem(dataKey, fieldValue);
            }
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        return rsi;
    }

    static {
        uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
    }

    private class RepeatableSectionItem {
        private int rowIndex;
        private String key;
        private Object value;
        private String sectionId;

        public RepeatableSectionItem(String s, Object value) {
            this.value = value;
            this.populate(s);
        }

        private void populate(String s) {
            String[] tokens = s.split(":");
            if (tokens != null && tokens.length == 3) {
                this.key = tokens[0];
                this.sectionId = tokens[1];
                this.rowIndex = Integer.valueOf(tokens[2]);
            }
        }

        public String toString() {
            return this.rowIndex + " : " + this.sectionId + " : " + this.key + " : " + this.value;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void addElement(Element parent) {
            Element el = parent.addElement("field");
            el.addAttribute("id", this.key);
            if (this.value instanceof Vector) {
                Element elVal = el.addElement("value");
                elVal.setText(Util.expand((Vector)((Vector)this.value), (String)", "));
            } else if (this.value instanceof String) {
                Element elVal = el.addElement("value");
                elVal.setText((String)this.value);
            } else {
                Element elVal = el.addElement("value");
                elVal.setText("");
            }
        }
    }
}

