/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.IFormTemplateRenderer;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.MessageHelper;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SignedFormDocument;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.FormDeadlineException;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.forms.FormTranslationFactory;
import net.gopro.selfservice.forms.IFormTranslation;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.impl.renderers.IGoProFormProcessor;
import net.gopro.selfservice.pdf.PDFProperties;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BirdUtil;
import net.gopro.selfservice.util.CollaborationHelper;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.SaxReader;
import net.gopro.selfservice.util.SignatureUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class GoProFormRenderer
implements IFormTemplateRenderer {
    private static final Logger logger = Logger.getLogger(GoProFormRenderer.class);

    protected abstract String transformDocument(WebContext var1, FormTemplateFile var2, FormTemplateFile var3) throws SelfServiceException;

    protected abstract byte[] transFormToPDF(PDFProperties var1, Document var2, FormTemplateExtras.XSLFoType var3) throws SelfServiceException;

    protected abstract void computeValues(WebContext var1, FormTemplate var2, FormTemplateFile var3) throws SelfServiceException;

    protected abstract IGoProFormProcessor getFormProcessor() throws SelfServiceException;

    @Override
    public boolean doRender(WebContext context, Element root, FormTemplate formTemplate, Organization organization) throws SelfServiceException {
        FormTemplateFile dataXmlFile = formTemplate.getFormTemplateFile(FormTemplateFile.Tag.DATA);
        FormTemplateFile editXslFile = formTemplate.getFormTemplateFile(FormTemplateFile.Tag.EDIT);
        Element el = DocumentHelper.createElement((String)"template");
        boolean isLocaleAutoDetect = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("goproforms.translate.auto"));
        if (this.isTranslationRequest(context, formTemplate)) {
            String language = (String)context.getRequest().getSession().getAttribute("form.language.id");
            this.translateFormTemplate(formTemplate, dataXmlFile, language);
            el.addAttribute("language", language);
        } else if (isLocaleAutoDetect) {
            User currentUser;
            Locale defaultLocale = LocaleUtil.getDefaultLocale();
            String language = (String)context.getRequest().getSession().getAttribute("form.language.id");
            if (!defaultLocale.getLanguage().equalsIgnoreCase(language) && (currentUser = UserService.getUserByUsername(context.getRequest().getUserPrincipal().getName())).getLocale() != null && !LocaleUtil.getDefaultLocale().getLanguage().equalsIgnoreCase(currentUser.getLocale())) {
                String requestIso = currentUser.getLocale();
                String[] parts = currentUser.getLocale().split("_");
                if (parts.length == 2) {
                    requestIso = parts[0];
                }
                if (this.translateFormTemplate(formTemplate, dataXmlFile, requestIso)) {
                    el.addAttribute("language", requestIso);
                }
            }
        }
        this.computeValues(context, formTemplate, dataXmlFile);
        String transformation = this.transformDocument(context, dataXmlFile, editXslFile);
        el.add(formTemplate.getXml());
        el.add(organization.getXml());
        el.addElement("formdata").addCDATA(transformation);
        root.add(el);
        try {
            this.setXmlSections((GoProFormTemplate)formTemplate, el);
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
        return true;
    }

    private boolean translateFormTemplate(FormTemplate formTemplate, FormTemplateFile dataXmlFile, String language) throws SelfServiceException {
        try {
            BaseDocument trans = null;
            for (FormTranslation translation : formTemplate.getTranslations()) {
                if (!translation.getIsocode().equalsIgnoreCase(language)) continue;
                trans = translation;
                break;
            }
            if (trans != null && (trans = FormService.getTranslation(trans.getId())) != null && ((FormTranslation)trans).isEnabled() && !trans.isDeleted()) {
                Document translationDoc = FormsUtil.createDocument(((FormTranslation)trans).getStream());
                IFormTranslation ift = FormTranslationFactory.getInstance(formTemplate);
                Document translatedForm = ift.translateForm(dataXmlFile, translationDoc);
                dataXmlFile.setStream(translatedForm.asXML().getBytes("UTF-8"));
                formTemplate.setLanguage(((FormTranslation)trans).getIsocode());
                return true;
            }
            return false;
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean doRender(WebContext context, Element root, ApplicationForm form) throws SelfServiceException {
        this.validateInternalFileAttachments(form);
        FormTemplateFile dataXmlFile = form.getAsFormTemplateFile();
        FormTemplate formTemplate = FormService.getFormTemplate(form.getFormtemplateId(), true);
        FormTemplateFile xsl = null;
        xsl = form.isSent() ? formTemplate.getFormTemplateFile(FormTemplateFile.Tag.READ) : formTemplate.getFormTemplateFile(FormTemplateFile.Tag.EDIT);
        String transformation = this.transformDocument(context, dataXmlFile, xsl);
        Element el = DocumentHelper.createElement((String)"template");
        el.add(form.getXml());
        el.add(formTemplate.getXml());
        el.addElement("formdata").addCDATA(transformation);
        if (form.isSent()) {
            el.addAttribute("readonly", "true");
        } else {
            MetaData mLng;
            el.addAttribute("readonly", "false");
            MetaData mPage = form.getMetaDataByKey("current.page");
            if (mPage != null && StringUtil.isValid(mPage.getValue())) {
                el.addAttribute("current-page", mPage.getValue());
            }
            if ((mLng = form.getMetaDataByKey("form.language.id")) != null && StringUtil.isValid(mLng.getValue())) {
                el.addAttribute("language", mLng.getValue());
            }
        }
        root.add(el);
        try {
            this.setXmlSections((GoProFormTemplate)formTemplate, el);
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
        return true;
    }

    @Override
    public void doSave(WebContext context, Form data, FormTemplate formTemplate, Organization organization, IFormTemplateRenderer.FormStatus status) throws SelfServiceException, FormDeadlineException, CaseException {
        try {
            int newAttachments;
            MetaData m;
            StatusListItem initialStatus;
            LinkedList<StatusListItem> statusList;
            String parentId;
            HttpSession session = context.getRequest().getSession();
            User user = UserService.getUserByUsername(context.getRequest().getUserPrincipal().getName());
            boolean isFinalized = IFormTemplateRenderer.FormStatus.SEND.equals((Object)status);
            ArrayList<AccessControl> acl = new ArrayList<AccessControl>();
            AccessControl userAcl = new AccessControl();
            userAcl.setBitmask(AccessControl.Permission.WRITE.getValue());
            userAcl.setEntityType(AccessControl.AccessControlType.USER);
            userAcl.setEntityId(user.getId());
            acl.add(userAcl);
            FormCase fc = new FormCase(formTemplate);
            fc.setOrganizationId(organization.getId());
            fc.setCreatedById(user.getId());
            fc.setModifiedById(user.getId());
            fc.setPersonalSensitive(formTemplate.isPersonalSensitive());
            String contactId = (String)session.getAttribute("contactId");
            String contactType = (String)session.getAttribute("contactType");
            if ("contact".equals(contactType)) {
                Contact contact = UserService.getContact(contactId);
                if (contact != null) {
                    fc.setContactId(contact.getId());
                    fc.setCompanyId(contact.getCompanyId());
                    AccessControl companyAcl = new AccessControl();
                    companyAcl.setBitmask(AccessControl.Permission.WRITE.getValue());
                    companyAcl.setEntityType(AccessControl.AccessControlType.COMPANY);
                    companyAcl.setEntityId(contact.getCompanyId());
                    acl.add(companyAcl);
                } else {
                    logger.error((Object)("The contact was not found! " + contactId));
                }
            }
            fc.setSent(isFinalized);
            if (isFinalized) {
                fc.setDateCompleted(new Date().getTime());
                fc.setCompletedById(user.getId());
            }
            if ((parentId = data.getString("parent_id")) != null && parentId.length() == 32) {
                fc.setParentId(parentId);
            }
            String translationLanguage = data.getString("current-lng");
            Document doc = this.getFormProcessor().processForm(formTemplate, fc, data, translationLanguage);
            if (isFinalized && !formTemplate.isWithinDateRestriction()) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", context.getRequest());
                throw new FormDeadlineException(rb.getString("form.expired"));
            }
            if (formTemplate.getExtendedData() != null && formTemplate.getExtendedData().getCaseStatusList() != null && (statusList = formTemplate.getExtendedData().getCaseStatusList()).size() > 0 && (initialStatus = statusList.getFirst()) != null) {
                fc.setStatusId(initialStatus.getId());
            }
            ApplicationForm form = new ApplicationForm();
            form.setFormtemplateId(formTemplate.getId());
            form.setSubject(formTemplate.getSubject());
            form.setStream(doc.asXML().getBytes("UTF-8"));
            form.setFileName(formTemplate.getSubject(), "xml");
            form.setMimetype("text/xml");
            form.setSent(isFinalized);
            form.setPersonalSensitive(fc.isPersonalSensitive());
            if (!isFinalized && data.contains("current-page") && StringUtil.isValid(data.getString("current-page"))) {
                m = new MetaData();
                m.setKey("current.page");
                m.setValue(data.getString("current-page"));
                m.setUserId(user.getId());
                form.getMetadata().add(m);
            }
            if (data.contains("current-lng") && StringUtil.isValid(data.getString("current-lng"))) {
                m = new MetaData();
                m.setKey("form.language.id");
                m.setValue(data.getString("current-lng"));
                m.setUserId(user.getId());
                form.getMetadata().add(m);
            }
            if ((newAttachments = this.getFormProcessor().processFileAttachments(doc, data, fc, form)) > 0) {
                form.setStream(doc.asXML().getBytes("UTF-8"));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"----------------");
                logger.trace((Object)("Attachment count: " + newAttachments));
                if (newAttachments > 0) {
                    logger.trace((Object)doc.asXML());
                }
                logger.trace((Object)"----------------");
            }
            if (null == form.getStream()) {
                throw new SelfServiceException("The processed document is empty.");
            }
            fc.addSubDocument(form);
            fc.getAccessControlList().addAll(acl);
            form.getAccessControlList().addAll(acl);
            for (SubDocument subDocument : fc.getSubDocuments()) {
                subDocument.getAccessControlList().addAll(acl);
            }
            try {
                Hashtable<String, String> keyFields = formTemplate.getFormQueryProcessor().getKeyFields(form);
                if (keyFields != null && keyFields.size() > 0) {
                    Enumeration<String> enumeration = keyFields.keys();
                    while (enumeration.hasMoreElements()) {
                        String keyFieldId = enumeration.nextElement();
                        String keyFieldValue = keyFields.get(keyFieldId);
                        MetaData meta = fc.getMetaDataByKey(keyFieldId);
                        if (meta != null) {
                            meta.setValue(keyFieldValue);
                            meta.setUserId(user.getId());
                            meta.setDirty(true);
                            continue;
                        }
                        fc.getMetadata().add(new MetaData(keyFieldId, keyFieldValue, user.getId()));
                    }
                }
            }
            catch (FormQueryException ex) {
                logger.error((Object)"Error retrieving key fields", (Throwable)ex);
            }
            if (isFinalized) {
                for (SubDocument subDocument : fc.getSubDocuments()) {
                    subDocument.setSent(!fc.isSignaturePending());
                    subDocument.setCompletedById(user.getId());
                }
                this.setNextCaseStatus(formTemplate, fc);
                try {
                    Hashtable<String, String> pairs = formTemplate.getFormQueryProcessor().getKeyValuePairs(form);
                    for (String key : pairs.keySet()) {
                        MetaData md = new MetaData(key, pairs.get(key));
                        form.getMetadata().add(md);
                    }
                    for (MetaData meta : fc.getMetadata()) {
                        form.getMetadata().add(new MetaData(meta.getKey(), meta.getValue(), meta.getUserId()));
                    }
                }
                catch (FormQueryException ex) {
                    logger.error((Object)"Error generating Metadata", (Throwable)ex);
                }
                if (formTemplate.isSignatureRequired()) {
                    fc.setSignaturePending(true);
                }
            }
            CaseService.createCase(fc);
            if (isFinalized) {
                Document xmlDoc = FormsUtil.createDocument(form.getStream());
                CompletedFormDocument completedFormDocument = this.createCompletedFormDocument(context, fc, xmlDoc, user);
                completedFormDocument.setSent(!fc.isSignaturePending());
                completedFormDocument.getAccessControlList().addAll(acl);
                CaseService.createSubDocument(completedFormDocument);
                if (fc.isSignaturePending()) {
                    ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common", context.getRequest());
                    Task task = new Task();
                    task.setCreatedById(user.getId());
                    task.setParentId(fc.getId());
                    task.setResponsibleId(user.getId());
                    task.setDateCreated(new Date().getTime());
                    task.setStatus(Task.TaskStatus.NotStarted);
                    task.setSubject(rb.getString("case.task.sign.title"));
                    task.setDescription(String.format(rb.getString("case.task.sign.body"), fc.getSubject()));
                    task.setCategoryId("06A67334D7FF5D60000001530DA2CE90");
                    Calendar deadline = Calendar.getInstance();
                    deadline.add(10, 168);
                    task.setDeadline(deadline.getTimeInMillis());
                    TaskService.createTask(task);
                } else {
                    MessageHelper.sendApplicationSendMessage(user, formTemplate, Arrays.asList(fc, form));
                    List<CollaborationHelper.Collaborator> collaborationUserList = new CollaborationHelper(fc).getUserList();
                    for (CollaborationHelper.Collaborator collaborator : collaborationUserList) {
                        if (collaborator.getUserId().equals(user.getId())) continue;
                        try {
                            User cuser = UserService.getUser(collaborator.getUserId());
                            if (cuser == null || cuser.isDeleted()) continue;
                            MessageHelper.sendApplicationSendMessage(cuser, formTemplate, Arrays.asList(fc, form));
                        }
                        catch (SelfServiceException ex) {
                            logger.error((Object)("Could not find collaborator with id: " + collaborator.getUserId()));
                        }
                    }
                }
            } else if (IFormTemplateRenderer.FormStatus.SAVE.equals((Object)status) && fc.isCheckOutRequired() && !form.isAutoCheckOutDisabled()) {
                CaseService.checkOutDocument(form.getId(), user.getId());
            }
            if (formTemplate.isPostSendUsingViewFilter()) {
                this.setRedirectUrl(context, status, form.getId(), formTemplate.getId(), fc.isSignaturePending(), fc.getId());
            } else {
                this.setRedirectUrl(context, status, form.getId(), null, fc.isSignaturePending(), fc.getId());
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelfServiceException(ex);
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void doSave(WebContext context, Form data, ApplicationForm form, IFormTemplateRenderer.FormStatus status) throws SelfServiceException, SaveConflictException, FormDeadlineException, CaseException {
        block31: {
            try {
                User user = UserService.getUserByUsername(context.getRequest().getUserPrincipal().getName());
                FormTemplate ft = FormService.getFormTemplate(form.getFormtemplateId(), false);
                if (ft == null) {
                    throw new SelfServiceException("The form template for the application was not found!");
                }
                boolean isFinalized = IFormTemplateRenderer.FormStatus.SEND.equals((Object)status);
                if (isFinalized && !ft.isWithinDateRestriction()) {
                    ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", context.getRequest());
                    throw new FormDeadlineException(rb.getString("form.expired"));
                }
                BaseCase bc = CaseService.getCase(form.getCaseId());
                if (bc != null && bc instanceof FormCase) {
                    MetaData m;
                    FormCase fc = (FormCase)bc;
                    fc.setModifiedById(user.getId());
                    fc.setSent(isFinalized);
                    Document doc = this.getFormProcessor().processForm(form, fc, data);
                    form.setSent(isFinalized);
                    form.setStream(doc.asXML().getBytes("UTF-8"));
                    form.setModifiedById(user.getId());
                    int newAttachments = this.getFormProcessor().processFileAttachments(doc, data, fc, form);
                    if (newAttachments > 0) {
                        form.setStream(doc.asXML().getBytes("UTF-8"));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"----------------");
                        logger.trace((Object)("Attachment count: " + newAttachments));
                        if (newAttachments > 0) {
                            logger.trace((Object)doc.asXML());
                        }
                        logger.trace((Object)"----------------");
                    }
                    try {
                        Hashtable<String, String> keyFields = ft.getFormQueryProcessor().getKeyFields(form);
                        if (keyFields != null && keyFields.size() > 0) {
                            Iterator<MetaData> keys = keyFields.keys();
                            while (keys.hasMoreElements()) {
                                String keyFieldId = keys.nextElement();
                                String keyFieldValue = keyFields.get(keyFieldId);
                                MetaData meta = bc.getMetaDataByKey(keyFieldId);
                                if (meta != null) {
                                    meta.setValue(keyFieldValue);
                                    meta.setUserId(user.getId());
                                    meta.setDirty(true);
                                    continue;
                                }
                                bc.getMetadata().add(new MetaData(keyFieldId, keyFieldValue, user.getId()));
                            }
                        }
                    }
                    catch (FormQueryException ex) {
                        logger.error((Object)"Error retrieving key fields", (Throwable)ex);
                    }
                    if (!isFinalized && data.contains("current-page") && StringUtil.isValid(data.getString("current-page")) && (m = form.getMetaDataByKey("current.page")) != null) {
                        m.setValue(data.getString("current-page"));
                        m.setDirty(true);
                    }
                    if (isFinalized) {
                        if (ft.isSignatureRequired()) {
                            fc.setSignaturePending(true);
                        }
                        this.setNextCaseStatus(ft, fc);
                        form.setDateCompleted(new Date().getTime());
                        form.setCompletedById(user.getId());
                        fc.setSent(true);
                        fc.setDateCompleted(new Date().getTime());
                        fc.setCompletedById(user.getId());
                        try {
                            Hashtable<String, String> pairs = ft.getFormQueryProcessor().getKeyValuePairs(form);
                            for (String key : pairs.keySet()) {
                                MetaData md = new MetaData(key, pairs.get(key));
                                form.getMetadata().add(md);
                            }
                            for (MetaData meta : fc.getMetadata()) {
                                form.getMetadata().add(new MetaData(meta.getKey(), meta.getValue(), meta.getUserId()));
                            }
                        }
                        catch (FormQueryException ex) {
                            logger.error((Object)"Error generating Metadata", (Throwable)ex);
                        }
                    }
                    CaseService.updateSubDocument(form);
                    fc.setApplicationForm(form);
                    CaseService.updateCase(fc);
                    if ((isFinalized || IFormTemplateRenderer.FormStatus.SAVE_AND_CHECKIN.equals((Object)status)) && form.isCheckedOut()) {
                        CaseService.checkInDocument(form.getId());
                    }
                    if (isFinalized) {
                        Document xmlDoc = FormsUtil.createDocument(form.getStream());
                        CompletedFormDocument pdf = this.createCompletedFormDocument(context, fc, xmlDoc, user);
                        pdf.setSent(!fc.isSignaturePending());
                        pdf.getAccessControlList().addAll(fc.getAccessControlList());
                        CaseService.createSubDocument(pdf);
                        if (fc.isSignaturePending()) {
                            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.common", context.getRequest());
                            Task task = new Task();
                            task.setCreatedById(user.getId());
                            task.setResponsibleId(user.getId());
                            task.setDateCreated(new Date().getTime());
                            task.setStatus(Task.TaskStatus.NotStarted);
                            task.setSubject(rb.getString("case.task.sign.title"));
                            task.setParentId(fc.getId());
                            task.setDescription(String.format(rb.getString("case.task.sign.body"), fc.getSubject()));
                            task.setCategoryId("06A67334D7FF5D60000001530DA2CE90");
                            Calendar deadline = Calendar.getInstance();
                            deadline.add(10, 168);
                            task.setDeadline(deadline.getTimeInMillis());
                            TaskService.createTask(task);
                        } else {
                            User createdByUser;
                            MessageHelper.sendApplicationSendMessage(user, ft, Arrays.asList(fc, form));
                            if (!user.getId().equals(fc.getCreatedById()) && (createdByUser = UserService.getUser(fc.getCreatedById())) != null && !createdByUser.isDeleted()) {
                                MessageHelper.sendApplicationSendMessage(createdByUser, ft, Arrays.asList(fc, form));
                            }
                            List<CollaborationHelper.Collaborator> collaborationUserList = new CollaborationHelper(fc).getUserList();
                            for (CollaborationHelper.Collaborator collaborator : collaborationUserList) {
                                if (collaborator.getUserId().equals(user.getId())) continue;
                                try {
                                    User cuser = UserService.getUser(collaborator.getUserId());
                                    if (cuser == null || cuser.isDeleted()) continue;
                                    MessageHelper.sendApplicationSendMessage(cuser, ft, Arrays.asList(fc, form));
                                }
                                catch (SelfServiceException ex) {
                                    logger.error((Object)("Could not find collaborator with id: " + collaborator.getUserId()));
                                }
                            }
                        }
                    }
                    if (ft.isPostSendUsingViewFilter()) {
                        this.setRedirectUrl(context, status, data.getID(), ft.getId(), fc.isSignaturePending(), fc.getId());
                    } else {
                        this.setRedirectUrl(context, status, data.getID(), null, fc.isSignaturePending(), fc.getId());
                    }
                    break block31;
                }
                throw new SelfServiceException("The parent Case could not found.");
            }
            catch (UnsupportedEncodingException ex) {
                throw new SelfServiceException(ex);
            }
            catch (FormException ex) {
                throw new SelfServiceException(ex);
            }
        }
    }

    private void setRedirectUrl(WebContext context, IFormTemplateRenderer.FormStatus status, String formId, String formtemplateId, boolean isPendingSignature, String caseId) {
        if (IFormTemplateRenderer.FormStatus.SEND.equals((Object)status) && isPendingSignature) {
            context.setRedirectURL("case.html?id=" + caseId);
        } else if (IFormTemplateRenderer.FormStatus.SEND.equals((Object)status)) {
            if (formtemplateId != null) {
                context.setRedirectURL("mycases.html?type=" + formtemplateId);
            } else {
                context.setRedirectURL("mycases.html");
            }
        } else if (IFormTemplateRenderer.FormStatus.SAVE.equals((Object)status)) {
            context.setRedirectURL("application.html?id=" + formId);
        } else if (formtemplateId != null) {
            context.setRedirectURL("mycases.html?type=" + formtemplateId);
        } else {
            context.setRedirectURL("mycases.html");
        }
    }

    protected final boolean overrideXsl() {
        return "true".equalsIgnoreCase(SelfServiceEngine.getConfig("goproforms.xsl.override"));
    }

    private void setNextCaseStatus(FormTemplate ft, FormCase fc) throws SelfServiceException {
        LinkedList<StatusListItem> statusList;
        FormTemplateExtras fex = ft.getExtendedData();
        if (fex != null && (statusList = fex.getCaseStatusList()) != null && statusList.size() > 1) {
            StatusListItem nextStatus = statusList.get(1);
            fc.setStatusId(nextStatus.getId());
            fc.setStatusText(nextStatus.getSubject());
        }
    }

    private void setXmlSections(GoProFormTemplate ft, Element dataroot) throws FormException {
        dataroot.add(ft.getSectionsAsElement());
    }

    private final CompletedFormDocument createCompletedFormDocument(WebContext context, FormCase fc, Document doc, User user) throws SelfServiceException {
        try {
            BirdFile bf;
            Organization org = ConfigService.getOrganization(fc.getOrganizationId());
            Element files = doc.getRootElement().addElement("FILES");
            for (SubDocument subdoc : fc.getSubDocuments()) {
                if (!(subdoc instanceof Attachment)) continue;
                Attachment att = (Attachment)subdoc;
                Element elFile = files.addElement("FILE");
                elFile.addAttribute("id", att.getId());
                elFile.setText(att.getFilename());
            }
            MetaData md = org.getMetaDataByKey("image.id");
            if (md != null && (bf = BirdUtil.getFile(context, md.getValue())) != null) {
                HttpServletRequest req = context.getRequest();
                String base = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
                String imagePath = base + context.getRequest().getContextPath() + "/web/files/" + bf.getName() + "/" + bf.getFilename();
                doc.getRootElement().addAttribute("IMAGE-LOGO", imagePath);
            }
            DateFormat df = LocaleUtil.getTimeFormat();
            doc.getRootElement().addAttribute("SUBMITTED", df.format(new Date()));
            doc.getRootElement().addAttribute("ORGANIZATION", org.getSubject());
            doc.getRootElement().addAttribute("TEMPLATE-ID", fc.getFormtemplateId());
            doc.getRootElement().addAttribute("CASENUMBER", fc.getReferenceNumber());
            FormTemplate ft = FormService.getFormTemplate(fc.getFormtemplateId(), false);
            if (ft.getExtendedData() != null & ft.getExtendedData().getGoproAlias() != null) {
                doc.getRootElement().addAttribute("GOPRO-CASETYPE", ft.getExtendedData().getGoproAlias());
            }
            PDFProperties properties = PDFProperties.getInstance(user, fc);
            byte[] pdfStream = this.transFormToPDF(properties, doc, ft.getExtendedData().getPdfFoType());
            if (org.isSigning()) {
                try {
                    pdfStream = SignatureUtil.signDocument(pdfStream, org);
                }
                catch (Exception ex) {
                    logger.error((Object)"Error signing PDF document", (Throwable)ex);
                }
            }
            CompletedFormDocument cf = new CompletedFormDocument();
            cf.setStream(pdfStream);
            cf.setFilesize(pdfStream.length);
            cf.setMimetype("application/pdf");
            cf.setFileName(fc.getSubject(), "pdf");
            cf.setCreatedById(user.getId());
            cf.setAuthorName(user.getFullname());
            cf.setFromGoPro(false);
            cf.setCaseId(fc.getId());
            cf.setParentId(fc.getId());
            cf.setFormtemplateId(fc.getFormtemplateId());
            cf.setSubject(fc.getSubject());
            cf.setSent(true);
            cf.setDateCompleted(new Date().getTime());
            return cf;
        }
        catch (BirdException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    private ExternalDocument extractDigitalSignature(FormCase fc, Form data) throws SelfServiceException {
        try {
            SignedFormDocument doc = null;
            String signatureField = "user-digital-signature";
            if (data.contains("user-digital-signature")) {
                String signature = data.getString("user-digital-signature");
                String signatureUrlDecoded = URLDecoder.decode(signature, "UTF-8");
                byte[] signatureBytes = Base64.decodeBase64((String)signatureUrlDecoded);
                doc = new SignedFormDocument();
                doc.setFileName(fc.getSubject(), "p7s");
                doc.setMimetype("application/pkcs7-signed-data");
                doc.setStream(signatureBytes);
                doc.setSubject(fc.getSubject() + " - signed");
                doc.setFilesize(doc.getStream().length);
            }
            return doc;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private final void validateInternalFileAttachments(ApplicationForm form) throws SelfServiceException {
        try {
            SAXReader reader = SaxReader.createReader();
            ByteArrayInputStream is = new ByteArrayInputStream(form.getStream());
            Document doc = reader.read((InputStream)is);
            is.close();
            boolean isDirty = false;
            List nodes = doc.selectNodes("//SECTIONS/SECTION/FIELDS/FIELD[@TYPE='FILE']", ".");
            if (nodes != null && nodes.size() > 0) {
                for (Element el : nodes) {
                    ExternalDocument exDoc;
                    String attachmentId;
                    Node node = el.selectSingleNode("VALUE");
                    if (node == null || !StringUtil.isValid(attachmentId = node.getText()) || (exDoc = CaseService.getExternalDocument(attachmentId, false)) != null && !exDoc.isDeleted()) continue;
                    node.detach();
                    isDirty = true;
                }
                if (isDirty) {
                    form.setStream(doc.asXML().getBytes("UTF-8"));
                }
            }
        }
        catch (DocumentException ex) {
            logger.warn((Object)"Cannot read internal attachment data, probably unvalidated formtemplate.");
        }
        catch (UnsupportedEncodingException ex) {
            logger.warn((Object)"Could not read XML data .. Unsupported encoding.");
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private boolean isTranslationRequest(WebContext context, FormTemplate ft) {
        HttpSession session = context.getRequest().getSession();
        String templateId = (String)session.getAttribute("form.template.id");
        String languageId = (String)session.getAttribute("form.language.id");
        if (templateId != null && languageId != null && ft.getId().equals(templateId)) {
            for (FormTranslation trans : ft.getTranslations()) {
                if (!trans.getIsocode().toLowerCase().equals(languageId.toLowerCase()) || !trans.isEnabled() || trans.isDeleted()) continue;
                return true;
            }
        }
        return false;
    }
}

