/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.renderers;

import is.hugvit.util.Util;
import java.util.Vector;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.User;

public class GoProFormHelper {
    public static String getComputedValue(String key, User user, GoProFormTemplate.GoProFormType version) {
        if (GoProFormHelper.isMetaDataKey("user", key)) {
            return GoProFormHelper.getMetaDataValue(key, user);
        }
        ComputedKey ck = GoProFormHelper.getKey(key, version);
        if (ck == null || user == null) {
            return "";
        }
        Address address = user.getAddress();
        switch (ck) {
            case USERNAME: {
                return user.getUsername();
            }
            case FULLNAME: {
                return user.getFullname();
            }
            case FIRSTNAME: {
                return user.getFirstName();
            }
            case MIDDLENAME: {
                return user.getMiddleName();
            }
            case LASTNAME: {
                return user.getLastName();
            }
            case INITIALS: {
                return user.getInitials();
            }
            case EMAIL: {
                return user.getEmail();
            }
            case SSN: {
                return user.getIdNumber();
            }
            case PHONE: 
            case PHONENUMBER: {
                return user.getHomephoneNumber();
            }
            case MOBILE: 
            case MOBILEPHONENUMBER: {
                return user.getMobilephoneNumber();
            }
            case LANGUAGE: {
                return user.getLocale();
            }
            case ADDRESS: 
            case STREETNAME: {
                return address != null ? address.getStreetName() : "";
            }
            case CITY: {
                return address != null ? address.getCity() : "";
            }
            case COUNTRY: {
                return address != null ? address.getCountry() : "";
            }
            case POSTCODE: {
                return address != null ? address.getPostcode() : "";
            }
            case STATE: {
                return address != null ? address.getState() : "";
            }
        }
        return "";
    }

    private static String getMetaDataValue(String key, BaseDocument doc) {
        String metaKey;
        Vector v;
        if (key != null && (v = Util.split((String)(metaKey = key.replace("[", "").replace("]", "").toLowerCase()), (String)".")) != null && v.size() == 3) {
            String lookupKey = (String)v.lastElement();
            for (MetaData meta : doc.getMetadata()) {
                if (!meta.getKey().equalsIgnoreCase(lookupKey)) continue;
                return meta.getValue();
            }
        }
        return "";
    }

    public static String getComputedValue(String key, Company com, GoProFormTemplate.GoProFormType version) {
        if (GoProFormHelper.isMetaDataKey("company", key)) {
            return GoProFormHelper.getMetaDataValue(key, com);
        }
        ComputedKey ck = GoProFormHelper.getKey(key, version);
        if (ck == null || com == null) {
            return "";
        }
        Address address = com.getAddress();
        switch (ck) {
            case COMPANYNAME: {
                return com.getName();
            }
            case COMPANYADDRESS: 
            case COMPANYSTREETNAME: {
                return address != null ? address.getStreetName() : "";
            }
            case COMPANYCITY: {
                return address != null ? address.getCity() : "";
            }
            case COMPANYCOUNTRY: {
                return address != null ? address.getCountry() : "";
            }
            case COMPANYPOSTCODE: {
                return address != null ? address.getPostcode() : "";
            }
        }
        return "";
    }

    public static String getComputedValue(String val, FormTemplate ft) {
        String value = "";
        String key = val.toLowerCase().replace("[", "").replace("]", "").replace("form.", "");
        if ("subject".equalsIgnoreCase(key)) {
            value = ft.getSubject();
        } else if ("category".equalsIgnoreCase(key)) {
            value = ft.getCategory();
        } else if ("description".equalsIgnoreCase(key)) {
            value = ft.getDescription();
        }
        return value;
    }

    private static boolean isMetaDataKey(String prefix, String key) {
        String metaKey;
        return key != null && (metaKey = key.replace("[", "").replace("]", "").toLowerCase()).startsWith(prefix.toLowerCase() + ".meta.");
    }

    private static ComputedKey getKey(String key, GoProFormTemplate.GoProFormType version) {
        ComputedKey ck = null;
        try {
            String lookupKey = key;
            Vector v = Util.split((String)key.replace("[", "").replace("]", ""), (String)".");
            if (GoProFormTemplate.GoProFormType.GOPRO_FORM_V1.equals((Object)version)) {
                if (v != null && v.size() == 2) {
                    lookupKey = ((String)v.get(1)).toUpperCase();
                }
                ck = ComputedKey.valueOf(lookupKey);
            } else if (GoProFormTemplate.GoProFormType.GOPRO_FORM_V2.equals((Object)version)) {
                if (v != null && v.size() == 3) {
                    String prefix = (String)v.get(0);
                    lookupKey = "company".equals(prefix.toLowerCase()) ? prefix.toUpperCase() + ((String)v.get(2)).toUpperCase() : ((String)v.get(2)).toUpperCase();
                } else if (v != null && v.size() == 2) {
                    String prefix = (String)v.get(0);
                    lookupKey = "company".equals(prefix.toLowerCase()) ? prefix.toUpperCase() + ((String)v.get(1)).toUpperCase() : ((String)v.get(1)).toUpperCase();
                }
                ck = ComputedKey.valueOf(lookupKey);
            }
        }
        catch (IllegalArgumentException ex) {
            ck = GoProFormHelper.getLegacyKey(key);
        }
        return ck;
    }

    private static ComputedKey getLegacyKey(String key) {
        if (key.equals("[GoPro.DetailedUserData.Users.UserName]")) {
            return ComputedKey.USERNAME;
        }
        if (key.equals("[GoPro.DetailedUserData.Users.FirstName]")) {
            return ComputedKey.FIRSTNAME;
        }
        if (key.equals("[GoPro.DetailedUserData.Users.MiddleName]")) {
            return ComputedKey.MIDDLENAME;
        }
        if (key.equals("[GoPro.DetailedUserData.Users.LastName]")) {
            return ComputedKey.LASTNAME;
        }
        if (key.equals("[GoPro.DetailedUserData.Users.Initials]")) {
            return ComputedKey.INITIALS;
        }
        if (key.equals("[GoPro.DetailedUserData.Users.Email]")) {
            return ComputedKey.EMAIL;
        }
        return null;
    }

    private static enum ComputedKey {
        USERNAME,
        FIRSTNAME,
        FULLNAME,
        MIDDLENAME,
        LASTNAME,
        INITIALS,
        EMAIL,
        SSN,
        PHONE,
        PHONENUMBER,
        MOBILE,
        MOBILEPHONENUMBER,
        ADDRESS,
        STREETNAME,
        POSTCODE,
        CITY,
        COUNTRY,
        STATE,
        FAMILYNUMBER,
        LANGUAGE,
        COMPANYNAME,
        COMPANYADDRESS,
        COMPANYSTREETNAME,
        COMPANYCITY,
        COMPANYPOSTCODE,
        COMPANYCOUNTRY;

    }
}

