/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.IFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.LotusFormTemplate;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.FormQueryUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.AbstractElement;

public class LotusFormQueryProcessor
implements IFormQuery {
    @Override
    public List<Attachment> getAttachments(ApplicationForm form) throws FormQueryException {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        return list;
    }

    @Override
    public Hashtable<String, String> getKeyValuePairs(ApplicationForm form) throws FormQueryException {
        Hashtable<String, String> list = new Hashtable<String, String>();
        try {
            String xpathQuery = "//instance[@id='Generated']/data//*";
            String xpathQuery2 = "//page[*]/field[*]/value";
            Document doc = FormQueryUtil.getFormAsDom4JDocument(form);
            FormQueryUtil.setDefaultNamespace((AbstractElement)doc.getRootElement(), null);
            List<Element> nodeList = FormQueryUtil.selectNodes(doc, xpathQuery, true);
            HashSet<String> dict = new HashSet<String>();
            FormTemplate ft = FormService.getFormTemplate(form.getFormtemplateId(), false);
            if (ft instanceof LotusFormTemplate) {
                int counter;
                String origKey;
                String key;
                String val;
                for (Element el : nodeList) {
                    val = el.getText();
                    key = el.getParent().getName() + "_" + el.getName();
                    if (dict.contains(key)) {
                        origKey = key;
                        counter = 1;
                        while (dict.contains(key)) {
                            key = origKey + "_" + counter;
                            ++counter;
                        }
                    }
                    if (key.equals("") || val.length() >= 65536) continue;
                    list.put(key, val);
                    dict.add(key);
                }
                nodeList = FormQueryUtil.selectNodes(doc, xpathQuery2, true);
                for (Element el : nodeList) {
                    val = el.getText();
                    key = el.getParent().valueOf("@sid");
                    if (key != null && dict.contains(key)) {
                        origKey = key;
                        counter = 1;
                        while (dict.contains(key)) {
                            key = origKey + "_" + counter;
                            ++counter;
                        }
                    }
                    if (key.equals("") || val.length() >= 65536) continue;
                    list.put(key, val);
                    dict.add(key);
                }
            }
            return list;
        }
        catch (SelfServiceException ex) {
            throw new FormQueryException(ex);
        }
    }

    @Override
    public boolean search(ApplicationForm form, String keyword) throws FormQueryException {
        boolean results = false;
        try {
            String xpathQuery = "//page/field/value[contains(text(),'" + keyword + "')]";
            Document doc = FormQueryUtil.getFormAsDom4JDocument(form);
            List<Element> list = FormQueryUtil.selectNodes(doc, xpathQuery, true);
            if (list != null && list.size() > 0) {
                results = true;
            }
            return results;
        }
        catch (SelfServiceException ex) {
            throw new FormQueryException(ex);
        }
    }

    @Override
    public Hashtable<String, String> getKeyFields(ApplicationForm form) throws FormQueryException {
        return new Hashtable<String, String>();
    }
}

