/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.gopro.selfservice.IFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.util.FormQueryUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class GoProFormV2QueryProcessor
implements IFormQuery {
    private static final Map<String, String> uris = new HashMap<String, String>();

    @Override
    public boolean search(ApplicationForm form, String keyword) throws FormQueryException {
        return false;
    }

    @Override
    public Hashtable<String, String> getKeyValuePairs(ApplicationForm form) throws FormQueryException {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        try {
            Document doc = FormQueryUtil.getFormAsDom4JDocument(form);
            XPath xpath = doc.createXPath("//gpf:value");
            xpath.setNamespaceURIs(uris);
            List valueNodes = xpath.selectNodes((Object)doc);
            for (Node node : valueNodes) {
                Element parent = node.getParent();
                boolean isBaseValue = !parent.getName().equals("field");
                String fieldId = parent.valueOf("@id");
                String fieldValue = node.getText();
                if (!isBaseValue) {
                    String itemOrder = parent.getParent().valueOf("@order");
                    fieldId = itemOrder != null && !"".equals(itemOrder) ? parent.valueOf("@id") + "_" + itemOrder : parent.valueOf("@id");
                }
                if (fieldId == null || "".equals(fieldId) || fieldValue == null || "".equals(fieldValue)) continue;
                ht.put(fieldId, fieldValue);
            }
            xpath = doc.createXPath("//gpf:selection");
            xpath.setNamespaceURIs(uris);
            valueNodes = xpath.selectNodes((Object)doc);
            for (Node node : valueNodes) {
                String key = node.valueOf("@id");
                String value = this.getMultiValue(node);
                if (key == null || "".equals(key) || value == null || "".equals(value)) continue;
                ht.put(key, value);
            }
            return ht;
        }
        catch (SelfServiceException ex) {
            throw new FormQueryException(ex);
        }
    }

    private String getMultiValue(Node node) {
        XPath xpath = null;
        if ("selection".equals(node.getName()) && "Select".equals(node.valueOf("@type"))) {
            xpath = node.createXPath("gpf:list");
            xpath.setNamespaceURIs(uris);
            Node listNode = xpath.selectSingleNode((Object)node);
            if (listNode != null) {
                return listNode.valueOf("@selected");
            }
        }
        xpath = node.createXPath("gpf:option[@selected = 'true'] | gpf:optionGroup/gpf:option[@selected = 'true'] ");
        xpath.setNamespaceURIs(uris);
        ArrayList<String> values = new ArrayList<String>();
        List nodeList = xpath.selectNodes((Object)node);
        for (Node optionNode : nodeList) {
            String optionValue = optionNode.valueOf("@value");
            if (optionValue == null || "".equals(optionValue)) continue;
            values.add(optionValue);
        }
        return StringUtils.join(values, (String)",");
    }

    @Override
    public List<Attachment> getAttachments(ApplicationForm form) throws FormQueryException {
        return new ArrayList<Attachment>();
    }

    @Override
    public Hashtable<String, String> getKeyFields(ApplicationForm form) throws FormQueryException {
        try {
            Hashtable<String, String> allFields = this.getKeyValuePairs(form);
            Hashtable<String, String> ht = new Hashtable<String, String>();
            Document doc = FormQueryUtil.getFormAsDom4JDocument(form);
            XPath xpath = doc.createXPath("//gpf:section/gpf:*[@key-field='true'] | //gpf:section/gpf:group/gpf:*[@key-field='true']");
            xpath.setNamespaceURIs(uris);
            List valueNodes = xpath.selectNodes((Object)doc);
            ArrayList<String> keyFieldIds = new ArrayList<String>();
            for (Node node : valueNodes) {
                String fieldId = node.valueOf("@id");
                if (fieldId == null || "".equals(fieldId)) continue;
                keyFieldIds.add(fieldId);
            }
            for (String fieldKey : keyFieldIds) {
                if (!allFields.containsKey(fieldKey)) continue;
                ht.put(fieldKey, allFields.get(fieldKey));
            }
            return ht;
        }
        catch (Exception ex) {
            throw new FormQueryException(ex);
        }
    }

    static {
        uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
    }
}

