/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.ICaseEngine;
import net.gopro.selfservice.IConfigEngine;
import net.gopro.selfservice.ITaskEngine;
import net.gopro.selfservice.IUserEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.TaskDalc;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.util.BaseDocumentUtil;
import org.apache.log4j.Logger;

public class TaskImpl
extends BaseImpl
implements ITaskEngine {
    protected TaskDalc dalc;
    protected IConfigEngine configEngine;
    protected IUserEngine userEngine;
    protected ICaseEngine caseEngine;
    private static final Logger logger = Logger.getLogger(TaskImpl.class);

    public TaskImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.configEngine = EngineFactory.getConfigEngine();
        this.userEngine = EngineFactory.getUserEngine();
        this.caseEngine = EngineFactory.getCaseEngine();
        this.dalc = new TaskDalc();
    }

    @Override
    public void createTask(Task task) throws SelfServiceException {
        this.throwIfNull(task, "Task cannot be null");
        try {
            SubDocument sub;
            BaseCase bc;
            this.throwIfNotValid(task.getSubject(), "The task subject is missing");
            this.throwIfNotValid(task.getCreatedById(), "The task author Id is missing");
            this.assertStringLength(task.getSubject(), 255);
            if (task.getDateCreated() == 0L) {
                task.setDateCreated(new Date().getTime());
            }
            if (task.getStartDate() == 0L) {
                task.setStartDate(new Date().getTime());
            }
            this.checkDocumentId(task);
            if (!this.isValid(task.getModifiedById())) {
                task.setModifiedById(task.getCreatedById());
            }
            if (this.isValid(task.getParentId()) && (bc = this.caseEngine.getCase(task.getParentId())) == null && (sub = this.caseEngine.getSubDocument(task.getParentId(), false)) == null) {
                logger.warn((Object)"Parent Id not found. Possible invalid reference or signing request.");
            }
            if (this.isValid(task.getTopParentId()) && (bc = this.caseEngine.getCase(task.getTopParentId())) == null) {
                throw new SelfServiceException("Invalid Top Parent Id. The Case was not found!");
            }
            if (!this.isValid(task.getResponsibleId())) {
                task.setResponsibleId(task.getCreatedById());
            } else {
                User respUser = this.userEngine.getUser(task.getResponsibleId());
                if (respUser == null) {
                    Contact respContact = this.userEngine.getContact(task.getResponsibleId());
                    if (respContact != null) {
                        task.setResponsibleId(respContact.getUserId());
                    } else {
                        throw new SelfServiceException("The responsible user was not found!");
                    }
                }
            }
            this.validateTaskCategory(task);
            this.validateTaskPriority(task);
            this.dalc.createTask(task);
            super.createMetaData(task, this.dalc);
            this.logAction(task.getId(), AuditLogEntry.DataType.TASK, AuditLogEntry.Action.CREATE);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateTask(Task task) throws SelfServiceException {
        this.throwIfNull(task, "Task cannot be null");
        try {
            this.throwIfNotValid(task.getId(), "The task Id is missing");
            this.throwIfNotValid(task.getSubject(), "The task subject is missing");
            this.assertStringLength(task.getSubject(), 255);
            this.validateTaskCategory(task);
            this.validateTaskPriority(task);
            if (!this.isValid(task.getResponsibleId())) {
                task.setResponsibleId(task.getCreatedById());
            }
            task.setDateModified(new Date().getTime());
            this.dalc.updateTask(task);
            this.updateMetaData(task, this.dalc);
            this.logAction(task.getId(), AuditLogEntry.DataType.TASK, AuditLogEntry.Action.UPDATE);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Task getTask(String taskId) throws SelfServiceException {
        try {
            Task task = this.dalc.getTask(taskId);
            if (task != null) {
                this.setMetaData(task, this.dalc);
            }
            return task;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteTask(String taskId) throws SelfServiceException {
        Task task = this.getTask(taskId);
        if (task == null) {
            throw new SelfServiceException("Invalid Task Id");
        }
        task.setDeleted(true);
        this.updateTask(task);
        this.logAction(task.getId(), AuditLogEntry.DataType.TASK, AuditLogEntry.Action.DELETE);
    }

    @Override
    public java.util.List<Task> getTasks() throws SelfServiceException {
        try {
            java.util.List<Task> tasks = this.dalc.getTasks();
            this.setTaskMetadata(tasks);
            return tasks;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public java.util.List<Task> getTasksByResponsibleUser(String responsibleUserId) throws SelfServiceException {
        try {
            java.util.List<Task> tasks = this.dalc.getTasksByResponsibleUser(responsibleUserId);
            this.setTaskMetadata(tasks);
            return tasks;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public java.util.List<Task> getTasksByParentDocument(String parentId) throws SelfServiceException {
        try {
            java.util.List<Task> tasks = this.dalc.getTasksByParentDocument(parentId);
            this.setTaskMetadata(tasks);
            return tasks;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void validateTaskCategory(Task task) throws SelfServiceException {
        List statusList = this.configEngine.getList("527DDC43A963ADAB000001426FD2551F");
        if (statusList != null) {
            ListItem item = statusList.getListItem(task.getCategoryId());
            if (item == null) {
                task.setCategoryId(this.getDefaultListEntry("527DDC43A963ADAB000001426FD2551F"));
            }
        } else {
            task.setCategoryId(this.getDefaultListEntry("527DDC43A963ADAB000001426FD2551F"));
        }
    }

    private void validateTaskPriority(Task task) throws SelfServiceException {
        List statusList = this.configEngine.getList("38A8EC5A82CC072E000001426FD1BB50");
        if (statusList != null) {
            ListItem item = statusList.getListItem(task.getPriorityId());
            if (item == null) {
                task.setPriorityId(this.getDefaultListEntry("38A8EC5A82CC072E000001426FD1BB50"));
            }
        } else {
            task.setPriorityId(this.getDefaultListEntry("38A8EC5A82CC072E000001426FD1BB50"));
        }
    }

    private String getDefaultListEntry(String listId) throws SelfServiceException {
        List list = this.configEngine.getList(listId);
        return list.getDefaultId();
    }

    private void setTaskMetadata(java.util.List<Task> list) throws SQLException {
        Vector<String> collectionIds = BaseDocumentUtil.getCollectionIds(list);
        java.util.List<MetaData> metadataList = this.dalc.getMetData(collectionIds);
        Hashtable<String, Task> bucket = new Hashtable<String, Task>();
        for (Task task : list) {
            bucket.put(task.getId(), task);
        }
        for (MetaData meta : metadataList) {
            ((Task)bucket.get(meta.getReferenceId())).getMetadata().add(meta);
        }
    }
}

