/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.gopro.selfservice.IQueueEngine;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.QueueDalc;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.routing.BrokerRelationEntry;
import net.gopro.selfservice.data.routing.PickUpQueueEntry;
import net.gopro.selfservice.data.routing.QueueLogEntry;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.data.routing.RoutingQueueInformationEntry;
import net.gopro.selfservice.filters.AuditLogFilter;
import net.gopro.selfservice.filters.RoutingLogFilter;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;

public class QueueImpl
extends BaseImpl
implements IQueueEngine {
    private static final Logger logger = Logger.getLogger(QueueImpl.class);
    protected QueueDalc dalc;

    public QueueImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new QueueDalc();
    }

    @Override
    public boolean createRoutingQueueEntry(RoutingQueueEntry entry) throws SelfServiceException {
        try {
            this.throwIfNull(entry, "Routing entry is null");
            this.throwIfNull((Object)entry.getDocumentType(), "No Document Type is defined");
            this.throwIfNotValid(entry.getDocumentId(), "Self Service Document Id is missing");
            this.throwIfNotValid(entry.getOrganizationId(), "Organization Id is missing");
            List<FormTemplate> ignoreList = this.getRoutingIgnoreList();
            if (!ignoreList.isEmpty()) {
                BaseCase bc;
                SubDocument sub;
                Vector<String> templateIds = BaseDocumentUtil.getCollectionIds(ignoreList);
                if (RoutingQueueEntry.DocumentType.CASE.equals((Object)entry.getDocumentType())) {
                    BaseCase bc2 = CaseService.getCase(entry.getDocumentId());
                    if (bc2 != null && bc2 instanceof FormCase && templateIds.contains(((FormCase)bc2).getFormtemplateId())) {
                        logger.debug((Object)String.format("Case \"%s\" rejected from routing queue. Form template is on ignore list!", bc2.getSubject()));
                        return false;
                    }
                } else if (RoutingQueueEntry.DocumentType.SUBDOCUMENT.equals((Object)entry.getDocumentType()) && (sub = CaseService.getSubDocument(entry.getDocumentId(), false)) != null && (bc = CaseService.getCase(sub.getCaseId())) != null && bc instanceof FormCase && templateIds.contains(((FormCase)bc).getFormtemplateId())) {
                    logger.debug((Object)String.format("Response document \"%s\" rejected from routing queue. Form template is on ignore list!", sub.getSubject()));
                    return false;
                }
            }
            boolean isInQueue = this.isDocumentInQueue(entry.getDocumentId());
            boolean isUpdateableType = Arrays.asList(RoutingQueueEntry.DocumentType.CASE, RoutingQueueEntry.DocumentType.CONTACT).contains((Object)entry.getDocumentType());
            if (isInQueue && !isUpdateableType) {
                return false;
            }
            if (isInQueue && RoutingQueueEntry.DocumentType.CASE.equals((Object)entry.getDocumentType())) {
                if (entry.isResend()) {
                    this.checkDocumentId(entry);
                    this.dalc.createRoutingQueueEntry(entry);
                    this.logAction(entry.getId(), AuditLogEntry.DataType.QUEUE_ENTRY, AuditLogEntry.Action.CREATE);
                    return true;
                }
                return false;
            }
            this.checkDocumentId(entry);
            this.dalc.createRoutingQueueEntry(entry);
            this.logAction(entry.getId(), AuditLogEntry.DataType.QUEUE_ENTRY, AuditLogEntry.Action.CREATE);
            return true;
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateRoutingQueueEntry(RoutingQueueEntry entry) throws SelfServiceException {
        try {
            this.throwIfNull(entry.getId(), "Routing Queue Id is missing");
            this.throwIfNull(entry, "Routing entry is null");
            this.throwIfNull((Object)entry.getDocumentType(), "No Document Type is defined");
            this.throwIfNotValid(entry.getDocumentId(), "Self Service Document Id is missing");
            this.throwIfNotValid(entry.getOrganizationId(), "Organization Id is missing");
            entry.setDateModified(new Date().getTime());
            this.dalc.updateRoutingQueueEntry(entry);
            this.logAction(entry.getId(), AuditLogEntry.DataType.QUEUE_ENTRY, AuditLogEntry.Action.UPDATE);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<RoutingQueueEntry> getRoutingQueue() throws SelfServiceException {
        try {
            return this.dalc.getRoutingQueue();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean removeRoutingQueueEntry(String queueId) throws SelfServiceException {
        try {
            return this.dalc.removeRoutingQueueEntry(queueId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createCaseRelation(String queueId, String goproDocumentId, String goproCaseId) throws SelfServiceException {
        try {
            this.throwIfNotValid(queueId, "Invalid queue Id");
            this.throwIfNotValid(goproDocumentId, "Invalid GoPro Id");
            RoutingQueueEntry entry = this.getRoutingQueueEntry(queueId);
            this.throwIfNull(entry, "Invalid queue Id");
            if (entry.getDocumentType().equals((Object)RoutingQueueEntry.DocumentType.CASE)) {
                this.dalc.createCaseRelation(entry.getDocumentId(), goproDocumentId, goproCaseId);
            } else {
                this.createDocumentRelation(queueId, goproDocumentId);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createDocumentRelation(String queueId, String goproDocumentId) throws SelfServiceException {
        try {
            this.throwIfNotValid(queueId, "Invalid queue Id");
            this.throwIfNotValid(goproDocumentId, "Invalid GoPro Id");
            RoutingQueueEntry entry = this.getRoutingQueueEntry(queueId);
            this.throwIfNull(entry, "Invalid queue Id");
            if (entry.getDocumentType().equals((Object)RoutingQueueEntry.DocumentType.CASE)) {
                this.dalc.createCaseRelation(entry.getDocumentId(), goproDocumentId, null);
            } else if (entry.getDocumentType().equals((Object)RoutingQueueEntry.DocumentType.SUBDOCUMENT)) {
                this.dalc.createSubDocumentRelation(queueId, entry.getDocumentId(), goproDocumentId);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public RoutingQueueEntry getRoutingQueueEntry(String queueId) throws SelfServiceException {
        try {
            return this.dalc.getRoutingQueueEntry(queueId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<RoutingQueueInformationEntry> getRoutingQueueStatus(RoutingLogFilter filter) throws SelfServiceException {
        try {
            this.throwIfNull(filter, "The filter cannot be null");
            Date dateFrom = filter.getStartDate();
            Date dateTo = filter.getEndDate();
            if (dateFrom != null && dateTo != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(dateFrom);
                cal.set(11, 0);
                cal.set(12, 0);
                dateFrom = cal.getTime();
                cal.setTime(dateTo);
                cal.set(11, 23);
                cal.set(12, 59);
                dateTo = cal.getTime();
            }
            List<RoutingQueueInformationEntry> list = new ArrayList<RoutingQueueInformationEntry>();
            if (dateFrom != null && dateTo != null && dateFrom.getTime() < dateTo.getTime()) {
                list = this.dalc.getRoutingQueueStatus(filter);
                if (!RoutingLogFilter.DeliveryStatus.NOTSENT.equals((Object)filter.getStatus())) {
                    list.addAll(this.dalc.getIncomingRoutingStatus(filter));
                }
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<PickUpQueueEntry> getPickUpQueue(RoutingLogFilter filter) throws SelfServiceException {
        try {
            PickUpQueueEntry pick;
            Iterator<PickUpQueueEntry> it;
            Date startDate = filter.getStartDate();
            Date endDate = filter.getEndDate();
            List<PickUpQueueEntry> list = this.dalc.getPickupQueue(filter);
            if (list.size() > 0) {
                AuditLogFilter logFilter = new AuditLogFilter();
                logFilter.setDateFilter(startDate, endDate);
                logFilter.addAction(AuditLogEntry.Action.PICKUP);
                AuditLog aul = this.auditLog.getAuditLog(logFilter);
                HashMap<String, PickUpQueueEntry> map = new HashMap<String, PickUpQueueEntry>();
                for (PickUpQueueEntry pen : list) {
                    map.put(pen.getId(), pen);
                }
                for (AuditLogEntry ale : aul.getEntries()) {
                    PickUpQueueEntry piq = (PickUpQueueEntry)map.get(ale.getDocumentId());
                    if (piq == null) continue;
                    piq.addPickUpEntry(ale);
                }
            }
            if (filter.getStatus() != null && !RoutingLogFilter.DeliveryStatus.ALL.equals((Object)filter.getStatus())) {
                it = list.iterator();
                while (it.hasNext()) {
                    pick = it.next();
                    if (RoutingLogFilter.DeliveryStatus.NOTSENT.equals((Object)filter.getStatus()) && pick.isPickedUp()) {
                        it.remove();
                        continue;
                    }
                    if (!RoutingLogFilter.DeliveryStatus.SENT.equals((Object)filter.getStatus()) || pick.isPickedUp()) continue;
                    it.remove();
                }
            }
            if (StringUtil.isValid(filter.getOrganizationId())) {
                it = list.iterator();
                while (it.hasNext()) {
                    pick = it.next();
                    if (filter.getOrganizationId().equals(pick.getOrganizationId())) continue;
                    it.remove();
                }
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createQueueLogEntry(QueueLogEntry entry) throws SelfServiceException {
        try {
            this.throwIfNull(entry, "Log entry cannot be null");
            this.throwIfNotValid(entry.getQueueId(), "The queue Id is missing");
            this.throwIfNotValid(entry.getLogLevel() != null, "The log level is missing");
            this.throwIfNotValid(entry.getMessage(), "The subject message is missing");
            this.dalc.createQueueLogEntry(entry);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<QueueLogEntry> getQueueLog(String queueId) throws SelfServiceException {
        try {
            return this.dalc.getQueueLog(queueId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createBrokerRelationEntry(BrokerRelationEntry entry) throws SelfServiceException {
        try {
            this.throwIfNull(entry, "The Broker Relation entry cannot be null");
            this.throwIfNotValid(entry.getId(), "The Document Id is missing");
            this.throwIfNotValid(entry.getOrganizationId(), "The Organization Id is missing");
            this.throwIfNotValid(entry.getQueueId(), "The Queue Id is missing");
            this.throwIfNotValid(entry.getTransactionId(), "The Broker Transaction Id is missing");
            this.dalc.createBrokerRelationEntry(entry);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public BrokerRelationEntry getBrokerRelationEntry(String queueId) throws SelfServiceException {
        try {
            return this.dalc.getBrokerRelationEntry(queueId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateBrokerRelation(BrokerRelationEntry entry) throws SelfServiceException {
        try {
            this.throwIfNull(entry, "The Broker Relation entry cannot be null");
            this.throwIfNotValid(entry.getId(), "The Document Id is missing");
            this.throwIfNotValid(entry.getOrganizationId(), "The Organization Id is missing");
            this.throwIfNotValid(entry.getQueueId(), "The Queue Id is missing");
            this.throwIfNotValid(entry.getTransactionId(), "The Broker Transaction Id is missing");
            entry.setDateModified(new Date().getTime());
            this.dalc.updateBrokerRelationEntry(entry);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<BrokerRelationEntry> getBrokerRelations(IQueueEngine.BrokerDocumentType type, IQueueEngine.BrokerRelationStatus status) throws SelfServiceException {
        try {
            this.throwIfNull((Object)type, "Broker Document Type must be specified");
            this.throwIfNull((Object)status, "Broker Relation Status must be specified");
            return this.dalc.getBrokerRelations(type, status);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateDocumentRelation(BaseDocument doc) throws SelfServiceException {
        block4: {
            try {
                if (doc instanceof BaseCase) {
                    this.dalc.updateCaseRelation((BaseCase)doc);
                    break block4;
                }
                if (doc instanceof SubDocument) {
                    this.dalc.updateSubdocumentRelation((SubDocument)doc);
                    break block4;
                }
                throw new SelfServiceException("Updating: " + doc.getClass().getSimpleName() + " is not supported");
            }
            catch (SQLException ex) {
                throw new SelfServiceException(ex);
            }
        }
    }

    @Override
    public List<RoutingQueueEntry> findEntries(String documentId) throws SelfServiceException {
        try {
            this.throwIfNull(documentId, "Document Id cannot be null");
            return this.dalc.findEntries(documentId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private final boolean isDocumentInQueue(String documentId) throws SQLException {
        return this.dalc.isDocumentInQueue(documentId);
    }

    private List<FormTemplate> getRoutingIgnoreList() throws SelfServiceException {
        ArrayList<FormTemplate> list = new ArrayList<FormTemplate>();
        String ignoreList = SelfServiceEngine.getConfig("queue.ignorelist");
        if (StringUtil.isValid(ignoreList)) {
            List<String> templateNames = Arrays.asList(ignoreList.split(","));
            for (int i = 0; i < templateNames.size(); ++i) {
                templateNames.set(i, templateNames.get(i).toLowerCase().trim());
            }
            List<FormTemplate> formTemplates = FormService.getFormTemplates();
            for (FormTemplate ft : formTemplates) {
                if (!templateNames.contains(ft.getSubject().toLowerCase().trim())) continue;
                list.add(ft);
            }
        }
        return list;
    }
}

