/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.IConfigEngine;
import net.gopro.selfservice.IFormEngine;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.FormDalc;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.FormGuidance;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.exceptions.FormTemplateException;
import net.gopro.selfservice.exceptions.GuidanceException;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;

public class FormImpl
extends BaseImpl
implements IFormEngine {
    protected FormDalc dalc;
    protected IConfigEngine configEngine;

    public FormImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new FormDalc();
        this.configEngine = EngineFactory.getConfigEngine();
    }

    @Override
    public void createFormTemplate(FormTemplate ft) throws FormTemplateException, SelfServiceException {
        this.throwIfNull(ft, "Form template is null");
        try {
            this.throwIfNotValid(ft.getSubject(), "Form Template name is missing");
            this.assertStringLength(ft.getSubject(), 255);
            this.assertStringLength(ft.getCategory(), 255);
            if (ft.getExtendedData() != null) {
                this.assertStringLength(ft.getExtendedData().getCustomClass(), 255);
            }
            ft.validate();
            this.checkDocumentId(ft);
            this.dalc.createFormTemplate(ft);
            this.logAction(ft.getId(), AuditLogEntry.DataType.FORMTEMPLATE, AuditLogEntry.Action.CREATE);
            this.createMetaData(ft, this.dalc);
            for (FormGuidance fg : ft.getGuidances()) {
                fg.setFormtemplateId(ft.getId());
                this.createGuidance(fg);
            }
            if (ft.isSecondaryEnabled()) {
                for (SecondaryForm sf : ft.getSecondaryReferences()) {
                    FormTemplate secondaryForm = this.getFormTemplate(sf.getTemplateId(), false);
                    Set<String> organizationIds = secondaryForm.getOrganizationIds();
                    for (String primaryOrganizationId : ft.getOrganizationIds()) {
                        if (organizationIds.contains(primaryOrganizationId)) continue;
                        this.dalc.createFormTemplateLink(sf.getTemplateId(), primaryOrganizationId);
                    }
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new FormTemplateException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (GuidanceException ex) {
            throw new FormTemplateException("Error adding guidance entry.", ex);
        }
    }

    @Override
    public String createFormTemplateLink(String templateId, String organizationId) throws SelfServiceException {
        try {
            this.throwIfNull(templateId, "Form template Id cannot be null");
            this.throwIfNotValid(organizationId, "Organization Id cannot be null");
            Hashtable<String, String> map = this.dalc.getFormTemplateMapping(organizationId);
            if (map.containsKey(templateId)) {
                return map.get(templateId);
            }
            return this.dalc.createFormTemplateLink(templateId, organizationId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteFormTemplate(String formtemplateId) throws FormTemplateException, SelfServiceException {
        FormTemplate ft = this.getFormTemplate(formtemplateId, false);
        try {
            if (ft == null) {
                throw new SelfServiceException("Invalid formtemplate Id");
            }
            ft.setDateModified(new Date().getTime());
            ft.setDeleted(true);
            this.dalc.updateFormTemplate(ft);
            this.logAction(ft.getId(), AuditLogEntry.DataType.FORMTEMPLATE, AuditLogEntry.Action.DELETE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public FormTemplate getFormTemplate(String formtemplateId, boolean includeStream) throws SelfServiceException {
        try {
            FormTemplate formTemplate = this.dalc.getFormTemplate(formtemplateId, includeStream);
            if (formTemplate != null && this.isFormTranslationEnabled()) {
                List<FormTranslation> translations = this.getTranslations(formTemplate.getId());
                formTemplate.getTranslations().addAll(translations);
            }
            if (formTemplate != null) {
                this.setMetaData(formTemplate, this.dalc);
            }
            return formTemplate;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException("Error processing formtemplate stream", ex);
        }
    }

    @Override
    public List<FormTemplate> getFormTemplates() throws SelfServiceException {
        try {
            List<FormTemplate> templateList = this.dalc.getFormTemplates();
            List<Organization> organizationList = this.configEngine.getOrganizations();
            Hashtable<String, Hashtable<String, String>> mapping = this.dalc.getFormTemplateMapping();
            for (FormTemplate template : templateList) {
                Hashtable<String, String> map = mapping.get(template.getId());
                if (map == null) continue;
                for (String organizationId : map.keySet()) {
                    Organization o = (Organization)BaseDocumentUtil.getDocumentFromList(organizationId, organizationList);
                    template.getOrganizations().add(o);
                    template.getLinkMap().put(organizationId, map.get(organizationId));
                }
            }
            return templateList;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<FormTemplate> getPrimaryFormTemplates() throws SelfServiceException {
        try {
            List<FormTemplate> templateList = this.dalc.getPrimaryFormTemplates();
            return templateList;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<FormTemplate> getFormTemplates(String organizationId) throws SelfServiceException {
        try {
            List<FormTemplate> templateList = this.dalc.getFormTemplates(organizationId);
            Hashtable<String, String> mapping = this.dalc.getFormTemplateMapping(organizationId);
            for (FormTemplate template : templateList) {
                if (!mapping.containsKey(template.getId())) continue;
                template.getLinkMap().put(organizationId, mapping.get(template.getId()));
            }
            return templateList;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateFormTemplate(FormTemplate ft) throws SelfServiceException, FormTemplateException {
        this.throwIfNull(ft, "Form template is null");
        try {
            this.throwIfNotValid(ft.getSubject(), "Form Template name is missing");
            this.assertStringLength(ft.getSubject(), 255);
            this.assertStringLength(ft.getCategory(), 255);
            if (ft.getExtendedData() != null) {
                this.assertStringLength(ft.getExtendedData().getCustomClass(), 255);
            }
            ft.validate();
            ft.setDateModified(new Date().getTime());
            this.dalc.updateFormTemplate(ft);
            this.logAction(ft.getId(), AuditLogEntry.DataType.FORMTEMPLATE, AuditLogEntry.Action.UPDATE);
            for (FormTemplateFile file : ft.getTemplateFiles()) {
                if (!file.isDirty()) continue;
                this.logAction(file.getId(), AuditLogEntry.DataType.FORMTEMPLATE_FILE, AuditLogEntry.Action.UPDATE);
            }
            if (ft.isSecondaryEnabled()) {
                for (SecondaryForm sf : ft.getSecondaryReferences()) {
                    FormTemplate secondaryForm = this.getFormTemplate(sf.getTemplateId(), false);
                    Set<String> organizationIds = secondaryForm.getOrganizationIds();
                    for (String primaryOrganizationId : ft.getOrganizationIds()) {
                        if (organizationIds.contains(primaryOrganizationId)) continue;
                        this.dalc.createFormTemplateLink(sf.getTemplateId(), primaryOrganizationId);
                    }
                }
            }
            this.updateMetaData(ft, this.dalc);
        }
        catch (IllegalArgumentException ex) {
            throw new FormTemplateException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createGuidance(FormGuidance fg) throws GuidanceException, SelfServiceException {
        this.throwIfNull(fg, "Guidance is null");
        try {
            this.throwIfNotValid(fg.getSubject(), "Guidance subject is missing");
            this.throwIfNotValid(fg.getBody(), "Guidance body is missing");
            this.throwIfNotValid(fg.getFormtemplateId(), "Form template Id is missing");
            this.assertStringLength(fg.getSubject(), 128);
            this.assertStringLength(fg.getUrlLink(), 256);
            this.assertStringLength(fg.getImage(), 255);
            this.checkDocumentId(fg);
            this.dalc.createGuidance(fg);
            this.logAction(fg.getId(), AuditLogEntry.DataType.GUIDANCE, AuditLogEntry.Action.CREATE);
        }
        catch (IllegalArgumentException ex) {
            throw new GuidanceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteGuidance(String guidanceId) throws GuidanceException, SelfServiceException {
        try {
            FormGuidance fg = this.dalc.getGuidance(guidanceId);
            if (fg == null) {
                throw new GuidanceException("Invalid guidance Id");
            }
            fg.setDateModified(new Date().getTime());
            fg.setDeleted(true);
            this.updateGuidance(fg);
            this.logAction(fg.getId(), AuditLogEntry.DataType.GUIDANCE, AuditLogEntry.Action.DELETE);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateGuidance(FormGuidance fg) throws GuidanceException, SelfServiceException {
        this.throwIfNull(fg, "Guidance is null");
        try {
            this.throwIfNotValid(fg.getSubject(), "Guidance subject is missing");
            this.throwIfNotValid(fg.getBody(), "Guidance body is missing");
            this.throwIfNotValid(fg.getFormtemplateId(), "Form template Id is missing");
            this.assertStringLength(fg.getSubject(), 128);
            this.assertStringLength(fg.getUrlLink(), 256);
            this.assertStringLength(fg.getImage(), 255);
            this.dalc.updateGuidance(fg);
            this.logAction(fg.getId(), AuditLogEntry.DataType.GUIDANCE, AuditLogEntry.Action.UPDATE);
        }
        catch (IllegalArgumentException ex) {
            throw new GuidanceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public FormTemplate getFormTemplateByToken(String idToken) throws SelfServiceException {
        try {
            String templateId;
            if (this.isValid(idToken) && this.isValid(templateId = this.dalc.getFormTemplateIdByToken(idToken))) {
                return this.getFormTemplate(templateId, true);
            }
            return null;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteFormTemplateLinks(String organizationId) throws SelfServiceException {
        try {
            if (StringUtil.isValid(organizationId)) {
                this.dalc.deleteFormTemplateLinks(organizationId);
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public FormTemplateFile getFormTemplateFile(String templateId, FormTemplateFile.Tag tag, boolean includeStream) throws SelfServiceException {
        try {
            this.throwIfNull((Object)tag, "The template Tag is not defined");
            this.throwIfNotValid(templateId, "The formtemplate Id is invalid");
            return this.dalc.getFormTemplateFile(templateId, tag, includeStream);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException("Error reading the template stream: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void createTranslation(FormTranslation trans) throws SelfServiceException {
        this.throwIfNull(trans, "The translation cannot be null");
        try {
            this.throwIfNotValid(trans.getTemplateId(), "The parent template Id is missing");
            this.throwIfNotValid(trans.getLanguage(), "The language name has to be specified");
            this.throwIfNotValid(trans.getIsocode(), "The ISO code is not specified");
            this.assertStringLength(trans.getLanguage(), 150);
            this.assertStringLength(trans.getIsocode(), 16);
            if (trans.getStream() == null || trans.getStream().length == 0) {
                throw new SelfServiceException("The translation stream is null");
            }
            List<FormTranslation> translations = this.getTranslations(trans.getTemplateId());
            for (FormTranslation ft : translations) {
                if (!ft.getIsocode().equalsIgnoreCase(trans.getIsocode())) continue;
                throw new SelfServiceException("The language " + trans.getLanguage() + " has already been created for this form template.");
            }
            this.checkDocumentId(trans);
            this.dalc.createTranslation(trans);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateTranslation(FormTranslation trans) throws SelfServiceException {
        this.throwIfNull(trans, "The translation cannot be null");
        try {
            this.throwIfNotValid(trans.getTemplateId(), "The parent template Id is missing");
            this.throwIfNotValid(trans.getLanguage(), "The language name has to be specified");
            this.throwIfNotValid(trans.getIsocode(), "The ISO code is not specified");
            this.assertStringLength(trans.getLanguage(), 150);
            this.assertStringLength(trans.getIsocode(), 16);
            if (trans.getStream() == null || trans.getStream().length == 0) {
                throw new SelfServiceException("The translation stream is null");
            }
            List<FormTranslation> translations = this.getTranslations(trans.getTemplateId());
            for (FormTranslation ft : translations) {
                if (ft.getId().equals(trans.getId()) || !ft.getIsocode().equalsIgnoreCase(trans.getIsocode())) continue;
                throw new SelfServiceException("The language " + trans.getLanguage() + " has already been created for this form template.");
            }
            trans.setDateModified(new Date().getTime());
            this.dalc.updateTranslation(trans);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<FormTranslation> getTranslations(String templateId) throws SelfServiceException {
        try {
            this.throwIfNotValid(templateId, "The formtemplate Id is invalid");
            return this.dalc.getTranslations(templateId);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public FormTranslation getTranslation(String translationId) throws SelfServiceException {
        try {
            this.throwIfNotValid(translationId, "The translation Id is invalid");
            return this.dalc.getTranslation(translationId);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<FormTranslation> getTranslations() throws SelfServiceException {
        try {
            return this.dalc.getTranslations();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    protected final boolean isFormTranslationEnabled() {
        String value = SelfServiceEngine.getConfig("goproforms.translations", null);
        return value != null && "true".equalsIgnoreCase(value);
    }
}

