/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.util.UID;
import java.sql.SQLException;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.ILogEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.IAccessControlled;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Reference;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.ThreadContext;

public abstract class BaseImpl {
    protected ILogEngine auditLog;

    public BaseImpl() throws SelfServiceException {
        if (this.auditLog == null) {
            this.initialize();
        }
    }

    protected void initialize() throws SelfServiceException {
        this.auditLog = EngineFactory.getLogEngine();
    }

    protected final void checkDocumentId(BaseDocument doc) {
        if (!this.isValid(doc.getId())) {
            doc.setId(UID.getUID());
        }
    }

    protected final boolean isValid(String s) {
        return s != null && !"".equals(s);
    }

    protected final void assertStringLength(String s, int length) throws IllegalArgumentException {
        if (s != null && s.length() > length) {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception");
            throw new IllegalArgumentException(String.format(rb.getString("common.stringlength"), length));
        }
    }

    protected final void throwIfNotValid(String s, String exceptionMessage) throws IllegalArgumentException {
        if (!this.isValid(s)) {
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    protected final void throwIfNotValid(boolean b, String exceptionMessage) throws IllegalArgumentException {
        if (!b) {
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    protected final void throwIfNull(Object o, String exceptionMessage) throws SelfServiceException {
        if (o == null) {
            throw new SelfServiceException(exceptionMessage);
        }
    }

    protected final void logAction(String documentId, AuditLogEntry.DataType type, AuditLogEntry.Action action) throws SelfServiceException {
        AuditLogEntry entry = new AuditLogEntry();
        entry.setDocumentId(documentId);
        entry.setDataType(type);
        entry.setAction(action);
        this.auditLog.createLogEntry(entry);
    }

    protected final void createMetaData(BaseDocument doc, BaseDalc dalc) throws SQLException, SelfServiceException {
        List<MetaData> metadata = doc.getMetadata();
        if (metadata.size() > 0) {
            for (MetaData meta : metadata) {
                this.throwIfNotValid(meta.getKey(), "Metadata Key is missing");
                this.throwIfNotValid(meta.getValue(), "Metadata value is missing");
                if (!this.isValid(meta.getReferenceId())) {
                    meta.setReferenceId(doc.getId());
                }
                if (meta.getKey().length() > 64) {
                    meta.setKey(meta.getKey().substring(0, 64));
                }
                this.checkDocumentId(meta);
            }
            dalc.createMetaData(doc);
        }
    }

    protected final void setMetaData(BaseDocument doc, BaseDalc dalc) throws SQLException {
        if (doc != null) {
            this.setMetaData(doc, dalc, false);
        }
    }

    protected final void setMetaData(BaseDocument doc, BaseDalc dalc, boolean includeDeleted) throws SQLException {
        if (doc != null) {
            doc.getMetadata().addAll(dalc.getMetaData(doc.getId(), includeDeleted));
        }
    }

    protected final void updateMetaData(BaseDocument doc, BaseDalc dalc) throws SQLException {
        if (doc != null) {
            dalc.updateMetaData(doc, dalc);
        }
    }

    protected void validateAccessControl(IAccessControlled doc) {
        boolean isAdminGroup = false;
        List<AccessControl> accessControlList = doc.getAccessControlList();
        for (AccessControl acl : accessControlList) {
            if (!AccessControl.AccessControlType.ROLE.equals((Object)acl.getEntityType()) || !"A2AAC04696D89CBC6C56EF934F892410".equals(acl.getEntityId())) continue;
            isAdminGroup = true;
        }
        if (!isAdminGroup) {
            AccessControl acl = new AccessControl();
            acl.setEntityId("A2AAC04696D89CBC6C56EF934F892410");
            acl.setEntityReference(new Reference("A2AAC04696D89CBC6C56EF934F892410", "administrator"));
            acl.setEntityType(AccessControl.AccessControlType.ROLE);
            acl.setBitmask(AccessControl.Permission.WRITE.getValue());
            accessControlList.add(acl);
        }
    }

    protected BirdUserPrincipal getUserContext() throws SelfServiceException {
        BirdUserPrincipal currentUser = ThreadContext.getCurrentUser();
        if (currentUser == null) {
            throw new SelfServiceException("No user context is available");
        }
        return currentUser;
    }
}

