/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.ConjunctionListType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.IndividualType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.NameType;
import net.gopro.gdf.data.PhoneNumberType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.gdf.helpers.RESTAddress;
import net.gopro.selfservice.gdf.helpers.RESTPhoneNumber;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class RESTIndividual {
    private static final Log logger = SelfServiceEngine.getLogger();

    public static final String createIndividual(Organization organization, User user) throws GoProDataStoreException {
        String goproId = null;
        try {
            goproId = RESTIndividual.lookupIndividual(organization, user);
            if (goproId != null) {
                return goproId;
            }
            IndividualType ind = RESTIndividual.createIndividualType(organization, user);
            goproId = RestHelper.createIndividual(organization, ind);
            if (goproId == null) {
                throw new GoProDataStoreException("Could not create Individual, Service returned null");
            }
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
        return goproId;
    }

    private static final IndividualType createIndividualType(Organization organization, User user) throws GoProDataStoreException, GdfServiceException {
        IndividualType ind = (IndividualType)RestHelper.getDocumentInitiationData(organization, 1009, null, null);
        ind.setID("00000000-0000-0000-0000-000000000000");
        ind.setSubject(user.getFullname());
        NameType name = new NameType();
        name.setFirstName(user.getFirstName());
        name.setLastName(user.getLastName());
        name.setMiddleName(user.getMiddleName());
        name.setInitials(user.getInitials());
        ind.setName(name);
        ind.setVisible(true);
        ind.addEmailAddress(user.getEmail());
        if (StringUtil.isValid(user.getIdNumber())) {
            ind.setIDNumber(user.getIdNumber());
        } else if (user.getUsername().length() == 10 && StringUtils.isNumeric((String)user.getUsername())) {
            ind.setIDNumber(user.getUsername());
        }
        List<PhoneNumberType> numberList = RESTPhoneNumber.createPhoneNumberTypes(organization, user.getHomephoneNumber(), user.getMobilephoneNumber());
        for (PhoneNumberType pnt : numberList) {
            ind.addPhoneNumber(pnt);
        }
        AddressType addressType = RESTAddress.createAddressType(organization, user.getAddress());
        if (ind.getAddressesCount() == 1) {
            ind.setAddress(0, addressType);
        } else {
            ind.addAddress(addressType);
        }
        MetaDataType meta = new MetaDataType();
        meta.setName("SelfServiceId");
        meta.setValue(user.getId());
        meta.setValueType(MetaValueType.STRING);
        ind.addMetaDataEntry(meta);
        try {
            if (StringUtil.isValid(user.getProfileImage())) {
                String filename = "profile-" + user.getUsername();
                BirdFile profileFile = SelfServiceEngine.getBirdSession().getDatabase().getFileByName(filename);
                if (profileFile != null) {
                    byte[] image = IOUtils.toByteArray((InputStream)profileFile.getBody());
                    FileAttachmentType ft = new FileAttachmentType();
                    ft.setEncoding("UTF-8");
                    ft.setFileName(FilenameUtils.getName((String)user.getProfileImage()));
                    ft.setFileSize((long)image.length);
                    ft.setMimeType("image/" + FilenameUtils.getExtension((String)ft.getFileName()).toLowerCase());
                    ft.setStream(image);
                    ind.setPhoto(ft);
                }
            }
        }
        catch (BirdException ex) {
            logger.error("Could not retrieve profile image: " + ex.getMessage());
        }
        catch (IOException ex) {
            logger.error("Could not retrieve profile image: " + ex.getMessage());
        }
        return ind;
    }

    private static String lookupIndividual(Organization organization, User user) throws GoProDataStoreException, GdfServiceException {
        String individualId = null;
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1009);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        filter.setLoadDefaultColumns(false);
        filter.setLoadColumns(Arrays.asList("_IDNumber", "_subject", "_emailAddresses"));
        FlexibleDataSetType dataset = null;
        if (StringUtil.isValid(user.getIdNumber())) {
            BinaryFilterExpressionType idNumberFilter = new BinaryFilterExpressionType();
            idNumberFilter.setPropertyName("_IDNumber");
            idNumberFilter.setOperator(FilterOperatorType.EQUAL);
            idNumberFilter.setValue((Object)user.getIdNumber());
            filter.setCustomFilter((FilterExpressionType)idNumberFilter);
            dataset = RestHelper.query(organization, filter);
            if (dataset != null && dataset.getData() != null && dataset.getData().getRowsCount() > 0) {
                individualId = dataset.getData().getRow(0).getID();
                logger.info("Found existing Individual in GoPro using Id-Number");
            }
        }
        if (individualId == null) {
            ConjunctionListType filterList = new ConjunctionListType();
            BinaryFilterExpressionType emailFilter = new BinaryFilterExpressionType();
            emailFilter.setPropertyName("_emailAddresses");
            emailFilter.setOperator(FilterOperatorType.CONTAINSONE);
            emailFilter.setInValues(Arrays.asList(user.getEmail()));
            BinaryFilterExpressionType fullnameFilter = new BinaryFilterExpressionType();
            fullnameFilter.setPropertyName("_subject");
            fullnameFilter.setOperator(FilterOperatorType.EQUAL);
            fullnameFilter.setValue((Object)user.getFullname());
            filterList.addElement((FilterExpressionType)emailFilter);
            filterList.addElement((FilterExpressionType)fullnameFilter);
            filter.setCustomFilter((FilterExpressionType)filterList);
            dataset = RestHelper.query(organization, filter);
            if (dataset != null && dataset.getData() != null && dataset.getData().getRowsCount() > 0) {
                individualId = dataset.getData().getRow(0).getID();
                logger.info("Found existing Individual in GoPro using Email and Fullname");
            }
            if (individualId == null) {
                filter.setCustomFilter((FilterExpressionType)emailFilter);
                dataset = RestHelper.query(organization, filter);
                if (dataset != null && dataset.getData() != null && dataset.getData().getRowsCount() > 0) {
                    individualId = dataset.getData().getRow(0).getID();
                    logger.info("Found existing Individual in GoPro using Email only");
                }
            }
        }
        if (individualId == null) {
            logger.info("Individual does not already exist in the Remote GoPro, needs to be created.");
        }
        return individualId;
    }
}

