/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import java.util.List;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.CaseTemplateType;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.CategoryRefType;
import net.gopro.gdf.data.ClientBaseRefType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.NameType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.UserRefType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.gdf.helpers.GDFMetadata;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.StringUtil;

public class RESTCase {
    public static CaseType createCaseType(Organization targetOrganization, FormCase fc) throws GoProDataStoreException, SelfServiceException {
        List<CaseTemplateType> caseTemplateList;
        String templateId;
        ApplicationForm form = fc.getApplicationForm();
        if (form == null) {
            throw new SelfServiceException("The application form for the case is missing.");
        }
        FormTemplate formTemplate = FormService.getFormTemplate(fc.getFormtemplateId(), false);
        if (formTemplate == null) {
            throw new SelfServiceException("The form template for the Form Case was not found!");
        }
        String formTemplateName = formTemplate.getExtendedData().getGoproAlias();
        if (!StringUtil.isValid(formTemplateName)) {
            formTemplateName = formTemplate.getSubject();
        }
        if ((templateId = RESTCase.getCaseTemplateId(caseTemplateList = RestHelper.getCaseTemplates(targetOrganization), formTemplateName)) == null) {
            throw new GoProDataStoreException(String.format("The Case Template \"%s\" was not found in the remote GoPro.", formTemplateName));
        }
        CaseType myCase = (CaseType)RestHelper.getDocumentInitiationData(targetOrganization, 1005, null, templateId);
        FormTemplateExtras ext = formTemplate.getExtendedData();
        if (ext == null || !ext.isGoproSubject() || !StringUtil.isValid(myCase.getSubject())) {
            myCase.setSubject(fc.getSubject());
        }
        myCase.setBody("");
        if (StringUtil.isValid(fc.getGoProCaseNumber())) {
            myCase.setCaseNumber(fc.getGoProCaseNumber());
            myCase.setDocumentNumber(fc.getGoProCaseNumber());
        } else {
            myCase.setCaseNumber("");
        }
        if (myCase.getCategory() == null) {
            CategoryRefType category = new CategoryRefType();
            category.setName("Self Service");
            myCase.setCategory(category);
            myCase.setID("00000000-0000-0000-0000-000000000000");
        }
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceCaseNumber");
        mt.setValueType(MetaValueType.STRING);
        mt.setValue(fc.getReferenceNumber());
        myCase.addMetaDataEntry(mt);
        if (formTemplate.getExtendedData() != null && StringUtil.isValid(formTemplate.getExtendedData().getGoproAgent())) {
            MetaDataType ma = new MetaDataType();
            ma.setName("$GoProWebServicesAgent");
            ma.setValueType(MetaValueType.STRING);
            ma.setValue(formTemplate.getExtendedData().getGoproAgent());
            myCase.addMetaDataEntry(ma);
        }
        myCase.setPersonalSensitive(fc.isPersonalSensitive());
        RESTCase.setMetaData(myCase, form);
        return myCase;
    }

    private static void setMetaData(CaseType caseType, ApplicationForm form) throws SelfServiceException {
        ExternalDocument appForm = CaseService.getExternalDocument(form.getId(), false);
        if (!(appForm instanceof ApplicationForm)) {
            throw new SelfServiceException("The application form for the Case for not found!");
        }
        GDFMetadata.setMetadata(appForm, (DocumentBaseType)caseType);
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceId");
        mt.setValueType(MetaValueType.STRING);
        mt.setValue(form.getCaseId());
        caseType.addMetaDataEntry(mt);
        MetaDataType mt2 = new MetaDataType();
        mt2.setName("CommunityId");
        mt2.setValueType(MetaValueType.STRING);
        mt2.setValue(form.getCaseId());
        caseType.addMetaDataEntry(mt2);
    }

    private static String getCaseTemplateId(List<CaseTemplateType> caseTemplateList, String formTemplateName) {
        for (CaseTemplateType caseTemplate : caseTemplateList) {
            if (!formTemplateName.equalsIgnoreCase(caseTemplate.getSubject())) continue;
            return caseTemplate.getID();
        }
        return null;
    }

    public static void setCaseTypeACL(CaseType caseType, User user, UserPrincipal up, GoProClientBaseReference ref, Organization destination) {
        ClientBaseRefType clientRef = new ClientBaseRefType();
        clientRef.setID(ref.getGoproId());
        clientRef.setName(user.getFullname());
        caseType.setInvolvedParty(clientRef);
        UserRefType userRef = new UserRefType();
        userRef.setName(user.getFullname());
        caseType.setCreatedBy(userRef);
        if (caseType.getResponsibleEmployee() == null) {
            boolean setDefaultResponsible = true;
            if (RemoteGoPro.GoPro.GOPRO_PORTAL.equals((Object)destination.getEndpoint().getGoproType())) {
                boolean bl = setDefaultResponsible = caseType.getOrganizationUnit() == null;
            }
            if (setDefaultResponsible) {
                ACLDocumentRefType acl = new ACLDocumentRefType();
                acl.setID(up.getUserProfile().getID());
                NameType nt = up.getUserProfile().getName();
                acl.setName(nt.getFirstName() + " " + nt.getLastName());
                caseType.setResponsibleEmployee(acl);
            }
        }
    }
}

