/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import is.hugvit.log.Log;
import java.util.Arrays;
import net.gopro.gdf.data.ACLDocumentRefType;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.CategoryRefType;
import net.gopro.gdf.data.ClientBaseRefType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.FolderType;
import net.gopro.gdf.data.ListType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.ListValueType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.NameType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.UserRefType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.DocumentStateType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.GDFDataHelper;
import net.gopro.selfservice.gdf.helpers.GDFMetadata;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.StringUtil;

public final class GDFCase {
    private static final Log logger = SelfServiceEngine.getLogger();

    public static CaseType getCase(DocumentService service, String caseId) throws GoProDataStoreException {
        CaseType caseType = null;
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.addFilterDocumentID(caseId);
        filter.setLoadBinaryData(false);
        filter.setDocumentFormType(1005);
        DocumentCollectionType coll = null;
        try {
            coll = service.getDocuments(filter, DocumentStateType.UNCHANGED);
        }
        catch (GdfServiceException ex) {
            logger.error("Error fetching parent Case: " + ex.getMessage());
        }
        if (coll != null && coll.getDocumentsCount() > 0) {
            if (coll.getDocumentsCount() != 1) {
                throw new GoProDataStoreException("More than 1 Case returned, expected only one!");
            }
            DocumentBaseType parentDoc = coll.getDocument(0);
            if (parentDoc instanceof CaseType) {
                caseType = (CaseType)coll.getDocument(0);
            } else {
                logger.warn("Parent document is not a Case!");
            }
        }
        return caseType;
    }

    public static FolderType getFolder(DocumentService service, String folderId) throws GoProDataStoreException {
        FolderType folderType = null;
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.addFilterDocumentID(folderId);
        filter.setLoadBinaryData(false);
        filter.setDocumentFormType(1045);
        DocumentCollectionType coll = null;
        try {
            coll = service.getDocuments(filter, DocumentStateType.UNCHANGED);
        }
        catch (GdfServiceException ex) {
            logger.error("Error fetching Folder: " + ex.getMessage());
        }
        if (coll != null && coll.getDocumentsCount() > 0) {
            if (coll.getDocumentsCount() != 1) {
                throw new GoProDataStoreException("More than 1 Folder returned, expected only one!");
            }
            DocumentBaseType parentDoc = coll.getDocument(0);
            if (parentDoc instanceof FolderType) {
                folderType = (FolderType)coll.getDocument(0);
            } else {
                logger.warn("Parent document is not a Case!");
            }
        }
        return folderType;
    }

    public static final CaseType createCaseType(DocumentService service, FormCase fc) throws GoProDataStoreException, GdfServiceException, SelfServiceException {
        ApplicationForm form = fc.getApplicationForm();
        if (form == null) {
            throw new SelfServiceException("The application form for the case is missing.");
        }
        FormTemplate formTemplate = FormService.getFormTemplate(fc.getFormtemplateId(), false);
        if (formTemplate == null) {
            throw new SelfServiceException("The form template for the Form Case was not found!");
        }
        String formTemplateName = formTemplate.getExtendedData().getGoproAlias();
        if (!StringUtil.isValid(formTemplateName)) {
            formTemplateName = formTemplate.getSubject();
        }
        String templateId = GDFCase.getCaseTemplateId(service, formTemplateName);
        CaseType mycase = GDFCase.getCaseType(service, templateId);
        FormTemplateExtras ext = formTemplate.getExtendedData();
        if (ext == null || !ext.isGoproSubject() || !StringUtil.isValid(mycase.getSubject())) {
            mycase.setSubject(fc.getSubject());
        }
        mycase.setBody("");
        if (StringUtil.isValid(fc.getGoProCaseNumber())) {
            mycase.setCaseNumber(fc.getGoProCaseNumber());
            mycase.setDocumentNumber(fc.getGoProCaseNumber());
        } else {
            mycase.setCaseNumber("");
        }
        if (mycase.getCategory() == null) {
            CategoryRefType category = new CategoryRefType();
            category.setName("Self Service");
            mycase.setCategory(category);
            mycase.setID("00000000-0000-0000-0000-000000000000");
        }
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceCaseNumber");
        mt.setValueType(MetaValueType.STRING);
        mt.setValue(fc.getReferenceNumber());
        mycase.addMetaDataEntry(mt);
        if (formTemplate.getExtendedData() != null && StringUtil.isValid(formTemplate.getExtendedData().getGoproAgent())) {
            MetaDataType ma = new MetaDataType();
            ma.setName("$GoProWebServicesAgent");
            ma.setValueType(MetaValueType.STRING);
            ma.setValue(formTemplate.getExtendedData().getGoproAgent());
            mycase.addMetaDataEntry(ma);
        }
        mycase.setPersonalSensitive(fc.isPersonalSensitive());
        ListType goproStatusList = GDFDataHelper.getList(service, "CaseStatuses");
        List statusList = ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
        StatusListItem statusItem = (StatusListItem)statusList.getListItem(fc.getStatusId());
        if (statusItem != null) {
            ListValueType listType = GDFDataHelper.getListValueType(Arrays.asList(statusItem.getSubject(), statusItem.getAlias()), goproStatusList);
            if (listType != null) {
                ListValueRefType lStatus = new ListValueRefType();
                lStatus.setID(listType.getID());
                lStatus.setName(listType.getName());
                mycase.setStatus(lStatus);
            } else {
                logger.warn("The GoPro Case Template does not have the Case Status: " + statusItem.getSubject());
            }
        }
        GDFCase.setMetaData(mycase, form);
        GDFMetadata.setMetadata(fc, (DocumentBaseType)mycase);
        return mycase;
    }

    public static final void setCaseTypeACL(CaseType caseType, User user, UserPrincipal up, GoProClientBaseReference ref, Endpoint endpoint) {
        ClientBaseRefType clientRef = new ClientBaseRefType();
        clientRef.setID(ref.getGoproId());
        clientRef.setName(user.getFullname());
        caseType.setInvolvedParty(clientRef);
        UserRefType userRef = new UserRefType();
        userRef.setName(user.getFullname());
        caseType.setCreatedBy(userRef);
        if (caseType.getResponsibleEmployee() == null) {
            boolean setDefaultResponsible = true;
            if (RemoteGoPro.GoPro.GOPRO_PORTAL.equals((Object)endpoint.getGoproType())) {
                boolean bl = setDefaultResponsible = caseType.getOrganizationUnit() == null;
            }
            if (setDefaultResponsible) {
                ACLDocumentRefType acl = new ACLDocumentRefType();
                acl.setID(up.getUserProfile().getID());
                NameType nt = up.getUserProfile().getName();
                acl.setName(nt.getFirstName() + " " + nt.getLastName());
                caseType.setResponsibleEmployee(acl);
            }
        }
    }

    public static final void setMetaData(CaseType caseType, ApplicationForm form) throws SelfServiceException {
        ExternalDocument appForm = CaseService.getExternalDocument(form.getId(), false);
        if (!(appForm instanceof ApplicationForm)) {
            throw new SelfServiceException("The application form for the Case for not found!");
        }
        GDFMetadata.setMetadata(appForm, (DocumentBaseType)caseType);
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceId");
        mt.setValueType(MetaValueType.STRING);
        mt.setValue(form.getCaseId());
        caseType.addMetaDataEntry(mt);
        MetaDataType mt2 = new MetaDataType();
        mt2.setName("CommunityId");
        mt2.setValueType(MetaValueType.STRING);
        mt2.setValue(form.getCaseId());
        caseType.addMetaDataEntry(mt2);
    }

    private static final CaseType getCaseType(DocumentService service, String templateId) throws GdfServiceException, GoProDataStoreException {
        DocumentCollectionType dc = service.getDocumentInitiationData(null, 1005, templateId);
        if (dc == null || dc.getDocumentsCount() == 0) {
            throw new GoProDataStoreException("The Document initiation data for the Case is invalid.");
        }
        return (CaseType)dc.getDocument(0);
    }

    private static final String getCaseTemplateId(DocumentService service, String caseTypeName) throws GdfServiceException, GoProDataStoreException {
        DocumentFilterType caseTypeFilter = GDFCase.createCaseTemplateFilter(caseTypeName);
        FlexibleDataSetType fds = service.getDocumentHeaders(caseTypeFilter);
        if (fds == null || fds.getData().getRowsCount() == 0) {
            throw new GoProDataStoreException("The Case Template \"" + caseTypeName + "\" does not exists in the remote GoPro.");
        }
        if (fds.getData().getRowsCount() > 1) {
            logger.warn("More than 1 Case Template Types found with the name " + caseTypeName);
        }
        return fds.getData().getRow(0).getID();
    }

    private static final DocumentFilterType createCaseTemplateFilter(String caseTypeName) {
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1033);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        BinaryFilterExpressionType subjectFilter = new BinaryFilterExpressionType();
        subjectFilter.setPropertyName("_subject");
        subjectFilter.setValue((Object)caseTypeName);
        subjectFilter.setOperator(FilterOperatorType.EQUAL);
        filter.setCustomFilter((FilterExpressionType)subjectFilter);
        return filter;
    }
}

