/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.forms.v1.impl;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.BaseFormTranslation;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.services.FormService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class FormTranslationImpl
extends BaseFormTranslation {
    public FormTranslationImpl(FormTemplate template) {
        super(template);
    }

    @Override
    public Document getTranslationTemplate() throws SelfServiceException, FormException {
        FormTemplateFile templateFile = FormService.getFormTemplateFile(this.formTemplate.getId(), FormTemplateFile.Tag.DATA, true);
        if (templateFile == null) {
            throw new SelfServiceException("Invalid form template Id, No form template was found.");
        }
        Document doc = FormsUtil.createDocument(templateFile.getStream());
        Document transDoc = this.createTranslationTemplate();
        Element translationEl = (Element)transDoc.getRootElement().selectSingleNode("translation");
        List pageNodes = doc.selectNodes("//PAGES/PAGE");
        for (Object node : pageNodes) {
            Element el = ((Element)translationEl.selectSingleNode("pages")).addElement("page");
            el.addAttribute("key", node.valueOf("@ID"));
            Node labelNode = node.selectSingleNode("PAGELABEL");
            if (labelNode == null) continue;
            el.addAttribute("original", labelNode.getText());
            el.setText(labelNode.getText());
        }
        List sectionNodes = doc.selectNodes("//SECTIONS/SECTION");
        for (Node node : sectionNodes) {
            Element el = ((Element)translationEl.selectSingleNode("sections")).addElement("section");
            el.addAttribute("key", node.valueOf("@ID"));
            Node labelNode = node.selectSingleNode("SECTIONLABEL");
            if (labelNode == null) continue;
            el.addAttribute("original", labelNode.getText());
            el.setText(labelNode.getText());
        }
        List fieldNodes = doc.selectNodes("//FIELD");
        for (Node node : fieldNodes) {
            List<String> multiTypes;
            String nodeKey = node.valueOf("@ID");
            String fieldType = node.valueOf("@TYPE");
            Element el = ((Element)translationEl.selectSingleNode("fields")).addElement("field");
            el.addAttribute("key", nodeKey);
            el.addAttribute("type", fieldType.toLowerCase());
            Element elLabel = el.addElement("label");
            Node nodeLabel = node.selectSingleNode("FIELDLABEL");
            if (nodeLabel != null) {
                elLabel.addAttribute("original", nodeLabel.getText());
                elLabel.setText(nodeLabel.getText());
            }
            if (!(multiTypes = Arrays.asList("LISTBOX", "CHECKBOX", "RADIO")).contains(fieldType)) continue;
            List valueNodes = node.selectNodes("VALUE");
            for (Node valueNode : valueNodes) {
                Element elValue = el.addElement("value");
                elValue.addAttribute("key", valueNode.getText());
                elValue.setText(valueNode.getText());
            }
        }
        return transDoc;
    }

    @Override
    public Document translateForm(FormTemplateFile dataXmlFile, Document translationDoc) throws FormException {
        Document doc = FormsUtil.createDocument(dataXmlFile.getStream());
        Hashtable<String, String> bucket = this.getTranslationBucket(translationDoc);
        List pageNodes = doc.getRootElement().selectNodes("PAGES/PAGE");
        for (Node pageNode : pageNodes) {
            this.translateNode(pageNode.valueOf("@ID"), BaseFormTranslation.FieldType.PAGE, pageNode.selectSingleNode("PAGELABEL"), bucket);
            List sectionNodes = pageNode.selectNodes("SECTIONS/SECTION");
            for (Node sectionNode : sectionNodes) {
                this.translateNode(sectionNode.valueOf("@ID"), BaseFormTranslation.FieldType.SECTION, sectionNode.selectSingleNode("SECTIONLABEL"), bucket);
                List fieldNodes = sectionNode.selectNodes("FIELDS/FIELD");
                for (Node fieldNode : fieldNodes) {
                    this.translateNode(fieldNode.valueOf("@ID"), BaseFormTranslation.FieldType.LABEL, fieldNode.selectSingleNode("FIELDLABEL"), bucket);
                    String fieldType = fieldNode.valueOf("@TYPE");
                    List<String> multiTypes = Arrays.asList("LISTBOX", "CHECKBOX", "RADIO");
                    if (!multiTypes.contains(fieldType)) continue;
                    List valueNodes = fieldNode.selectNodes("VALUE");
                    for (int i = 0; i < valueNodes.size(); ++i) {
                        String optionKey = fieldNode.valueOf("@ID") + "-option-" + (i + 1);
                        if (!bucket.containsKey(optionKey)) continue;
                        ((Node)valueNodes.get(i)).setText(bucket.get(optionKey));
                    }
                }
            }
        }
        return doc;
    }
}

